/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;

public abstract class GrReferenceElementImpl
extends GroovyPsiElementImpl
implements GrReferenceElement {
    public GrReferenceElementImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/GrReferenceElementImpl.<init> must not be null");
        }
        super(node);
    }

    public PsiReference getReference() {
        return this;
    }

    @Override
    public String getReferenceName() {
        PsiElement nameElement = this.getReferenceNameElement();
        if (nameElement != null) {
            return nameElement.getText();
        }
        return null;
    }

    @Override
    @Nullable
    public PsiElement getReferenceNameElement() {
        return this.findChildByType(GroovyTokenTypes.mIDENT);
    }

    public PsiElement getElement() {
        return this;
    }

    public TextRange getRangeInElement() {
        PsiElement refNameElement = this.getReferenceNameElement();
        if (refNameElement != null) {
            int offsetInParent = refNameElement.getStartOffsetInParent();
            return new TextRange(offsetInParent, offsetInParent + refNameElement.getTextLength());
        }
        return new TextRange(0, this.getTextLength());
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        PsiElement nameElement = this.getReferenceNameElement();
        if (nameElement != null) {
            ASTNode node = nameElement.getNode();
            ASTNode newNameNode = GroovyPsiElementFactory.getInstance(this.getProject()).createReferenceNameFromText(newElementName).getNode();
            assert (newNameNode != null && node != null);
            node.getTreeParent().replaceChild(node, newNameNode);
        }
        return this;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/GrReferenceElementImpl.bindToElement must not be null");
        }
        if (this.isReferenceTo(element)) {
            return this;
        }
        if (element instanceof PsiClass) {
            String newName = ((PsiClass)element).getName();
            this.handleElementRename(newName);
            if (this.isReferenceTo(element)) {
                return this;
            }
            return this.bindWithQualifiedRef(((PsiClass)element).getQualifiedName());
        }
        if (element instanceof PsiMember) {
            PsiMember member = (PsiMember)element;
            if (!this.isPhysical()) {
                return this;
            }
            PsiClass psiClass = member.getContainingClass();
            if (psiClass == null) {
                throw new IncorrectOperationException();
            }
            String qName = psiClass.getQualifiedName() + "." + member.getName();
            return this.bindWithQualifiedRef(qName);
        }
        if (element instanceof PsiPackage) {
            String qName = ((PsiPackage)element).getQualifiedName();
            return this.bindWithQualifiedRef(qName);
        }
        throw new IncorrectOperationException("Cannot bind to:" + element + " of class " + element.getClass());
    }

    protected abstract PsiElement bindWithQualifiedRef(String var1);

    protected boolean bindsCorrectly(PsiElement element) {
        return this.isReferenceTo(element);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiType[] getTypeArguments() {
        PsiType[] psiTypeArray;
        GrTypeArgumentList typeArgsList = this.getTypeArgumentList();
        if (typeArgsList == null) {
            psiTypeArray = PsiType.EMPTY_ARRAY;
            if (PsiType.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/GrReferenceElementImpl.getTypeArguments must not return null");
            return psiTypeArray;
        }
        GrTypeElement[] args = typeArgsList.getTypeArgumentElements();
        if (args.length == 0) {
            psiTypeArray = PsiType.EMPTY_ARRAY;
            if (PsiType.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/GrReferenceElementImpl.getTypeArguments must not return null");
            return psiTypeArray;
        }
        PsiType[] result = new PsiType[args.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = args[i].getType();
        }
        psiTypeArray = result;
        if (result != null) return psiTypeArray;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/GrReferenceElementImpl.getTypeArguments must not return null");
    }

    @Override
    @Nullable
    public GrTypeArgumentList getTypeArgumentList() {
        return (GrTypeArgumentList)this.findChildByClass(GrTypeArgumentList.class);
    }
}

