/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTupleDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrExpressionImpl;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ResolverProcessor;

public class GrAssignmentExpressionImpl
extends GrExpressionImpl
implements GrAssignmentExpression {
    public GrAssignmentExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrAssignmentExpressionImpl.<init> must not be null");
        }
        super(node);
    }

    public String toString() {
        return "Assignment expression";
    }

    @Override
    public boolean isTupleAssignment() {
        return this.getFirstChild() instanceof GrTupleDeclaration;
    }

    @Override
    @NotNull
    public GrExpression getLValue() {
        GrExpression grExpression = (GrExpression)this.findNotNullChildByClass(GrExpression.class);
        if (grExpression == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrAssignmentExpressionImpl.getLValue must not return null");
        }
        return grExpression;
    }

    @Override
    @Nullable
    public GrExpression getRValue() {
        GrExpression[] exprs = (GrExpression[])this.findChildrenByClass(GrExpression.class);
        if (exprs.length > 1) {
            return exprs[1];
        }
        return null;
    }

    @Override
    public IElementType getOperationToken() {
        return this.findChildByType(GroovyTokenTypes.ASSIGN_OP_SET).getNode().getElementType();
    }

    @Override
    public PsiType getType() {
        return this.getLValue().getType();
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrAssignmentExpressionImpl.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrAssignmentExpressionImpl.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrAssignmentExpressionImpl.processDeclarations must not be null");
        }
        if (lastParent != null) {
            return true;
        }
        GrExpression lValue = this.getLValue();
        if (lValue instanceof GrReferenceExpression) {
            String refName;
            String string = refName = processor instanceof ResolverProcessor ? ((ResolverProcessor)processor).getName() : null;
            if (GrAssignmentExpressionImpl.isDeclarationAssignment((GrReferenceExpression)lValue, refName) && !processor.execute((PsiElement)lValue, ResolveState.initial())) {
                return false;
            }
        }
        return true;
    }

    private static boolean isDeclarationAssignment(@NotNull GrReferenceExpression lRefExpr, @Nullable String nameHint) {
        PsiElement target;
        if (lRefExpr == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrAssignmentExpressionImpl.isDeclarationAssignment must not be null");
        }
        return (nameHint == null || nameHint.equals(lRefExpr.getName())) && !((target = lRefExpr.resolve()) instanceof PsiVariable) && !(target instanceof GrAccessorMethod);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitAssignmentExpression(this);
    }
}

