/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.types;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClosureParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClosureSignature;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.types.GrClosureParameterImpl;

public class GrClosureSignatureImpl
implements GrClosureSignature {
    private final boolean myIsVarargs;
    @Nullable
    private final PsiType myReturnType;
    @NotNull
    private final GrClosureParameter[] myParameters;

    public GrClosureSignatureImpl(@NotNull PsiParameter[] parameters, @Nullable PsiType returnType, @NotNull PsiSubstitutor substitutor) {
        if (parameters == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/types/GrClosureSignatureImpl.<init> must not be null");
        }
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/types/GrClosureSignatureImpl.<init> must not be null");
        }
        this.myReturnType = substitutor.substitute(returnType);
        int length = parameters.length;
        this.myParameters = new GrClosureParameter[length];
        for (int i = 0; i < length; ++i) {
            this.myParameters[i] = new GrClosureParameterImpl(parameters[i], substitutor);
        }
        this.myIsVarargs = length > 0 ? this.myParameters[length - 1].getType() instanceof PsiArrayType : false;
    }

    public GrClosureSignatureImpl(PsiParameter[] parameters, PsiType returnType) {
        this(parameters, returnType, PsiSubstitutor.EMPTY);
    }

    public GrClosureSignatureImpl(PsiParameter[] parameters) {
        this(parameters, null);
    }

    public GrClosureSignatureImpl(@NotNull GrClosableBlock block) {
        if (block == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/types/GrClosureSignatureImpl.<init> must not be null");
        }
        this(block.getAllParameters(), block.getReturnType());
    }

    public GrClosureSignatureImpl(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/types/GrClosureSignatureImpl.<init> must not be null");
        }
        this(method, PsiSubstitutor.EMPTY);
    }

    public GrClosureSignatureImpl(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor) {
        if (method == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/types/GrClosureSignatureImpl.<init> must not be null");
        }
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/types/GrClosureSignatureImpl.<init> must not be null");
        }
        this(method.getParameterList().getParameters(), method.getReturnType(), substitutor);
    }

    private GrClosureSignatureImpl(@NotNull GrClosureParameter[] params, @Nullable PsiType returnType, boolean isVarArgs) {
        if (params == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/types/GrClosureSignatureImpl.<init> must not be null");
        }
        this.myParameters = params;
        this.myReturnType = returnType;
        this.myIsVarargs = isVarArgs;
    }

    @Override
    public boolean isVarargs() {
        return this.myIsVarargs;
    }

    @Override
    @Nullable
    public PsiType getReturnType() {
        return this.myReturnType;
    }

    @Override
    @NotNull
    public GrClosureParameter[] getParameters() {
        GrClosureParameter[] result = new GrClosureParameter[this.myParameters.length];
        System.arraycopy(this.myParameters, 0, result, 0, this.myParameters.length);
        if (result == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/types/GrClosureSignatureImpl.getParameters must not return null");
        }
        return result;
    }

    @Override
    @Nullable
    public GrClosureSignature curry(int count) {
        if (count > this.myParameters.length) {
            if (this.isVarargs()) {
                return new GrClosureSignatureImpl(GrClosureParameter.EMPTY_ARRAY, this.myReturnType);
            }
            return null;
        }
        GrClosureParameter[] newParams = new GrClosureParameter[this.myParameters.length - count];
        System.arraycopy(this.myParameters, count, newParams, 0, newParams.length);
        return new GrClosureSignatureImpl(newParams, this.myReturnType, this.myIsVarargs);
    }

    @Override
    public boolean isValid() {
        for (GrClosureParameter parameter : this.myParameters) {
            if (parameter.isValid()) continue;
            return false;
        }
        return this.myReturnType == null || this.myReturnType.isValid();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GrClosureSignature) {
            return Comparing.equal((Object[])this.myParameters, (Object[])((GrClosureSignature)obj).getParameters()) && Comparing.equal((Object)this.myIsVarargs, (Object)((GrClosureSignature)obj).isVarargs()) && Comparing.equal((Object)this.myReturnType, (Object)((GrClosureSignature)obj).getReturnType());
        }
        return super.equals(obj);
    }

    @Nullable
    public static GrClosureSignature getLeastUpperBound(@NotNull GrClosureSignature signature1, @NotNull GrClosureSignature signature2, PsiManager manager) {
        GrClosureParameter[] parameters2;
        if (signature1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/types/GrClosureSignatureImpl.getLeastUpperBound must not be null");
        }
        if (signature2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/types/GrClosureSignatureImpl.getLeastUpperBound must not be null");
        }
        GrClosureParameter[] parameters1 = signature1.getParameters();
        if (parameters1.length == (parameters2 = signature2.getParameters()).length) {
            GrClosureParameter[] params = new GrClosureParameter[parameters1.length];
            for (int i = 0; i < params.length; ++i) {
                PsiType type = GenericsUtil.getGreatestLowerBound((PsiType)parameters1[i].getType(), (PsiType)parameters2[i].getType());
                boolean opt = parameters1[i].isOptional() && parameters2[i].isOptional();
                params[i] = new GrClosureParameterImpl(type, opt, null);
            }
            PsiType s1type = signature1.getReturnType();
            PsiType s2type = signature2.getReturnType();
            PsiType returnType = null;
            if (s1type != null && s2type != null) {
                returnType = TypesUtil.getLeastUpperBound(s1type, s2type, manager);
            }
            boolean isVarArgs = signature1.isVarargs() && signature2.isVarargs();
            return new GrClosureSignatureImpl(params, returnType, isVarArgs);
        }
        return null;
    }
}

