/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs.elements;

import com.intellij.lang.ASTNode;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrStubElementType;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrImplementsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef.GrImplementsClauseImpl;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrReferenceListStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.impl.GrReferenceListStubImpl;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrDirectInheritorsIndex;

public class GrImplementsClauseElementType
extends GrStubElementType<GrReferenceListStub, GrImplementsClause> {
    public GrImplementsClauseElementType() {
        super("implements clause");
    }

    @Override
    public GrImplementsClause createElement(ASTNode node) {
        return new GrImplementsClauseImpl(node);
    }

    public GrImplementsClause createPsi(GrReferenceListStub stub) {
        return new GrImplementsClauseImpl(stub);
    }

    public GrReferenceListStub createStub(GrImplementsClause psi, StubElement parentStub) {
        Object[] elements = psi.getReferenceElements();
        String[] refNames = (String[])ContainerUtil.map((Object[])elements, (Function)new Function<GrCodeReferenceElement, String>(){

            @Nullable
            public String fun(GrCodeReferenceElement element) {
                return element.getReferenceName();
            }
        }, (Object[])new String[elements.length]);
        return new GrReferenceListStubImpl(parentStub, GroovyElementTypes.IMPLEMENTS_CLAUSE, refNames);
    }

    public void serialize(GrReferenceListStub stub, StubOutputStream dataStream) throws IOException {
        String[] names = stub.getBaseClasses();
        dataStream.writeByte(names.length);
        for (String s : names) {
            dataStream.writeName(s);
        }
    }

    public GrReferenceListStub deserialize(StubInputStream dataStream, StubElement parentStub) throws IOException {
        int b = dataStream.readByte();
        String[] names = new String[b];
        for (int i = 0; i < b; ++i) {
            names[i] = dataStream.readName().toString();
        }
        return new GrReferenceListStubImpl(parentStub, GroovyElementTypes.IMPLEMENTS_CLAUSE, names);
    }

    @Override
    public void indexStub(GrReferenceListStub stub, IndexSink sink) {
        for (String name : stub.getBaseClasses()) {
            if (name == null) continue;
            sink.occurrence(GrDirectInheritorsIndex.KEY, (Object)name);
        }
    }
}

