/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashSet;
import gnu.trove.TIntStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileTypeLoader;
import org.jetbrains.plugins.groovy.debugger.fragments.GroovyCodeFragment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMemberReference;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyLexer;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GrNamedElement;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTopLevelDefintion;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTupleExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrPropertySelection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClosureSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.JavaIdentifier;
import org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.MethodResolverProcessor;

public class PsiUtil {
    public static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil");
    public static final Key<JavaIdentifier> NAME_IDENTIFIER = new Key("Java Identifier");

    private PsiUtil() {
    }

    @Nullable
    public static String getQualifiedReferenceText(GrCodeReferenceElement referenceElement) {
        StringBuilder builder = new StringBuilder();
        if (!PsiUtil.appendName(referenceElement, builder)) {
            return null;
        }
        return builder.toString();
    }

    private static boolean appendName(GrCodeReferenceElement referenceElement, StringBuilder builder) {
        String refName = referenceElement.getReferenceName();
        if (refName == null) {
            return false;
        }
        GrCodeReferenceElement qualifier = referenceElement.getQualifier();
        if (qualifier != null) {
            PsiUtil.appendName(qualifier, builder);
            builder.append(".");
        }
        builder.append(refName);
        return true;
    }

    public static boolean isLValue(GroovyPsiElement element) {
        if (element instanceof GrExpression) {
            PsiElement parent = element.getParent();
            if (parent instanceof GrListOrMap && !((GrListOrMap)parent).isMap()) {
                return PsiUtil.isLValue((GroovyPsiElement)parent);
            }
            return parent instanceof GrAssignmentExpression && element.equals(((GrAssignmentExpression)parent).getLValue());
        }
        return false;
    }

    public static boolean isApplicable(@Nullable PsiType[] argumentTypes, PsiMethod method, PsiSubstitutor substitutor, boolean isInUseCategory, GroovyPsiElement place) {
        if (argumentTypes == null) {
            return true;
        }
        GrClosureSignature signature = GrClosureSignatureUtil.createSignature(method, substitutor);
        if (isInUseCategory && method.hasModifierProperty("static") && method.getParameterList().getParametersCount() > 0) {
            signature = signature.curry(1);
        }
        if (method.isConstructor() && method.getParameterList().getParametersCount() == 0 && argumentTypes.length == 1) {
            PsiType type = argumentTypes[0];
            PsiClassType mapType = JavaPsiFacade.getElementFactory((Project)method.getProject()).createTypeByFQClassName("java.util.Map", method.getResolveScope());
            return TypesUtil.isAssignable((PsiType)mapType, type, method.getManager(), method.getResolveScope());
        }
        LOG.assertTrue(signature != null);
        return GrClosureSignatureUtil.isSignatureApplicable(signature, argumentTypes, place);
    }

    public static boolean isApplicable(@Nullable PsiType[] argumentTypes, GrClosureType type, GroovyPsiElement context) {
        if (argumentTypes == null) {
            return true;
        }
        GrClosureSignature signature = type.getSignature();
        return GrClosureSignatureUtil.isSignatureApplicable(signature, argumentTypes, context);
    }

    public static PsiClassType createMapType(PsiManager manager, GlobalSearchScope scope) {
        return JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createTypeByFQClassName("java.util.Map", scope);
    }

    @Nullable
    public static GroovyPsiElement getArgumentsElement(PsiElement methodRef) {
        PsiElement parent = methodRef.getParent();
        if (parent instanceof GrMethodCallExpression) {
            return ((GrMethodCallExpression)parent).getArgumentList();
        }
        if (parent instanceof GrApplicationStatement) {
            return ((GrApplicationStatement)parent).getArgumentList();
        }
        if (parent instanceof GrNewExpression) {
            return ((GrNewExpression)parent).getArgumentList();
        }
        return null;
    }

    @Nullable
    public static PsiType[] getArgumentTypes(PsiElement place, boolean nullAsBottom) {
        PsiElement parent = place.getParent();
        if (parent instanceof GrCallExpression) {
            GrClosableBlock[] closures;
            GrExpression[] expressions;
            ArrayList<Object> result = new ArrayList<Object>();
            GrCallExpression call = (GrCallExpression)parent;
            GrNamedArgument[] namedArgs = call.getNamedArguments();
            if (namedArgs.length > 0) {
                result.add(PsiUtil.createMapType(place.getManager(), place.getResolveScope()));
            }
            for (GrExpression expression : expressions = call.getExpressionArguments()) {
                PsiType type = PsiUtil.getArgumentType(expression);
                if (type == null) {
                    result.add(nullAsBottom ? PsiType.NULL : TypesUtil.getJavaLangObject(call));
                    continue;
                }
                result.add(type);
            }
            for (GrClosableBlock closure : closures = call.getClosureArguments()) {
                PsiType closureType = closure.getType();
                if (closureType == null) continue;
                result.add(closureType);
            }
            return result.toArray(new PsiType[result.size()]);
        }
        if (parent instanceof GrAnonymousClassDefinition) {
            GrExpression[] expressions;
            GrAnonymousClassDefinition anonymous = (GrAnonymousClassDefinition)parent;
            GrArgumentList argList = anonymous.getArgumentListGroovy();
            ArrayList<Object> result = new ArrayList<Object>();
            GrNamedArgument[] namedArgs = argList.getNamedArguments();
            if (namedArgs.length > 0) {
                result.add(PsiUtil.createMapType(place.getManager(), place.getResolveScope()));
            }
            for (GrExpression expression : expressions = argList.getExpressionArguments()) {
                PsiType type = PsiUtil.getArgumentType(expression);
                if (type == null) {
                    result.add(nullAsBottom ? PsiType.NULL : TypesUtil.getJavaLangObject(argList));
                    continue;
                }
                result.add(type);
            }
            return result.toArray(new PsiType[result.size()]);
        }
        if (parent instanceof GrApplicationStatement) {
            GrApplicationStatement call = (GrApplicationStatement)parent;
            GrExpression[] args = call.getArguments();
            GrArgumentList argList = call.getArgumentList();
            GrNamedArgument[] namedArgs = argList != null ? argList.getNamedArguments() : GrNamedArgument.EMPTY_ARRAY;
            ArrayList<Object> result = new ArrayList<Object>();
            if (namedArgs.length > 0) {
                result.add(PsiUtil.createMapType(place.getManager(), place.getResolveScope()));
            }
            for (GrExpression arg : args) {
                PsiType argType = PsiUtil.getArgumentType(arg);
                if (argType == null) {
                    result.add(nullAsBottom ? PsiType.NULL : TypesUtil.getJavaLangObject(parent));
                    continue;
                }
                result.add(argType);
            }
            return result.toArray(new PsiType[result.size()]);
        }
        if (parent instanceof GrConstructorInvocation || parent instanceof GrEnumConstant) {
            GrExpression[] expressions;
            GrArgumentList argList = ((GrCall)parent).getArgumentList();
            if (argList == null) {
                return PsiType.EMPTY_ARRAY;
            }
            ArrayList<Object> result = new ArrayList<Object>();
            if (argList.getNamedArguments().length > 0) {
                result.add(PsiUtil.createMapType(place.getManager(), place.getResolveScope()));
            }
            for (GrExpression expression : expressions = argList.getExpressionArguments()) {
                PsiType type = PsiUtil.getArgumentType(expression);
                if (type == null) {
                    result.add(nullAsBottom ? PsiType.NULL : TypesUtil.getJavaLangObject(argList));
                    continue;
                }
                result.add(type);
            }
            return result.toArray(new PsiType[result.size()]);
        }
        return null;
    }

    @Nullable
    private static PsiType getArgumentType(GrExpression expression) {
        PsiElement resolved;
        if (expression instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)expression).resolve()) instanceof PsiClass) {
            return JavaPsiFacade.getInstance((Project)resolved.getProject()).getElementFactory().createTypeByFQClassName("java.lang.Class", expression.getResolveScope());
        }
        return expression.getType();
    }

    public static SearchScope restrictScopeToGroovyFiles(final Computable<SearchScope> originalScopeComputation) {
        return (SearchScope)ApplicationManager.getApplication().runReadAction((Computable)new Computable<SearchScope>(){

            public SearchScope compute() {
                SearchScope originalScope = (SearchScope)originalScopeComputation.compute();
                if (originalScope instanceof GlobalSearchScope) {
                    return GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)((GlobalSearchScope)originalScope), (FileType[])GroovyFileTypeLoader.getGroovyEnabledFileTypes());
                }
                return originalScope;
            }
        });
    }

    @Nullable
    public static PsiClass getJavaLangClass(PsiElement resolved, GlobalSearchScope scope) {
        return JavaPsiFacade.getInstance((Project)resolved.getProject()).findClass("java.lang.Class", scope);
    }

    public static boolean isValidReferenceName(String text) {
        GroovyLexer lexer = new GroovyLexer();
        lexer.start(text);
        return TokenSets.REFERENCE_NAMES.contains(lexer.getTokenType()) && lexer.getTokenEnd() == text.length();
    }

    public static void shortenReferences(GroovyPsiElement element) {
        PsiUtil.doShorten(element);
    }

    private static void doShorten(PsiElement element) {
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof GrCodeReferenceElement) {
                PsiUtil.shortenReference((GrCodeReferenceElement)child);
            }
            PsiUtil.doShorten(child);
        }
    }

    public static void shortenReference(GrReferenceElement ref) {
        PsiElement resolved;
        PsiElement qualifier = ref.getQualifier();
        if (qualifier != null && (PsiTreeUtil.getParentOfType((PsiElement)ref, GrDocMemberReference.class) != null || PsiTreeUtil.getParentOfType((PsiElement)ref, GrDocComment.class) == null) && PsiTreeUtil.getParentOfType((PsiElement)ref, GrImportStatement.class) == null && PsiTreeUtil.getParentOfType((PsiElement)ref, GroovyCodeFragment.class) == null && (resolved = ref.resolve()) instanceof PsiClass) {
            PsiUtil.setQualifier(ref, null);
            if (ref.isReferenceTo(resolved)) {
                return;
            }
            GroovyFileBase file = (GroovyFileBase)ref.getContainingFile();
            PsiClass clazz = (PsiClass)resolved;
            String qName = clazz.getQualifiedName();
            if (qName != null && PsiUtil.mayInsertImport(ref)) {
                GrImportStatement added = file.addImportForClass(clazz);
                if (!ref.isReferenceTo(resolved)) {
                    file.removeImport(added);
                    PsiUtil.setQualifier(ref, qualifier);
                }
            }
        }
    }

    private static void setQualifier(@NotNull GrReferenceElement ref, @Nullable PsiElement qualifier) {
        if (ref == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/util/PsiUtil.setQualifier must not be null");
        }
        if (ref instanceof GrReferenceExpression) {
            ((GrReferenceExpression)ref).setQualifierExpression((GrReferenceExpression)qualifier);
        } else if (ref instanceof GrCodeReferenceElement) {
            ((GrCodeReferenceElement)ref).setQualifier((GrCodeReferenceElement)qualifier);
        }
    }

    private static boolean mayInsertImport(GrReferenceElement ref) {
        return PsiTreeUtil.getParentOfType((PsiElement)ref, GrDocComment.class) == null && !(ref.getContainingFile() instanceof GroovyCodeFragment) && PsiTreeUtil.getParentOfType((PsiElement)ref, GrImportStatement.class) == null;
    }

    @Nullable
    public static GrTopLevelDefintion findPreviousTopLevelElementByThisElement(PsiElement element) {
        PsiElement parent;
        for (parent = element.getParent(); parent != null && !(parent instanceof GrTopLevelDefintion); parent = parent.getParent()) {
        }
        if (parent == null) {
            return null;
        }
        return (GrTopLevelDefintion)parent;
    }

    public static boolean isStaticsOK(PsiModifierListOwner owner, PsiElement place) {
        GrExpression qualifier;
        if (owner instanceof PsiMember && place instanceof GrReferenceExpression && (qualifier = ((GrReferenceExpression)place).getQualifierExpression()) != null) {
            PsiElement qualifierResolved;
            if (qualifier instanceof GrReferenceExpression && ((qualifierResolved = ((GrReferenceExpression)qualifier).resolve()) instanceof PsiClass || qualifierResolved instanceof PsiPackage)) {
                PsiClass containingClass;
                if (owner instanceof PsiClass) {
                    return true;
                }
                PsiClass javaLangClass = JavaPsiFacade.getInstance((Project)place.getProject()).findClass("java.lang.Class", place.getResolveScope());
                if (javaLangClass != null && ((containingClass = ((PsiMember)owner).getContainingClass()) == null || InheritanceUtil.isInheritorOrSelf((PsiClass)javaLangClass, (PsiClass)containingClass, (boolean)true))) {
                    return true;
                }
                return owner.hasModifierProperty("static");
            }
            if (owner instanceof PsiClass) {
                return false;
            }
            return CodeInsightSettings.getInstance().SHOW_STATIC_AFTER_INSTANCE || !owner.hasModifierProperty("static");
        }
        return true;
    }

    public static boolean isAccessible(PsiElement place, PsiMember member) {
        if (PsiTreeUtil.getParentOfType((PsiElement)place, GrDocComment.class) != null) {
            return true;
        }
        if (!member.isPhysical()) {
            return true;
        }
        if (place instanceof GrReferenceExpression && ((GrReferenceExpression)place).getQualifierExpression() == null && member.getContainingClass() instanceof GroovyScriptClass) {
            return true;
        }
        return com.intellij.psi.util.PsiUtil.isAccessible((PsiMember)member, (PsiElement)place, null);
    }

    public static void reformatCode(PsiElement element) {
        TextRange textRange = element.getTextRange();
        try {
            CodeStyleManager.getInstance((Project)element.getProject()).reformatText(element.getContainingFile(), textRange.getStartOffset(), textRange.getEndOffset());
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public static boolean isInStaticContext(GrReferenceExpression refExpression, PsiClass targetClass) {
        if (refExpression.isQualified()) {
            GrExpression qualifer = refExpression.getQualifierExpression();
            if (qualifer instanceof GrReferenceExpression) {
                return ((GrReferenceExpression)qualifer).resolve() instanceof PsiClass;
            }
        } else {
            for (GrReferenceExpression run = refExpression; run != null && run != targetClass; run = run.getParent()) {
                if (!(run instanceof PsiModifierListOwner) || !((PsiModifierListOwner)run).hasModifierProperty("static")) continue;
                return true;
            }
        }
        return false;
    }

    public static Iterable<PsiClass> iterateSupers(final @NotNull PsiClass psiClass, final boolean includeSelf) {
        if (psiClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/util/PsiUtil.iterateSupers must not be null");
        }
        return new Iterable<PsiClass>(){

            @Override
            public Iterator<PsiClass> iterator() {
                return new Iterator<PsiClass>(){
                    TIntStack indices = new TIntStack();
                    Stack<PsiClassType[]> superTypesStack = new Stack();
                    PsiClass current;
                    boolean nextObtained;
                    Set<PsiClass> visited = new HashSet();
                    {
                        if (includeSelf) {
                            this.current = psiClass;
                            this.nextObtained = true;
                        } else {
                            this.current = null;
                            this.nextObtained = false;
                        }
                        this.pushSuper(psiClass);
                    }

                    @Override
                    public boolean hasNext() {
                        this.nextElement();
                        return this.current != null;
                    }

                    private void nextElement() {
                        if (this.nextObtained) {
                            return;
                        }
                        this.nextObtained = true;
                        while (!this.superTypesStack.empty()) {
                            assert (this.indices.size() > 0);
                            PsiClassType[] superTypes = this.superTypesStack.peek();
                            for (int i = this.indices.pop(); i < superTypes.length; ++i) {
                                PsiClass clazz = superTypes[i].resolve();
                                if (clazz == null || this.visited.contains(clazz)) continue;
                                this.current = clazz;
                                this.visited.add(clazz);
                                this.indices.push(i + 1);
                                this.pushSuper(clazz);
                                return;
                            }
                            this.superTypesStack.pop();
                        }
                        this.current = null;
                    }

                    private void pushSuper(PsiClass clazz) {
                        this.superTypesStack.push(clazz.getSuperTypes());
                        this.indices.push(0);
                    }

                    @Override
                    @NotNull
                    public PsiClass next() {
                        this.nextElement();
                        this.nextObtained = false;
                        if (this.current == null) {
                            throw new NoSuchElementException();
                        }
                        PsiClass psiClass = this.current;
                        if (psiClass == null) {
                            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/util/PsiUtil$2$1.next must not return null");
                        }
                        return psiClass;
                    }

                    @Override
                    public void remove() {
                        throw new IllegalStateException("should not be called");
                    }
                };
            }
        };
    }

    @Nullable
    public static PsiClass getContextClass(PsiElement context) {
        GroovyPsiElement parent = (GroovyPsiElement)PsiTreeUtil.getParentOfType((PsiElement)context, (Class[])new Class[]{GrTypeDefinition.class, GroovyFileBase.class});
        if (parent instanceof GrTypeDefinition) {
            return (PsiClass)parent;
        }
        if (parent instanceof GroovyFileBase) {
            return ((GroovyFileBase)parent).getScriptClass();
        }
        return null;
    }

    public static boolean mightBeLVlaue(GrExpression expr) {
        if (expr instanceof GrParenthesizedExpression) {
            return PsiUtil.mightBeLVlaue(((GrParenthesizedExpression)expr).getOperand());
        }
        if (expr instanceof GrListOrMap) {
            GrExpression[] initializers;
            GrListOrMap listOrMap = (GrListOrMap)expr;
            if (listOrMap.isMap()) {
                return false;
            }
            for (GrExpression initializer : initializers = listOrMap.getInitializers()) {
                if (PsiUtil.mightBeLVlaue(initializer)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof GrTupleExpression) {
            return true;
        }
        return expr instanceof GrReferenceExpression || expr instanceof GrIndexProperty || expr instanceof GrPropertySelection;
    }

    public static boolean isRawMethodCall(GrMethodCallExpression call) {
        GroovyResolveResult[] resolveResults = call.getMethodVariants();
        if (resolveResults.length == 0) {
            return false;
        }
        PsiElement element = resolveResults[0].getElement();
        if (element instanceof PsiMethod) {
            PsiType returnType = ((PsiMethod)element).getReturnType();
            return PsiUtil.isRawType(returnType, resolveResults[0].getSubstitutor());
        }
        return false;
    }

    public static boolean isRawFieldAccess(GrReferenceExpression ref) {
        PsiElement element = null;
        GroovyResolveResult[] resolveResults = ref.multiResolve(false);
        if (resolveResults.length == 0) {
            return false;
        }
        GroovyResolveResult resolveResult = resolveResults[0];
        if (resolveResult != null) {
            element = resolveResult.getElement();
        }
        if (element instanceof PsiField) {
            return PsiUtil.isRawType(((PsiField)element).getType(), resolveResult.getSubstitutor());
        }
        if (element instanceof GrAccessorMethod) {
            return PsiUtil.isRawType(((GrAccessorMethod)element).getReturnType(), resolveResult.getSubstitutor());
        }
        return false;
    }

    private static boolean isRawIndexPropertyAccess(GrIndexProperty expr) {
        GrExpression qualifier = expr.getSelectedExpression();
        PsiType qualifierType = qualifier.getType();
        if (qualifierType instanceof PsiClassType) {
            PsiElement element;
            if (InheritanceUtil.isInheritor((PsiType)qualifierType, (String)"java.util.List")) {
                return com.intellij.psi.util.PsiUtil.extractIterableTypeParameter((PsiType)qualifierType, (boolean)false) == null;
            }
            if (InheritanceUtil.isInheritor((PsiType)qualifierType, (String)"java.util.Map")) {
                return com.intellij.psi.util.PsiUtil.substituteTypeParameter((PsiType)qualifierType, (String)"java.util.Map", (int)1, (boolean)false) == null;
            }
            PsiClassType classType = (PsiClassType)qualifierType;
            PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
            GrExpression[] arguments = expr.getArgumentList().getExpressionArguments();
            PsiType[] argTypes = new PsiType[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                PsiType argType = arguments[i].getType();
                if (argType == null) {
                    argType = TypesUtil.getJavaLangObject(expr);
                }
                argTypes[i] = argType;
            }
            MethodResolverProcessor processor = new MethodResolverProcessor("getAt", expr, false, qualifierType, argTypes, PsiType.EMPTY_ARRAY);
            PsiClass qClass = resolveResult.getElement();
            if (qClass != null) {
                qClass.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial().put(PsiSubstitutor.KEY, (Object)PsiSubstitutor.EMPTY), null, (PsiElement)expr);
            }
            ResolveUtil.processNonCodeMethods(qualifierType, processor, expr.getProject(), expr, false);
            GroovyResolveResult[] candidates = processor.getCandidates();
            PsiType type = null;
            if (candidates.length == 1 && (element = candidates[0].getElement()) instanceof PsiMethod) {
                type = ((PsiMethod)element).getReturnType();
            }
            return PsiUtil.isRawType(type, resolveResult.getSubstitutor());
        }
        return false;
    }

    public static boolean isRawClassMemberAccess(GrExpression expr) {
        while (expr instanceof GrParenthesizedExpression) {
            expr = ((GrParenthesizedExpression)expr).getOperand();
        }
        if (expr instanceof GrMethodCallExpression) {
            return PsiUtil.isRawMethodCall((GrMethodCallExpression)expr);
        }
        if (expr instanceof GrReferenceExpression) {
            return PsiUtil.isRawFieldAccess((GrReferenceExpression)expr);
        }
        if (expr instanceof GrIndexProperty) {
            return PsiUtil.isRawIndexPropertyAccess((GrIndexProperty)expr);
        }
        return false;
    }

    public static boolean isRawType(PsiType type, PsiSubstitutor substitutor) {
        PsiTypeParameter typeParameter;
        PsiType substitutedType;
        PsiClass returnClass;
        return type instanceof PsiClassType && (returnClass = ((PsiClassType)type).resolve()) instanceof PsiTypeParameter && (substitutedType = substitutor.substitute(typeParameter = (PsiTypeParameter)returnClass)) == null;
    }

    public static boolean isNewLine(PsiElement element) {
        if (element == null) {
            return false;
        }
        ASTNode node = element.getNode();
        if (node == null) {
            return false;
        }
        return node.getElementType() == GroovyTokenTypes.mNLS;
    }

    @Nullable
    public static PsiElement getPrevNonSpace(PsiElement elem) {
        PsiElement prevSibling = elem.getPrevSibling();
        while (prevSibling instanceof PsiWhiteSpace) {
            prevSibling = prevSibling.getPrevSibling();
        }
        return prevSibling;
    }

    @Nullable
    public static PsiElement getNextNonSpace(PsiElement elem) {
        PsiElement nextSibling = elem.getNextSibling();
        while (nextSibling instanceof PsiWhiteSpace) {
            nextSibling = nextSibling.getNextSibling();
        }
        return nextSibling;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PsiIdentifier getJavaNameIdentifier(GrNamedElement namedElement) {
        PsiElement element = namedElement.getNameIdentifierGroovy();
        JavaIdentifier identifier = (JavaIdentifier)((Object)element.getUserData(NAME_IDENTIFIER));
        if (identifier == null) {
            PsiElement psiElement = element;
            synchronized (psiElement) {
                identifier = (JavaIdentifier)((Object)element.getUserData(NAME_IDENTIFIER));
                if (identifier != null) {
                    return identifier;
                }
                identifier = new JavaIdentifier(element.getManager(), element);
                element.putUserData(NAME_IDENTIFIER, (Object)identifier);
            }
        }
        return identifier;
    }

    @Nullable
    public static PsiElement findEnclosingStatement(@Nullable PsiElement context) {
        if (context == null) {
            return null;
        }
        context = PsiTreeUtil.getParentOfType((PsiElement)context, GrStatement.class, (boolean)false);
        while (context != null) {
            PsiElement parent = context.getParent();
            if (parent instanceof GrControlFlowOwner) {
                return context;
            }
            context = parent;
        }
        return null;
    }

    public static boolean isMethodCall(GrMethodCallExpression call, String methodName) {
        GrExpression expression = call.getInvokedExpression();
        return expression instanceof GrReferenceExpression && methodName.equals(expression.getText().trim());
    }

    public static boolean hasEnclosingInstanceInScope(PsiClass clazz, PsiElement scope, boolean isSuperClassAccepted) {
        PsiElement place;
        for (place = scope; place != null && place != clazz && !(place instanceof PsiFile); place = place.getParent()) {
            if (place instanceof PsiClass && (isSuperClassAccepted ? InheritanceUtil.isInheritorOrSelf((PsiClass)((PsiClass)place), (PsiClass)clazz, (boolean)true) : clazz.getManager().areElementsEquivalent(place, (PsiElement)clazz))) {
                return true;
            }
            if (!(place instanceof PsiModifierListOwner) || !((PsiModifierListOwner)place).hasModifierProperty("static")) continue;
            return false;
        }
        return place == clazz;
    }

    @Nullable
    public static PsiElement skipWhitespaces(@Nullable PsiElement elem, boolean forward) {
        while (elem != null && elem.getNode() != null && GroovyElementTypes.WHITE_SPACES_OR_COMMENTS.contains(elem.getNode().getElementType())) {
            if (forward) {
                elem = elem.getNextSibling();
                continue;
            }
            elem = elem.getPrevSibling();
        }
        return elem;
    }

    public static GroovyResolveResult[] getConstructorCandidates(GroovyPsiElement place, GroovyResolveResult[] classCandidates, PsiType[] argTypes) {
        ArrayList<GroovyResolveResult> constructorResults = new ArrayList<GroovyResolveResult>();
        for (GroovyResolveResult classResult : classCandidates) {
            PsiElement element = classResult.getElement();
            if (!(element instanceof PsiClass)) continue;
            GroovyPsiElement context = classResult.getCurrentFileResolveContext();
            PsiClass clazz = (PsiClass)element;
            String className = clazz.getName();
            PsiClassType thisType = JavaPsiFacade.getInstance((Project)place.getProject()).getElementFactory().createType(clazz, classResult.getSubstitutor());
            MethodResolverProcessor processor = new MethodResolverProcessor(className, place, true, (PsiType)thisType, argTypes, PsiType.EMPTY_ARRAY);
            processor.setCurrentFileResolveContext(context);
            PsiSubstitutor substitutor = classResult.getSubstitutor();
            boolean toBreak = element.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial().put(PsiSubstitutor.KEY, (Object)substitutor), null, (PsiElement)place);
            for (NonCodeMembersProcessor membersProcessor : (NonCodeMembersProcessor[])NonCodeMembersProcessor.EP_NAME.getExtensions()) {
                if (!membersProcessor.processNonCodeMembers((PsiType)thisType, processor, place, true)) break;
            }
            constructorResults.addAll(Arrays.asList(processor.getCandidates()));
            if (!toBreak) break;
        }
        return constructorResults.toArray(new GroovyResolveResult[constructorResults.size()]);
    }
}

