/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.stubs;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GrClassSubstitutor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrReferenceList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrAnnotatedMemberIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrAnonymousClassIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrDirectInheritorsIndex;

public abstract class GroovyCacheUtil {
    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiMember[] getAnnotatedMemberCandidates(PsiClass clazz, GlobalSearchScope scope) {
        PsiMember[] psiMemberArray;
        String name = clazz.getName();
        if (name == null) {
            psiMemberArray = GrMember.EMPTY_ARRAY;
            if (GrMember.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/stubs/GroovyCacheUtil.getAnnotatedMemberCandidates must not return null");
            return psiMemberArray;
        }
        Collection members = StubIndex.getInstance().get(GrAnnotatedMemberIndex.KEY, (Object)name, clazz.getProject(), scope);
        psiMemberArray = members.toArray(new PsiMember[members.size()]);
        if (psiMemberArray != null) return psiMemberArray;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/stubs/GroovyCacheUtil.getAnnotatedMemberCandidates must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiClass[] getDeriverCandidates(PsiClass clazz, GlobalSearchScope scope) {
        PsiClass[] psiClassArray;
        String name = clazz.getName();
        if (name == null) {
            psiClassArray = GrTypeDefinition.EMPTY_ARRAY;
            if (GrTypeDefinition.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/stubs/GroovyCacheUtil.getDeriverCandidates must not return null");
            return psiClassArray;
        }
        ArrayList<PsiClass> inheritors = new ArrayList<PsiClass>();
        Collection refLists = StubIndex.getInstance().get(GrDirectInheritorsIndex.KEY, (Object)name, clazz.getProject(), scope);
        for (GrReferenceList list : refLists) {
            PsiElement parent = list.getParent();
            if (!(parent instanceof GrTypeDefinition)) continue;
            inheritors.add(GrClassSubstitutor.getSubstitutedClass((GrTypeDefinition)parent));
        }
        Collection classes = StubIndex.getInstance().get(GrAnonymousClassIndex.KEY, (Object)name, clazz.getProject(), scope);
        for (GrAnonymousClassDefinition aClass : classes) {
            inheritors.add(aClass);
        }
        psiClassArray = inheritors.toArray(new PsiClass[inheritors.size()]);
        if (psiClassArray != null) return psiClassArray;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/stubs/GroovyCacheUtil.getDeriverCandidates must not return null");
    }
}

