/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibrariesUtil {
    private LibrariesUtil() {
    }

    public static Library[] getLibrariesByCondition(final Module module, final Condition<Library> condition) {
        if (module == null) {
            return new Library[0];
        }
        final ArrayList libraries = new ArrayList();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                LibrariesUtil.populateOrderEntries(module, (Condition<Library>)condition, libraries, false, (Set)new THashSet());
            }
        });
        return libraries.toArray(new Library[libraries.size()]);
    }

    private static void populateOrderEntries(@NotNull Module module, Condition<Library> condition, ArrayList<Library> libraries, boolean exportedOnly, Set<Module> visited) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/util/LibrariesUtil.populateOrderEntries must not be null");
        }
        if (!visited.add(module)) {
            return;
        }
        for (OrderEntry entry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
            Module dep;
            if (entry instanceof LibraryOrderEntry) {
                Library library;
                LibraryOrderEntry libEntry = (LibraryOrderEntry)entry;
                if (exportedOnly && !libEntry.isExported() || !condition.value((Object)(library = libEntry.getLibrary()))) continue;
                libraries.add(library);
                continue;
            }
            if (!(entry instanceof ModuleOrderEntry) || (dep = ((ModuleOrderEntry)entry).getModule()) == null) continue;
            LibrariesUtil.populateOrderEntries(dep, condition, libraries, true, visited);
        }
    }

    public static Library[] getGlobalLibraries(Condition<Library> condition) {
        LibraryTable table = LibraryTablesRegistrar.getInstance().getLibraryTable();
        List libs = ContainerUtil.findAll((Object[])table.getLibraries(), condition);
        return libs.toArray(new Library[libs.size()]);
    }

    @NotNull
    public static String getGroovyLibraryHome(Library library) {
        VirtualFile[] classRoots = library.getFiles(OrderRootType.CLASSES);
        String home = LibrariesUtil.getGroovyLibraryHome(classRoots);
        String string = home == null ? "" : home;
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/util/LibrariesUtil.getGroovyLibraryHome must not return null");
        }
        return string;
    }

    public static boolean hasGroovySdk(@Nullable Module module) {
        return module != null && LibrariesUtil.getGroovyHomePath(module) != null;
    }

    @Nullable
    public static String getGroovyHomePath(@NotNull Module module) {
        PsiClass[] classes;
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/util/LibrariesUtil.getGroovyHomePath must not be null");
        }
        for (PsiClass cUnit : classes = JavaPsiFacade.getInstance((Project)module.getProject()).findClasses("org.codehaus.groovy.control.CompilationUnit", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module))) {
            VirtualFile parent;
            VirtualFile local = JarFileSystem.getInstance().getVirtualFileForJar(cUnit.getContainingFile().getVirtualFile());
            if (local == null || (parent = local.getParent()) == null) continue;
            if (("lib".equals(parent.getName()) || "embeddable".equals(parent.getName())) && parent.getParent() != null) {
                return parent.getParent().getPath();
            }
            return parent.getPath();
        }
        String home = LibrariesUtil.getGroovyLibraryHome(ModuleRootManager.getInstance((Module)module).getFiles(OrderRootType.CLASSES));
        return StringUtil.isEmpty((String)home) ? null : home;
    }

    public static boolean isEmbeddableDistribution(VirtualFile[] classRoots) {
        if (LibrariesUtil.getGroovySdkHome(classRoots) != null) {
            return false;
        }
        return LibrariesUtil.getEmbeddableGroovyJar(classRoots) != null;
    }

    @Nullable
    private static String getGroovySdkHome(VirtualFile[] classRoots) {
        for (VirtualFile file : classRoots) {
            File parentFile;
            String jarPath;
            File realFile;
            String name = file.getName();
            if (!name.matches("groovy-(\\d.*)\\.jar") || !(realFile = new File(jarPath = file.getPresentableUrl())).exists() || (parentFile = realFile.getParentFile()) == null) continue;
            if ("lib".equals(parentFile.getName())) {
                return parentFile.getParent();
            }
            return parentFile.getPath();
        }
        return null;
    }

    @Nullable
    private static String getEmbeddableGroovyJar(VirtualFile[] classRoots) {
        for (VirtualFile file : classRoots) {
            String jarPath;
            File realFile;
            String name = file.getName();
            if (!name.matches("groovy-all-(.*)\\.jar") || !(realFile = new File(jarPath = file.getPresentableUrl())).exists()) continue;
            return realFile.getPath();
        }
        return null;
    }

    @Nullable
    public static String getGroovyLibraryHome(VirtualFile[] classRoots) {
        File emb;
        String sdkHome = LibrariesUtil.getGroovySdkHome(classRoots);
        if (sdkHome != null) {
            return sdkHome;
        }
        String embeddable = LibrariesUtil.getEmbeddableGroovyJar(classRoots);
        if (embeddable != null && (emb = new File(embeddable)).exists()) {
            File parent = emb.getParentFile();
            if ("embeddable".equals(parent.getName()) || "lib".equals(parent.getName())) {
                return parent.getParent();
            }
            return parent.getPath();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static VirtualFile getLocalFile(@NotNull VirtualFile libFile) {
        VirtualFile virtualFile;
        VirtualFile local;
        if (libFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/util/LibrariesUtil.getLocalFile must not be null");
        }
        VirtualFileSystem system = libFile.getFileSystem();
        if (system instanceof JarFileSystem && (local = JarFileSystem.getInstance().getVirtualFileForJar(libFile)) != null) {
            virtualFile = local;
            if (virtualFile == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/util/LibrariesUtil.getLocalFile must not return null");
            return virtualFile;
        }
        virtualFile = libFile;
        if (virtualFile != null) return virtualFile;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/util/LibrariesUtil.getLocalFile must not return null");
    }

    public static void placeEntryToCorrectPlace(ModifiableRootModel model, LibraryOrderEntry addedEntry) {
        int i;
        OrderEntry[] order = model.getOrderEntries();
        assert (order[order.length - 1] == addedEntry);
        int insertionPoint = -1;
        for (i = 0; i < order.length - 1; ++i) {
            if (!(order[i] instanceof ModuleSourceOrderEntry)) continue;
            insertionPoint = i + 1;
            break;
        }
        if (insertionPoint >= 0) {
            for (i = order.length - 1; i > insertionPoint; --i) {
                order[i] = order[i - 1];
            }
            order[insertionPoint] = addedEntry;
            model.rearrangeOrderEntries(order);
        }
    }
}

