/*
 * Decompiled with CFR 0.152.
 */
package git4idea.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeListImpl;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import git4idea.GitContentRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.commands.GitCommand;
import git4idea.commands.GitSimpleHandler;
import git4idea.commands.StringScanner;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;

public class GitChangeUtils {
    public static final String COMMITTED_CHANGELIST_FORMAT = "%ct%n%H%n%P%n%an%x20%x3C%ae%x3E%n%cn%x20%x3C%ce%x3E%n%s%n%x00%n%b%n%x00";

    private GitChangeUtils() {
    }

    public static List<VirtualFile> unmergedFiles(Project project, VirtualFile root) throws VcsException {
        HashSet<VirtualFile> unmerged = new HashSet<VirtualFile>();
        String rootPath = root.getPath();
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.LS_FILES);
        h.setNoSSH(true);
        h.setSilent(true);
        h.addParameters("--unmerged");
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        StringScanner s = new StringScanner(h.run());
        while (s.hasMoreData()) {
            if (s.isEol()) {
                s.nextLine();
                continue;
            }
            s.boundedToken('\t');
            String relative = s.line();
            String path = rootPath + "/" + GitUtil.unescapePath(relative);
            VirtualFile file = lfs.refreshAndFindFileByPath(path);
            assert (file != null) : "The unmerged file is not found " + path;
            file.refresh(false, false);
            unmerged.add(file);
        }
        if (unmerged.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<VirtualFile> rc = new ArrayList<VirtualFile>(unmerged.size());
        rc.addAll(unmerged);
        Collections.sort(rc, GitUtil.VIRTUAL_FILE_COMPARATOR);
        return rc;
    }

    public static void parseChanges(Project project, VirtualFile vcsRoot, GitRevisionNumber thisRevision, GitRevisionNumber parentRevision, String s, List<Change> changes, Set<String> ignoreNames) throws VcsException {
        StringScanner sc = new StringScanner(s);
        GitChangeUtils.parseChanges(project, vcsRoot, thisRevision, parentRevision, sc, changes, ignoreNames);
        if (sc.hasMoreData()) {
            throw new IllegalStateException("Unknown file status: " + sc.line());
        }
    }

    public static Collection<String> parseDiffForPaths(String rootPath, StringScanner s) throws VcsException {
        LinkedList<String> result = new LinkedList<String>();
        while (s.hasMoreData()) {
            if (s.isEol()) {
                s.nextLine();
                continue;
            }
            if ("CADUMR".indexOf(s.peek()) == -1) break;
            assert ('M' != s.peek()) : "Moves are not yet handled";
            String[] tokens = s.line().split("\t");
            String path = tokens[tokens.length - 1];
            path = rootPath + File.separator + GitUtil.unescapePath(path);
            path = FileUtil.toSystemDependentName((String)path);
            result.add(path);
        }
        return result;
    }

    public static void parseChanges(Project project, VirtualFile vcsRoot, GitRevisionNumber thisRevision, GitRevisionNumber parentRevision, StringScanner s, List<Change> changes, Set<String> ignoreNames) throws VcsException {
        while (s.hasMoreData()) {
            ContentRevision after;
            ContentRevision before;
            FileStatus status = null;
            if (s.isEol()) {
                s.nextLine();
                continue;
            }
            if ("CADUMR".indexOf(s.peek()) == -1) {
                return;
            }
            String[] tokens = s.line().split("\t");
            String path = tokens[tokens.length - 1];
            switch (tokens[0].charAt(0)) {
                case 'A': 
                case 'C': {
                    before = null;
                    status = FileStatus.ADDED;
                    after = GitContentRevision.createRevision(vcsRoot, path, thisRevision, project, false);
                    break;
                }
                case 'U': {
                    status = FileStatus.MERGED_WITH_CONFLICTS;
                }
                case 'M': {
                    if (status == null) {
                        status = FileStatus.MODIFIED;
                    }
                    before = GitContentRevision.createRevision(vcsRoot, path, parentRevision, project, false);
                    after = GitContentRevision.createRevision(vcsRoot, path, thisRevision, project, false);
                    break;
                }
                case 'D': {
                    status = FileStatus.DELETED;
                    before = GitContentRevision.createRevision(vcsRoot, path, parentRevision, project, true);
                    after = null;
                    break;
                }
                case 'R': {
                    status = FileStatus.MODIFIED;
                    before = GitContentRevision.createRevision(vcsRoot, tokens[1], parentRevision, project, true);
                    after = GitContentRevision.createRevision(vcsRoot, path, thisRevision, project, false);
                    break;
                }
                default: {
                    throw new VcsException("Unknown file status: " + Arrays.asList(tokens));
                }
            }
            if (ignoreNames != null && ignoreNames.contains(path)) continue;
            changes.add(new Change(before, after, status));
        }
    }

    public static GitRevisionNumber loadRevision(Project project, VirtualFile vcsRoot, @NonNls String revisionNumber) throws VcsException {
        GitSimpleHandler handler = new GitSimpleHandler(project, vcsRoot, GitCommand.REV_LIST);
        handler.addParameters("--timestamp", "--max-count=1", revisionNumber);
        handler.endOptions();
        handler.setNoSSH(true);
        handler.setSilent(true);
        String output = handler.run();
        StringTokenizer stk = new StringTokenizer(output, "\n\r \t", false);
        if (!stk.hasMoreTokens()) {
            throw new VcsException("The string '" + revisionNumber + "' does not represents a revision number.");
        }
        Date timestamp = GitUtil.parseTimestamp(stk.nextToken());
        return new GitRevisionNumber(stk.nextToken(), timestamp);
    }

    public static boolean isHeadMissing(VcsException e) {
        String errorText = "fatal: bad revision 'HEAD'\n";
        return e.getMessage().equals("fatal: bad revision 'HEAD'\n");
    }

    public static CommittedChangeList getRevisionChanges(Project project, VirtualFile root, String revisionName) throws VcsException {
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.SHOW);
        h.setNoSSH(true);
        h.setSilent(true);
        h.addParameters("--name-status", "--no-abbrev", "-M", "--pretty=format:%ct%n%H%n%P%n%an%x20%x3C%ae%x3E%n%cn%x20%x3C%ce%x3E%n%s%n%x00%n%b%n%x00", "--encoding=UTF-8", revisionName, "--");
        String output = h.run();
        StringScanner s = new StringScanner(output);
        try {
            return GitChangeUtils.parseChangeList(project, root, s);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (VcsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VcsException((Throwable)e);
        }
    }

    public static CommittedChangeList parseChangeList(Project project, VirtualFile root, StringScanner s) throws VcsException {
        ArrayList<Change> changes = new ArrayList<Change>();
        Date commitDate = GitUtil.parseTimestamp(s.line());
        String revisionNumber = s.line();
        String parentsLine = s.line();
        String[] parents = parentsLine.length() == 0 ? ArrayUtil.EMPTY_STRING_ARRAY : parentsLine.split(" ");
        String authorName = s.line();
        String committerName = s.line();
        committerName = GitUtil.adjustAuthorName(authorName, committerName);
        String commentSubject = s.boundedToken('\u0000', true);
        s.nextLine();
        String commentBody = s.boundedToken('\u0000', true);
        String fullComment = commentSubject.length() == 0 ? commentBody : (commentBody.length() == 0 ? commentSubject : commentBody + "\n\n" + commentSubject);
        GitRevisionNumber thisRevision = new GitRevisionNumber(revisionNumber, commitDate);
        GitRevisionNumber parentRevision = parents.length > 0 ? GitChangeUtils.loadRevision(project, root, parents[0]) : null;
        long number = Long.parseLong(revisionNumber.substring(0, 15), 16) << 4 + Integer.parseInt(revisionNumber.substring(15, 16), 16);
        if (parents.length <= 1) {
            GitChangeUtils.parseChanges(project, root, thisRevision, parentRevision, s, changes, null);
        } else {
            int i = 0;
            assert (parentRevision != null);
            do {
                if (i != 0 && (parentRevision = GitChangeUtils.loadRevision(project, root, parents[i])) == null) continue;
                GitSimpleHandler diffHandler = new GitSimpleHandler(project, root, GitCommand.DIFF);
                diffHandler.setNoSSH(true);
                diffHandler.setSilent(true);
                diffHandler.addParameters("--name-status", "-M", parentRevision.getRev(), thisRevision.getRev());
                String diff = diffHandler.run();
                GitChangeUtils.parseChanges(project, root, thisRevision, parentRevision, diff, changes, null);
                if (changes.size() > 0) break;
                ++i;
            } while (i < parents.length);
        }
        return new CommittedChangeListImpl(commentSubject + "(" + revisionNumber + ")", fullComment, committerName, number, commitDate, changes);
    }
}

