/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import git4idea.GitBranch;
import git4idea.GitTag;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitConfigUtil;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitMergeUtil;
import git4idea.rebase.GitRebaseUtils;
import git4idea.ui.GitReferenceValidator;
import git4idea.ui.GitUIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class GitRebaseDialog
extends DialogWrapper {
    private JComboBox myGitRootComboBox;
    private JComboBox myBranchComboBox;
    private JComboBox myFromComboBox;
    private JButton myFromValidateButton;
    private JComboBox myOntoComboBox;
    private JButton myOntoValidateButton;
    private JCheckBox myShowTagsCheckBox;
    private JComboBox myMergeStrategyComboBox;
    private JCheckBox myInteractiveCheckBox;
    private JCheckBox myDoNotUseMergeCheckBox;
    private JPanel myPanel;
    private JCheckBox myShowRemoteBranchesCheckBox;
    private JCheckBox myPreserveMergesCheckBox;
    private final Project myProject;
    private final List<GitBranch> myLocalBranches;
    private final List<GitBranch> myRemoteBranches;
    private GitBranch myCurrentBranch;
    private final List<GitTag> myTags;
    private final GitReferenceValidator myOntoValidator;
    private final GitReferenceValidator myFromValidator;

    public GitRebaseDialog(Project project, List<VirtualFile> roots, VirtualFile defaultRoot) {
        super(project, true);
        this.$$$setupUI$$$();
        this.myLocalBranches = new ArrayList<GitBranch>();
        this.myRemoteBranches = new ArrayList<GitBranch>();
        this.myTags = new ArrayList<GitTag>();
        this.setTitle(GitBundle.getString("rebase.title"));
        this.setOKButtonText(GitBundle.getString("rebase.button"));
        this.init();
        this.myProject = project;
        Runnable validateRunnable = new Runnable(){

            @Override
            public void run() {
                GitRebaseDialog.this.validateFields();
            }
        };
        this.myOntoValidator = new GitReferenceValidator(this.myProject, this.myGitRootComboBox, GitUIUtil.getTextField(this.myOntoComboBox), this.myOntoValidateButton, validateRunnable);
        this.myFromValidator = new GitReferenceValidator(this.myProject, this.myGitRootComboBox, GitUIUtil.getTextField(this.myFromComboBox), this.myFromValidateButton, validateRunnable);
        GitUIUtil.setupRootChooser(this.myProject, roots, defaultRoot, this.myGitRootComboBox, null);
        this.myGitRootComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitRebaseDialog.this.validateFields();
            }
        });
        this.setupBranches();
        this.setupStrategy();
        this.validateFields();
    }

    public GitLineHandler handler() {
        GitLineHandler h = new GitLineHandler(this.myProject, this.gitRoot(), GitCommand.REBASE);
        h.setNoSSH(true);
        if (this.myInteractiveCheckBox.isSelected() && this.myInteractiveCheckBox.isEnabled()) {
            h.addParameters("-i");
        }
        h.addParameters("-v");
        if (!this.myDoNotUseMergeCheckBox.isSelected()) {
            if (this.myMergeStrategyComboBox.getSelectedItem().equals(GitMergeUtil.DEFAULT_STRATEGY)) {
                h.addParameters("-m");
            } else {
                h.addParameters("-s", this.myMergeStrategyComboBox.getSelectedItem().toString());
            }
        }
        if (this.myPreserveMergesCheckBox.isSelected()) {
            h.addParameters("-p");
        }
        String from = GitUIUtil.getTextField(this.myFromComboBox).getText();
        String onto = GitUIUtil.getTextField(this.myOntoComboBox).getText();
        if (from.length() == 0) {
            h.addParameters(onto);
        } else {
            h.addParameters("--onto", onto, from);
        }
        String selectedBranch = (String)this.myBranchComboBox.getSelectedItem();
        if (this.myCurrentBranch != null && !this.myCurrentBranch.getName().equals(selectedBranch)) {
            h.addParameters(selectedBranch);
        }
        return h;
    }

    private void setupStrategy() {
        for (String s : GitMergeUtil.getMergeStrategies(1)) {
            this.myMergeStrategyComboBox.addItem(s);
        }
        this.myMergeStrategyComboBox.setSelectedItem(GitMergeUtil.DEFAULT_STRATEGY);
        this.myDoNotUseMergeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitRebaseDialog.this.myMergeStrategyComboBox.setEnabled(!GitRebaseDialog.this.myDoNotUseMergeCheckBox.isSelected());
            }
        });
    }

    private void validateFields() {
        if (GitUIUtil.getTextField(this.myOntoComboBox).getText().length() == 0) {
            this.setErrorText(null);
            this.setOKActionEnabled(false);
            return;
        }
        if (this.myOntoValidator.isInvalid()) {
            this.setErrorText(GitBundle.getString("rebase.invalid.onto"));
            this.setOKActionEnabled(false);
            return;
        }
        if (GitUIUtil.getTextField(this.myFromComboBox).getText().length() != 0 && this.myFromValidator.isInvalid()) {
            this.setErrorText(GitBundle.getString("rebase.invalid.from"));
            this.setOKActionEnabled(false);
            return;
        }
        if (GitRebaseUtils.isRebaseInTheProgress(this.gitRoot())) {
            this.setErrorText(GitBundle.getString("rebase.in.progress"));
            this.setOKActionEnabled(false);
            return;
        }
        this.setErrorText(null);
        this.setOKActionEnabled(true);
    }

    private void setupBranches() {
        GitUIUtil.getTextField(this.myOntoComboBox).getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                GitRebaseDialog.this.validateFields();
            }
        });
        ActionListener rootListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitRebaseDialog.this.loadRefs();
                GitRebaseDialog.this.updateBranches();
            }
        };
        ActionListener showListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitRebaseDialog.this.updateOntoFrom();
            }
        };
        this.myShowRemoteBranchesCheckBox.addActionListener(showListener);
        this.myShowTagsCheckBox.addActionListener(showListener);
        rootListener.actionPerformed(null);
        this.myGitRootComboBox.addActionListener(rootListener);
        this.myBranchComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitRebaseDialog.this.updateTrackedBranch();
            }
        });
    }

    private void updateBranches() {
        this.myBranchComboBox.removeAllItems();
        for (GitBranch b : this.myLocalBranches) {
            this.myBranchComboBox.addItem(b.getName());
        }
        if (this.myCurrentBranch != null) {
            this.myBranchComboBox.setSelectedItem(this.myCurrentBranch.getName());
        } else {
            this.myBranchComboBox.setSelectedItem(0);
        }
        this.updateOntoFrom();
        this.updateTrackedBranch();
    }

    private void updateOntoFrom() {
        String onto = GitUIUtil.getTextField(this.myOntoComboBox).getText();
        String from = GitUIUtil.getTextField(this.myFromComboBox).getText();
        this.myFromComboBox.removeAllItems();
        this.myOntoComboBox.removeAllItems();
        for (GitBranch b : this.myLocalBranches) {
            this.myFromComboBox.addItem(b);
            this.myOntoComboBox.addItem(b);
        }
        if (this.myShowRemoteBranchesCheckBox.isSelected()) {
            for (GitBranch b : this.myRemoteBranches) {
                this.myFromComboBox.addItem(b);
                this.myOntoComboBox.addItem(b);
            }
        }
        if (this.myShowTagsCheckBox.isSelected()) {
            for (GitTag t : this.myTags) {
                this.myFromComboBox.addItem(t);
                this.myOntoComboBox.addItem(t);
            }
        }
        GitUIUtil.getTextField(this.myOntoComboBox).setText(onto);
        GitUIUtil.getTextField(this.myFromComboBox).setText(from);
    }

    private void loadRefs() {
        try {
            this.myLocalBranches.clear();
            this.myRemoteBranches.clear();
            this.myTags.clear();
            VirtualFile root = this.gitRoot();
            GitBranch.list(this.myProject, root, true, false, this.myLocalBranches);
            GitBranch.list(this.myProject, root, false, true, this.myRemoteBranches);
            GitTag.list(this.myProject, root, this.myTags);
            this.myCurrentBranch = GitBranch.current(this.myProject, root);
        }
        catch (VcsException e) {
            GitUIUtil.showOperationError(this.myProject, e, "git branch -a");
        }
    }

    private void updateTrackedBranch() {
        try {
            GitBranch trackedBranch;
            VirtualFile root = this.gitRoot();
            String currentBranch = (String)this.myBranchComboBox.getSelectedItem();
            if (currentBranch != null) {
                String name;
                String remote = GitConfigUtil.getValue(this.myProject, root, "branch." + currentBranch + ".remote");
                String merge = GitConfigUtil.getValue(this.myProject, root, "branch." + currentBranch + ".merge");
                String string = name = merge != null && merge.startsWith("refs/heads/") ? merge.substring("refs/heads/".length()) : null;
                trackedBranch = remote == null || merge == null || name == null ? null : (remote.equals(".") ? new GitBranch(name, false, false) : new GitBranch(remote + "/" + name, false, true));
            } else {
                trackedBranch = null;
            }
            if (trackedBranch != null) {
                this.myOntoComboBox.setSelectedItem(trackedBranch);
            } else {
                GitUIUtil.getTextField(this.myOntoComboBox).setText("");
            }
            GitUIUtil.getTextField(this.myFromComboBox).setText("");
        }
        catch (VcsException e) {
            GitUIUtil.showOperationError(this.myProject, e, "git config");
        }
    }

    public VirtualFile gitRoot() {
        return (VirtualFile)this.myGitRootComboBox.getSelectedItem();
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected String getHelpId() {
        return "reference.VersionControl.Git.Rebase";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JComboBox jComboBox;
        JButton jButton;
        JComboBox jComboBox2;
        JButton jButton2;
        JComboBox jComboBox3;
        JComboBox jComboBox4;
        JComboBox jComboBox5;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(8, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.git.root"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(7, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myGitRootComboBox = jComboBox5 = new JComboBox();
        jComboBox5.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.git.root.tooltip"));
        jPanel.add(jComboBox5, new GridConstraints(0, 1, 1, 2, 8, 1, 2, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.branch"));
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myBranchComboBox = jComboBox4 = new JComboBox();
        jComboBox4.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.branch.tooltip"));
        jPanel.add(jComboBox4, new GridConstraints(1, 1, 1, 2, 8, 1, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.onto"));
        jPanel.add((Component)jLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOntoComboBox = jComboBox3 = new JComboBox();
        jComboBox3.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.onto.tooltip"));
        jComboBox3.setEditable(true);
        jPanel.add(jComboBox3, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, null, null));
        this.myOntoValidateButton = jButton2 = new JButton();
        jButton2.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.valdate.onto.tooltip"));
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.onto.validate"));
        jPanel.add((Component)jButton2, new GridConstraints(3, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.merge.strategy"));
        jPanel.add((Component)jLabel4, new GridConstraints(6, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.from"));
        jPanel.add((Component)jLabel5, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFromComboBox = jComboBox2 = new JComboBox();
        jComboBox2.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.from.tooltip"));
        jComboBox2.setEditable(true);
        jPanel.add(jComboBox2, new GridConstraints(4, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myFromValidateButton = jButton = new JButton();
        jButton.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.validate.from.tooltip"));
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.validate.from"));
        jPanel.add((Component)jButton, new GridConstraints(4, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(6, 1, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myMergeStrategyComboBox = jComboBox = new JComboBox();
        jComboBox.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.merge.strategy.tooltip"));
        jPanel2.add(jComboBox, new GridConstraints(0, 0, 1, 1, 8, 0, 2, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myDoNotUseMergeCheckBox = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.no.merge"));
        jCheckBox5.setSelected(false);
        jCheckBox5.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.no.merge.tooltip"));
        jPanel2.add((Component)jCheckBox5, new GridConstraints(1, 0, 1, 1, 8, 0, 1, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(2, 1, 1, 2, 0, 3, 7, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myPreserveMergesCheckBox = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.preserve.merges"));
        jCheckBox4.setSelected(false);
        jCheckBox4.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.preserve.merges.tooltip"));
        jPanel3.add((Component)jCheckBox4, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myInteractiveCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.interactive"));
        jCheckBox3.setSelected(true);
        ((Component)jCheckBox3).setEnabled(true);
        jCheckBox3.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.interactive.tooltip"));
        jPanel3.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel4, new GridConstraints(5, 1, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myShowTagsCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("regase.show.tags"));
        jCheckBox2.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.show.tags.tooltip"));
        jPanel4.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myShowRemoteBranchesCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.show.remote.branches"));
        jCheckBox.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.show.remote.branches.tooltip"));
        jPanel4.add((Component)jCheckBox, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel4.add((Component)spacer4, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        jLabel.setLabelFor(jComboBox5);
        jLabel2.setLabelFor(jComboBox4);
        jLabel3.setLabelFor(jComboBox3);
        jLabel4.setLabelFor(jComboBox);
        jLabel5.setLabelFor(jComboBox2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

