/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionUtil;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.RefactoringListeners;
import com.intellij.execution.junit.TestObject;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import org.jetbrains.annotations.NotNull;

class TestMethod
extends TestObject {
    public TestMethod(Project project, JUnitConfiguration configuration, RunnerSettings runnerSettings, ConfigurationPerRunnerSettings configurationSettings) {
        super(project, configuration, runnerSettings, configurationSettings);
    }

    @Override
    protected void initialize() throws ExecutionException {
        this.defaultInitialize();
        JUnitConfiguration.Data data = this.myConfiguration.getPersistentData();
        RunConfigurationModule module = this.myConfiguration.getConfigurationModule();
        this.configureModule(this.getJavaParameters(), module, data.getMainClassName());
        this.addJUnit4Parameter(data, module.getProject());
        this.getJavaParameters().getProgramParametersList().add(data.getMainClassName() + "," + data.getMethodName());
    }

    protected void defaultInitialize() throws ExecutionException {
        super.initialize();
    }

    protected void addJUnit4Parameter(JUnitConfiguration.Data data, Project project) {
        PsiMethod[] methods;
        PsiClass psiClass = JavaExecutionUtil.findMainClass((Project)project, (String)data.getMainClassName(), (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
        LOG.assertTrue(psiClass != null);
        if (JUnitUtil.isJUnit4TestClass((PsiClass)psiClass)) {
            this.myJavaParameters.getProgramParametersList().add("-junit4");
            return;
        }
        String methodName = data.getMethodName();
        for (PsiMethod method : methods = psiClass.findMethodsByName(methodName, true)) {
            if (!JUnitUtil.isTestAnnotated((PsiMethod)method)) continue;
            this.myJavaParameters.getProgramParametersList().add("-junit4");
            break;
        }
    }

    @Override
    public String suggestActionName() {
        return ExecutionUtil.shortenName((String)this.myConfiguration.getPersistentData().METHOD_NAME, (int)2) + "()";
    }

    @Override
    public RefactoringElementListener getListener(PsiElement element, final JUnitConfiguration configuration) {
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            if (!method.getName().equals(configuration.getPersistentData().getMethodName())) {
                return null;
            }
            if (!method.getContainingClass().equals(configuration.myClass.getPsiElement())) {
                return null;
            }
            return new RefactoringElementListener(){

                public void elementMoved(@NotNull PsiElement newElement) {
                    if (newElement == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/junit/TestMethod$1.elementMoved must not be null");
                    }
                    this.setMethod(configuration, (PsiMethod)newElement);
                }

                public void elementRenamed(@NotNull PsiElement newElement) {
                    if (newElement == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/junit/TestMethod$1.elementRenamed must not be null");
                    }
                    this.setMethod(configuration, (PsiMethod)newElement);
                }

                private void setMethod(JUnitConfiguration configuration2, PsiMethod psiMethod) {
                    boolean generatedName = configuration2.isGeneratedName();
                    configuration2.getPersistentData().setTestMethod((Location<PsiMethod>)PsiLocation.fromPsiElement((PsiElement)psiMethod));
                    if (generatedName) {
                        configuration2.setGeneratedName();
                    }
                }
            };
        }
        return RefactoringListeners.getClassOrPackageListener((PsiElement)element, configuration.myClass);
    }

    @Override
    public boolean isConfiguredByElement(JUnitConfiguration configuration, PsiElement element) {
        PsiClass aClass = JUnitUtil.getTestClass((PsiElement)element);
        if (aClass == null) {
            return false;
        }
        PsiMethod method = JUnitUtil.getTestMethod((PsiElement)element);
        if (method == null) {
            return false;
        }
        JUnitConfiguration.Data data = configuration.getPersistentData();
        return Comparing.equal((String)JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)aClass), (String)data.getMainClassName()) && Comparing.equal((String)method.getName(), (String)data.getMethodName());
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        JavaRunConfigurationModule configurationModule = (JavaRunConfigurationModule)this.myConfiguration.getConfigurationModule();
        JUnitConfiguration.Data data = this.myConfiguration.getPersistentData();
        String testClass = data.getMainClassName();
        PsiClass psiClass = configurationModule.checkModuleAndClassName(testClass, ExecutionBundle.message((String)"no.test.class.specified.error.text", (Object[])new Object[0]));
        String methodName = data.getMethodName();
        if (methodName == null || methodName.trim().length() == 0) {
            throw new RuntimeConfigurationError(ExecutionBundle.message((String)"method.name.not.specified.error.message", (Object[])new Object[0]));
        }
        JUnitUtil.TestMethodFilter filter = new JUnitUtil.TestMethodFilter(psiClass);
        boolean found = false;
        boolean testAnnotated = false;
        for (PsiMethod method : psiClass.findMethodsByName(methodName, true)) {
            if (filter.value(method)) {
                found = true;
            }
            if (!JUnitUtil.isTestAnnotated((PsiMethod)method)) continue;
            testAnnotated = true;
        }
        if (!found) {
            throw new RuntimeConfigurationWarning(ExecutionBundle.message((String)"test.method.doesnt.exist.error.message", (Object[])new Object[]{methodName}));
        }
        if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"org.junit.runner.RunWith", (boolean)true) && !testAnnotated) {
            try {
                PsiClass testCaseClass = JUnitUtil.getTestCaseClass((Module)configurationModule.getModule());
                if (!psiClass.isInheritor(testCaseClass, true)) {
                    throw new RuntimeConfigurationError(ExecutionBundle.message((String)"class.isnt.inheritor.of.testcase.error.message", (Object[])new Object[]{testClass}));
                }
            }
            catch (JUnitUtil.NoJUnitException e) {
                throw new RuntimeConfigurationWarning(ExecutionBundle.message((String)"junit.jar.not.found.in.module.class.path.error.message", (Object[])new Object[]{configurationModule.getModuleName()}));
            }
        }
    }
}

