/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.ui;

import com.intellij.execution.junit2.TestProxy;
import com.intellij.execution.junit2.info.TestInfo;
import com.intellij.execution.junit2.ui.Animator;
import com.intellij.execution.junit2.ui.Formatters;
import com.intellij.execution.junit2.ui.model.SpecialNode;
import com.intellij.execution.testframework.PoolOfTestIcons;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import javax.swing.Icon;

class TestRenderer {
    private static final Map<Integer, Icon> ourIcons = new HashMap();

    TestRenderer() {
    }

    public static Icon getIconFor(TestProxy testProxy, boolean isPaused) {
        int magnitude = testProxy.getState().getMagnitude();
        if (magnitude == 3) {
            return isPaused ? Animator.PAUSED_ICON : Animator.getCurrentFrame();
        }
        return ourIcons.get(new Integer(magnitude));
    }

    private static SimpleTextAttributes getSpecialAttributes() {
        return new SimpleTextAttributes(1, TestsUIUtil.PASSED_COLOR);
    }

    private static void mapIcon(int index, Icon icon) {
        ourIcons.put(new Integer(index), icon);
    }

    public static void renderTest(TestProxy test, SimpleColoredComponent renderer) {
        TestInfo info = test.getInfo();
        if (test instanceof SpecialNode) {
            renderer.append(info.getName(), TestRenderer.getSpecialAttributes());
        } else {
            renderer.append(info.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            renderer.append(Formatters.sensibleCommentFor(test), SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    static {
        TestRenderer.mapIcon(0, PoolOfTestIcons.SKIPPED_ICON);
        TestRenderer.mapIcon(2, PoolOfTestIcons.NOT_RAN);
        TestRenderer.mapIcon(1, PoolOfTestIcons.PASSED_ICON);
        TestRenderer.mapIcon(4, PoolOfTestIcons.TERMINATED_ICON);
        TestRenderer.mapIcon(6, PoolOfTestIcons.FAILED_ICON);
        TestRenderer.mapIcon(7, PoolOfTestIcons.FAILED_ICON);
        TestRenderer.mapIcon(8, PoolOfTestIcons.ERROR_ICON);
        TestRenderer.mapIcon(5, PoolOfTestIcons.IGNORED_ICON);
    }
}

