/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang;

import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.util.FileContentUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.intellij.plugins.intelliLang.inject.config.InjectionPlace;
import org.intellij.plugins.intelliLang.inject.config.MethodParameterInjection;
import org.intellij.plugins.intelliLang.inject.config.XmlAttributeInjection;
import org.intellij.plugins.intelliLang.inject.config.XmlTagInjection;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="LanguageInjectionConfiguration", storages={@Storage(id="dir", file="$APP_CONFIG$/IntelliLang.xml", scheme=StorageScheme.DIRECTORY_BASED)})
public final class Configuration
implements PersistentStateComponent<Element> {
    static final Logger LOG = Logger.getInstance((String)Configuration.class.getName());
    @NonNls
    public static final String COMPONENT_NAME = "LanguageInjectionConfiguration";
    @NonNls
    private static final String TAG_INJECTION_NAME = "TAGS";
    @NonNls
    private static final String ATTRIBUTE_INJECTION_NAME = "ATTRIBUTES";
    @NonNls
    private static final String PARAMETER_INJECTION_NAME = "PARAMETERS";
    @NonNls
    private static final String INSTRUMENTATION_TYPE_NAME = "INSTRUMENTATION";
    @NonNls
    private static final String LANGUAGE_ANNOTATION_NAME = "LANGUAGE_ANNOTATION";
    @NonNls
    private static final String PATTERN_ANNOTATION_NAME = "PATTERN_ANNOTATION";
    @NonNls
    private static final String SUBST_ANNOTATION_NAME = "SUBST_ANNOTATION";
    @NonNls
    private static final String ENTRY_NAME = "entry";
    @NonNls
    private static final String RESOLVE_REFERENCES = "RESOLVE_REFERENCES";
    @NonNls
    private static final String USE_DFA_IF_AVAILABLE = "USE_DFA_IF_AVAILABLE";
    @NonNls
    private static final String INCLUDE_UNCOMPUTABLES_AS_LITERALS = "INCLUDE_UNCOMPUTABLES_AS_LITERALS";
    private final Map<String, List<BaseInjection>> myInjections = new ConcurrentFactoryMap<String, List<BaseInjection>>(){

        protected List<BaseInjection> create(String key) {
            return new CopyOnWriteArrayList<BaseInjection>();
        }
    };
    private ArrayList<BaseInjection> myDefaultInjections;
    @NotNull
    private InstrumentationType myInstrumentationType = InstrumentationType.ASSERT;
    @NotNull
    private String myLanguageAnnotation;
    @NotNull
    private String myPatternAnnotation;
    @NotNull
    private String mySubstAnnotation;
    private boolean myResolveReferences;
    private boolean myIncludeUncomputablesAsLiterals;
    private boolean myUseDfaIfAvailable;
    private Pair<String, ? extends Set<String>> myLanguageAnnotationPair;
    private Pair<String, ? extends Set<String>> myPatternAnnotationPair;
    private Pair<String, ? extends Set<String>> mySubstAnnotationPair;
    private volatile long myModificationCount;

    public Configuration() {
        this.setResolveReferences(true);
        this.setLanguageAnnotation("org.intellij.lang.annotations.Language");
        this.setPatternAnnotation("org.intellij.lang.annotations.Pattern");
        this.setSubstAnnotation("org.intellij.lang.annotations.Subst");
    }

    public void loadState(Element element) {
        this.loadState(element, true);
    }

    public void loadState(Element element, boolean mergeWithOriginalAndCompile) {
        THashMap supports = new THashMap();
        for (LanguageInjectionSupport support : (LanguageInjectionSupport[])Extensions.getExtensions(LanguageInjectionSupport.EP_NAME)) {
            supports.put((Object)support.getId(), (Object)support);
        }
        this.myInjections.get("xml").addAll(Configuration.readExternal(element.getChild(TAG_INJECTION_NAME), new Factory<XmlTagInjection>(){

            public XmlTagInjection create() {
                return new XmlTagInjection();
            }
        }));
        this.myInjections.get("xml").addAll(Configuration.readExternal(element.getChild(ATTRIBUTE_INJECTION_NAME), new Factory<XmlAttributeInjection>(){

            public XmlAttributeInjection create() {
                return new XmlAttributeInjection();
            }
        }));
        this.myInjections.get("java").addAll(Configuration.readExternal(element.getChild(PARAMETER_INJECTION_NAME), new Factory<MethodParameterInjection>(){

            public MethodParameterInjection create() {
                return new MethodParameterInjection();
            }
        }));
        for (Element child : element.getChildren("injection")) {
            LanguageInjectionSupport support;
            String key = child.getAttributeValue("injector-id");
            support = (LanguageInjectionSupport)supports.get((Object)key);
            BaseInjection injection = support == null ? new BaseInjection(key) : support.createInjection(child);
            injection.loadState(child);
            this.myInjections.get(key).add(injection);
        }
        this.setInstrumentationType(JDOMExternalizerUtil.readField((Element)element, (String)INSTRUMENTATION_TYPE_NAME));
        this.setLanguageAnnotation(JDOMExternalizerUtil.readField((Element)element, (String)LANGUAGE_ANNOTATION_NAME));
        this.setPatternAnnotation(JDOMExternalizerUtil.readField((Element)element, (String)PATTERN_ANNOTATION_NAME));
        this.setSubstAnnotation(JDOMExternalizerUtil.readField((Element)element, (String)SUBST_ANNOTATION_NAME));
        this.setResolveReferences(Configuration.readBoolean(element, RESOLVE_REFERENCES, true));
        this.setUseDfaIfAvailable(Configuration.readBoolean(element, USE_DFA_IF_AVAILABLE, false));
        this.setIncludeUncomputablesAsLiterals(Configuration.readBoolean(element, INCLUDE_UNCOMPUTABLES_AS_LITERALS, false));
        if (mergeWithOriginalAndCompile) {
            this.mergeWithDefaultConfiguration();
            for (String supportId : InjectorUtils.getActiveInjectionSupportIds()) {
                for (BaseInjection injection : this.getInjections(supportId)) {
                    injection.initializePlaces(true);
                }
            }
        }
    }

    private static boolean readBoolean(Element element, String key, boolean defValue) {
        String value = JDOMExternalizerUtil.readField((Element)element, (String)key);
        if (value == null) {
            return defValue;
        }
        return Boolean.parseBoolean(value);
    }

    private void mergeWithDefaultConfiguration() {
        ArrayList<Configuration> cfgList = new ArrayList<Configuration>();
        for (LanguageInjectionSupport support : InjectorUtils.getActiveInjectionSupports()) {
            String url = support.getDefaultConfigUrl();
            if (url == null) continue;
            try {
                cfgList.add(Configuration.load(support.getClass().getResourceAsStream(url)));
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        }
        ArrayList<BaseInjection> originalInjections = new ArrayList<BaseInjection>();
        ArrayList<BaseInjection> newInjections = new ArrayList<BaseInjection>();
        this.myDefaultInjections = new ArrayList();
        for (String supportId : InjectorUtils.getActiveInjectionSupportIds()) {
            for (Configuration cfg : cfgList) {
                List<BaseInjection> imported = cfg.getInjections(supportId);
                this.myDefaultInjections.addAll(imported);
                Configuration.importInjections(this.getInjections(supportId), imported, originalInjections, newInjections);
            }
        }
        this.replaceInjections(newInjections, originalInjections);
    }

    public Element getState() {
        Element element = new Element(COMPONENT_NAME);
        JDOMExternalizerUtil.writeField((Element)element, (String)INSTRUMENTATION_TYPE_NAME, (String)this.myInstrumentationType.toString());
        JDOMExternalizerUtil.writeField((Element)element, (String)LANGUAGE_ANNOTATION_NAME, (String)this.myLanguageAnnotation);
        JDOMExternalizerUtil.writeField((Element)element, (String)PATTERN_ANNOTATION_NAME, (String)this.myPatternAnnotation);
        JDOMExternalizerUtil.writeField((Element)element, (String)SUBST_ANNOTATION_NAME, (String)this.mySubstAnnotation);
        JDOMExternalizerUtil.writeField((Element)element, (String)RESOLVE_REFERENCES, (String)String.valueOf(this.myResolveReferences));
        ArrayList<String> injectorIds = new ArrayList<String>(this.myInjections.keySet());
        Collections.sort(injectorIds);
        for (String key : injectorIds) {
            ArrayList injections = new ArrayList(this.myInjections.get(key));
            if (this.myDefaultInjections != null) {
                injections.removeAll(this.myDefaultInjections);
            }
            Collections.sort(injections, new Comparator<BaseInjection>(){

                @Override
                public int compare(BaseInjection o1, BaseInjection o2) {
                    return Comparing.compare((Comparable)((Object)o1.getDisplayName()), (Comparable)((Object)o2.getDisplayName()));
                }
            });
            for (BaseInjection injection : injections) {
                element.addContent(injection.getState());
            }
        }
        return element;
    }

    private static <T extends BaseInjection> List<T> readExternal(Element element, Factory<T> factory) {
        ArrayList<BaseInjection> injections = new ArrayList<BaseInjection>();
        if (element != null) {
            List list = element.getChildren(ENTRY_NAME);
            for (Element entry : list) {
                BaseInjection o = (BaseInjection)factory.create();
                o.loadState(entry);
                injections.add(o);
            }
        }
        return injections;
    }

    public static Configuration getInstance() {
        return (Configuration)ServiceManager.getService(Configuration.class);
    }

    public String getLanguageAnnotationClass() {
        return this.myLanguageAnnotation;
    }

    public String getPatternAnnotationClass() {
        return this.myPatternAnnotation;
    }

    public String getSubstAnnotationClass() {
        return this.mySubstAnnotation;
    }

    public void setInstrumentationType(@Nullable String type) {
        if (type != null) {
            this.setInstrumentationType(InstrumentationType.valueOf(type));
        }
    }

    public void setInstrumentationType(@NotNull InstrumentationType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/Configuration.setInstrumentationType must not be null");
        }
        this.myInstrumentationType = type;
    }

    public void setLanguageAnnotation(@Nullable String languageAnnotation) {
        if (languageAnnotation == null) {
            return;
        }
        this.myLanguageAnnotation = languageAnnotation;
        this.myLanguageAnnotationPair = Pair.create((Object)languageAnnotation, Collections.singleton(languageAnnotation));
    }

    public Pair<String, ? extends Set<String>> getLanguageAnnotationPair() {
        return this.myLanguageAnnotationPair;
    }

    public void setPatternAnnotation(@Nullable String patternAnnotation) {
        if (patternAnnotation == null) {
            return;
        }
        this.myPatternAnnotation = patternAnnotation;
        this.myPatternAnnotationPair = Pair.create((Object)patternAnnotation, Collections.singleton(patternAnnotation));
    }

    public Pair<String, ? extends Set<String>> getPatternAnnotationPair() {
        return this.myPatternAnnotationPair;
    }

    public void setSubstAnnotation(@Nullable String substAnnotation) {
        if (substAnnotation == null) {
            return;
        }
        this.mySubstAnnotation = substAnnotation;
        this.mySubstAnnotationPair = Pair.create((Object)substAnnotation, Collections.singleton(substAnnotation));
    }

    public Pair<String, ? extends Set<String>> getSubstAnnotationPair() {
        return this.mySubstAnnotationPair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Configuration load(InputStream is) throws IOException, JDOMException {
        try {
            Document document = JDOMUtil.loadDocument((InputStream)is);
            ArrayList<Element> elements = new ArrayList<Element>();
            elements.add(document.getRootElement());
            elements.addAll(document.getRootElement().getChildren("component"));
            Element element = (Element)ContainerUtil.find(elements, (Condition)new Condition<Element>(){

                public boolean value(Element element) {
                    return "component".equals(element.getName()) && Configuration.COMPONENT_NAME.equals(element.getAttributeValue("name"));
                }
            });
            if (element != null) {
                Configuration cfg = new Configuration();
                cfg.loadState(element, false);
                Configuration configuration = cfg;
                return configuration;
            }
            Configuration configuration = null;
            return configuration;
        }
        finally {
            is.close();
        }
    }

    public int importFrom(Configuration cfg) {
        ArrayList<BaseInjection> originalInjections = new ArrayList<BaseInjection>();
        ArrayList<BaseInjection> newInjections = new ArrayList<BaseInjection>();
        for (String supportId : InjectorUtils.getActiveInjectionSupportIds()) {
            Configuration.importInjections(this.getInjections(supportId), cfg.getInjections(supportId), originalInjections, newInjections);
        }
        if (!newInjections.isEmpty()) {
            this.configurationModified();
        }
        this.replaceInjections(newInjections, originalInjections);
        return newInjections.size();
    }

    static void importInjections(Collection<BaseInjection> existingInjections, Collection<BaseInjection> importingInjections, Collection<BaseInjection> originalInjections, Collection<BaseInjection> newInjections) {
        final MultiValuesMap<String, BaseInjection> existingMap = Configuration.createInjectionMap(existingInjections);
        block0: for (BaseInjection other : importingInjections) {
            List matchingInjections = ContainerUtil.concat(other.getInjectionPlaces(), (Function)new Function<InjectionPlace, Collection<? extends BaseInjection>>(){

                public Collection<? extends BaseInjection> fun(InjectionPlace o) {
                    Collection collection = existingMap.get((Object)o.getText());
                    return collection == null ? Collections.emptyList() : collection;
                }
            });
            if (matchingInjections.isEmpty()) {
                newInjections.add(other);
                continue;
            }
            BaseInjection existing = null;
            for (BaseInjection injection : matchingInjections) {
                if (injection.equals(other)) continue block0;
                if (existing != null || !injection.sameLanguageParameters(other)) continue;
                existing = injection;
            }
            if (existing == null) continue;
            BaseInjection newInjection = existing.copy();
            newInjection.mergeOriginalPlacesFrom(other, true);
            if (newInjection.equals(existing)) continue;
            originalInjections.add(existing);
            newInjections.add(newInjection);
        }
    }

    private static MultiValuesMap<String, BaseInjection> createInjectionMap(Collection<BaseInjection> injections) {
        MultiValuesMap existingMap = new MultiValuesMap();
        for (BaseInjection injection : injections) {
            for (InjectionPlace place : injection.getInjectionPlaces()) {
                existingMap.put((Object)place.getText(), (Object)injection);
            }
        }
        return existingMap;
    }

    public void configurationModified() {
        ++this.myModificationCount;
    }

    public long getModificationCount() {
        return this.myModificationCount;
    }

    public boolean isResolveReferences() {
        return this.myResolveReferences;
    }

    public void setResolveReferences(boolean resolveReferences) {
        this.myResolveReferences = resolveReferences;
    }

    public boolean isIncludeUncomputablesAsLiterals() {
        return this.myIncludeUncomputablesAsLiterals;
    }

    public void setIncludeUncomputablesAsLiterals(boolean flag) {
        this.myIncludeUncomputablesAsLiterals = flag;
    }

    public boolean isUseDfaIfAvailable() {
        return this.myUseDfaIfAvailable;
    }

    public void setUseDfaIfAvailable(boolean flag) {
        this.myUseDfaIfAvailable = flag;
    }

    @Nullable
    public BaseInjection findExistingInjection(@NotNull BaseInjection injection) {
        if (injection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/Configuration.findExistingInjection must not be null");
        }
        List<BaseInjection> list = this.getInjections(injection.getSupportId());
        for (BaseInjection cur : list) {
            if (!cur.intersectsWith(injection)) continue;
            return cur;
        }
        return null;
    }

    public boolean setHostInjectionEnabled(PsiLanguageInjectionHost host, Collection<String> languages, boolean enabled) {
        ArrayList<BaseInjection> originalInjections = new ArrayList<BaseInjection>();
        ArrayList<BaseInjection> newInjections = new ArrayList<BaseInjection>();
        for (String supportId : this.getAllInjectorIds()) {
            for (BaseInjection injection : this.getInjections(supportId)) {
                if (!languages.contains(injection.getInjectedLanguageId())) continue;
                boolean replace = false;
                ArrayList<InjectionPlace> newPlaces = new ArrayList<InjectionPlace>();
                for (InjectionPlace place : injection.getInjectionPlaces()) {
                    if (place.isEnabled() != enabled && place.getElementPattern() != null && (place.getElementPattern().accepts((Object)host) || place.getElementPattern().accepts((Object)host.getParent()))) {
                        newPlaces.add(new InjectionPlace(place.getText(), place.getElementPattern(), enabled));
                        replace = true;
                        continue;
                    }
                    newPlaces.add(place);
                }
                if (!replace) continue;
                originalInjections.add(injection);
                BaseInjection newInjection = injection.copy();
                newInjection.getInjectionPlaces().clear();
                newInjection.getInjectionPlaces().addAll(newPlaces);
                newInjections.add(newInjection);
            }
        }
        if (!originalInjections.isEmpty()) {
            this.replaceInjectionsWithUndo(host.getProject(), newInjections, originalInjections, Collections.emptyList());
            return true;
        }
        return false;
    }

    public InstrumentationType getInstrumentation() {
        return this.myInstrumentationType;
    }

    @NotNull
    public List<BaseInjection> getInjections(String injectorId) {
        List<BaseInjection> list = Collections.unmodifiableList(this.myInjections.get(injectorId));
        if (list == null) {
            throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/Configuration.getInjections must not return null");
        }
        return list;
    }

    public Set<String> getAllInjectorIds() {
        return Collections.unmodifiableSet(this.myInjections.keySet());
    }

    public void replaceInjectionsWithUndo(Project project, List<? extends BaseInjection> newInjections, List<? extends BaseInjection> originalInjections, List<? extends PsiElement> psiElementsToRemove) {
        Configuration.replaceInjectionsWithUndo(project, newInjections, originalInjections, psiElementsToRemove, new PairProcessor<List<? extends BaseInjection>, List<? extends BaseInjection>>(){

            public boolean process(List<? extends BaseInjection> add, List<? extends BaseInjection> remove) {
                Configuration.this.replaceInjections(add, remove);
                return true;
            }
        });
    }

    public static <T> void replaceInjectionsWithUndo(final Project project, final T add, final T remove, final List<? extends PsiElement> psiElementsToRemove, final PairProcessor<T, T> actualProcessor) {
        final UndoableAction action = new UndoableAction(){

            public void undo() {
                actualProcessor.process(remove, add);
            }

            public void redo() {
                actualProcessor.process(add, remove);
            }

            public DocumentReference[] getAffectedDocuments() {
                return DocumentReference.EMPTY_ARRAY;
            }

            public boolean isGlobal() {
                return true;
            }
        };
        List psiFiles = ContainerUtil.mapNotNull(psiElementsToRemove, (Function)new NullableFunction<PsiElement, PsiFile>(){

            public PsiFile fun(PsiElement psiAnnotation) {
                return psiAnnotation instanceof PsiCompiledElement ? null : psiAnnotation.getContainingFile();
            }
        });
        new WriteCommandAction.Simple(project, "Language Injection Configuration Update", psiFiles.toArray(new PsiFile[psiFiles.size()])){

            public void run() {
                for (PsiElement annotation : psiElementsToRemove) {
                    annotation.delete();
                }
                actualProcessor.process(add, remove);
                UndoManager.getInstance((Project)project).undoableActionPerformed(action);
            }

            protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
                return UndoConfirmationPolicy.REQUEST_CONFIRMATION;
            }
        }.execute();
    }

    public void replaceInjections(List<? extends BaseInjection> newInjections, List<? extends BaseInjection> originalInjections) {
        for (BaseInjection baseInjection : originalInjections) {
            this.myInjections.get(baseInjection.getSupportId()).remove(baseInjection);
        }
        for (BaseInjection baseInjection : newInjections) {
            baseInjection.initializePlaces(true);
            this.myInjections.get(baseInjection.getSupportId()).add(baseInjection);
        }
        this.configurationModified();
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            FileContentUtil.reparseFiles((Project)project, Collections.emptyList(), (boolean)true);
        }
    }

    public static enum InstrumentationType {
        NONE,
        ASSERT,
        EXCEPTION;

    }
}

