/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject;

import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiUtilBase;
import java.util.Collections;
import java.util.List;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.TemporaryPlacesRegistry;
import org.jetbrains.annotations.NotNull;

public class TemporaryPlacesInjector
implements MultiHostInjector {
    public static final Logger LOG = Logger.getInstance((String)"org.intellij.plugins.intelliLang.inject.TemporaryPlacesInjector");

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<PsiLanguageInjectionHost>> list = Collections.singletonList(PsiLanguageInjectionHost.class);
        if (list == null) {
            throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/TemporaryPlacesInjector.elementsToInjectIn must not return null");
        }
        return list;
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        if (registrar == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/TemporaryPlacesInjector.getLanguagesToInject must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/TemporaryPlacesInjector.getLanguagesToInject must not be null");
        }
        PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)context;
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)host);
        if (manipulator == null) {
            return;
        }
        PsiLanguageInjectionHost originalHost = (PsiLanguageInjectionHost)PsiUtilBase.getOriginalElement((PsiElement)host, host.getClass());
        List<TemporaryPlacesRegistry.TemporaryPlace> list = TemporaryPlacesRegistry.getInstance(context.getProject()).getTempInjectionsSafe(originalHost);
        for (TemporaryPlacesRegistry.TemporaryPlace place : list) {
            LOG.assertTrue(place.language != null, (Object)"Language should not be NULL");
            InjectorUtils.registerInjection(place.language.getLanguage(), Collections.singletonList(Trinity.create((Object)host, (Object)place.language, (Object)manipulator.getRangeInElement((PsiElement)host))), context.getContainingFile(), registrar);
        }
    }
}

