/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.config;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.intellij.plugins.intelliLang.PatternBasedInjectionHelper;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodParameterInjection
extends BaseInjection {
    @NotNull
    private String myClassName = "";
    @NotNull
    private final Map<String, MethodInfo> myParameterMap = new THashMap();

    public MethodParameterInjection() {
        super("java");
    }

    @NotNull
    public String getClassName() {
        String string = this.myClassName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/config/MethodParameterInjection.getClassName must not return null");
        }
        return string;
    }

    public void setClassName(@NotNull String className) {
        if (className == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/config/MethodParameterInjection.setClassName must not be null");
        }
        this.myClassName = className;
    }

    public void setMethodInfos(Collection<MethodInfo> newInfos) {
        this.myParameterMap.clear();
        for (MethodInfo methodInfo : newInfos) {
            this.myParameterMap.put(methodInfo.getMethodSignature(), methodInfo);
        }
    }

    public Collection<MethodInfo> getMethodInfos() {
        return this.myParameterMap.values();
    }

    @Override
    public MethodParameterInjection copyFrom(@NotNull BaseInjection o) {
        if (o == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/config/MethodParameterInjection.copyFrom must not be null");
        }
        super.copyFrom(o);
        if (o instanceof MethodParameterInjection) {
            MethodParameterInjection other = (MethodParameterInjection)o;
            this.myClassName = other.getClassName();
            this.myParameterMap.clear();
            for (MethodInfo info : other.myParameterMap.values()) {
                this.myParameterMap.put(info.methodSignature, info.copy());
            }
        }
        return this;
    }

    @Override
    protected void readExternalImpl(Element e) {
        if (e.getAttribute("injector-id") == null) {
            this.setClassName(JDOMExternalizer.readString((Element)e, (String)"CLASS"));
            this.readOldFormat(e);
            THashMap map = new THashMap();
            JDOMExternalizer.readMap((Element)e, (Map)map, null, (String)"SIGNATURES");
            for (String s : map.keySet()) {
                String fixedSignature = MethodParameterInjection.fixSignature(s, false);
                this.myParameterMap.put(fixedSignature, new MethodInfo(fixedSignature, (String)map.get((Object)s)));
            }
        }
    }

    private void readOldFormat(Element e) {
        JDOMExternalizableStringList list = new JDOMExternalizableStringList();
        try {
            list.readExternal(e);
        }
        catch (InvalidDataException e1) {
            // empty catch block
        }
        if (list.isEmpty()) {
            return;
        }
        boolean[] selection = new boolean[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            selection[i] = Boolean.parseBoolean((String)list.get(i));
        }
        String methodSignature = MethodParameterInjection.fixSignature(JDOMExternalizer.readString((Element)e, (String)"METHOD"), false);
        this.myParameterMap.put(methodSignature, new MethodInfo(methodSignature, selection, false));
    }

    @Override
    protected void writeExternalImpl(Element e) {
    }

    @Override
    public MethodParameterInjection copy() {
        return new MethodParameterInjection().copyFrom(this);
    }

    @Override
    protected List<String> generatePlaces() {
        return PatternBasedInjectionHelper.getPatternString(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MethodParameterInjection that = (MethodParameterInjection)o;
        if (!this.myClassName.equals(that.myClassName)) {
            return false;
        }
        return ((Object)this.myParameterMap).equals(that.myParameterMap);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myClassName.hashCode();
        result = 31 * result + ((Object)this.myParameterMap).hashCode();
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public String getDisplayName() {
        String className = this.getClassName();
        if (StringUtil.isEmpty((String)className)) {
            return "<unnamed>";
        }
        MethodInfo singleInfo = null;
        for (MethodInfo info : this.myParameterMap.values()) {
            if (!info.isEnabled()) continue;
            if (singleInfo == null) {
                singleInfo = info;
                continue;
            }
            singleInfo = null;
            break;
        }
        String name = singleInfo != null ? StringUtil.getShortName((String)className) + "." + singleInfo.methodName : StringUtil.getShortName((String)className);
        String string = name + " (" + StringUtil.getPackageName((String)className) + ")";
        String string2 = string;
        if (string == null) throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/config/MethodParameterInjection.getDisplayName must not return null");
        return string2;
    }

    public static String fixSignature(String signature, boolean parameterNames) {
        StringBuilder sb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(signature, "(,)");
        int i = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (i > 1) {
                sb.append(", ");
            }
            if (i == 0) {
                sb.append(token).append("(");
            } else {
                int idx = token.indexOf(32);
                if (idx > -1) {
                    if (parameterNames) {
                        sb.append(token);
                    } else {
                        sb.append(token.substring(0, idx));
                    }
                } else {
                    sb.append(token);
                    if (parameterNames) {
                        sb.append(' ').append('p').append(i);
                    }
                }
            }
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    @NotNull
    private static String buildSignature(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/config/MethodParameterInjection.buildSignature must not be null");
        }
        String string = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)73730);
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/config/MethodParameterInjection.buildSignature must not return null");
        }
        return string;
    }

    public static MethodInfo createMethodInfo(PsiMethod method) {
        String signature = MethodParameterInjection.buildSignature(method);
        return new MethodInfo(signature, new boolean[method.getParameterList().getParametersCount()], false);
    }

    public static boolean isInjectable(@Nullable PsiType type, Project project) {
        if (type == null) {
            return false;
        }
        if (type instanceof PsiPrimitiveType) {
            return false;
        }
        if (project.isDefault()) {
            String text = type.getPresentableText();
            if (text == null) {
                return false;
            }
            return text.equals("java.lang.String") || text.equals("java.lang.String...") || text.equals("java.lang.String[]");
        }
        return type.equalsToText("java.lang.String") || type.equalsToText("java.lang.String...") || type.equalsToText("java.lang.String[]");
    }

    @Nullable
    public static PsiMethod makeMethod(Project project, String signature) {
        if (StringUtil.isEmpty((String)signature)) {
            return null;
        }
        try {
            return JavaPsiFacade.getInstance((Project)project).getElementFactory().createMethodFromText("void " + MethodParameterInjection.fixSignature(signature, true) + "{}", null);
        }
        catch (IncorrectOperationException incorrectOperationException) {
            return null;
        }
    }

    public static class MethodInfo {
        @NotNull
        final String methodSignature;
        @NotNull
        final String methodName;
        @NotNull
        final boolean[] paramFlags;
        boolean returnFlag;

        public MethodInfo(@NotNull String methodSignature, @NotNull boolean[] paramFlags, boolean returnFlag) {
            if (methodSignature == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/config/MethodParameterInjection$MethodInfo.<init> must not be null");
            }
            if (paramFlags == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/config/MethodParameterInjection$MethodInfo.<init> must not be null");
            }
            this.methodSignature = methodSignature;
            this.paramFlags = paramFlags;
            this.returnFlag = returnFlag;
            this.methodName = MethodInfo.calcMethodName(methodSignature);
        }

        public MethodInfo(@NotNull String methodSignature, @NotNull String paramFlags) {
            if (methodSignature == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/config/MethodParameterInjection$MethodInfo.<init> must not be null");
            }
            if (paramFlags == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/config/MethodParameterInjection$MethodInfo.<init> must not be null");
            }
            this.methodSignature = methodSignature;
            Pair<boolean[], Boolean> flags = MethodInfo.parseFlags(paramFlags);
            this.returnFlag = (Boolean)flags.second;
            this.paramFlags = (boolean[])flags.first;
            this.methodName = MethodInfo.calcMethodName(methodSignature);
        }

        @NotNull
        public String getMethodSignature() {
            String string = this.methodSignature;
            if (string == null) {
                throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/config/MethodParameterInjection$MethodInfo.getMethodSignature must not return null");
            }
            return string;
        }

        @NotNull
        public String getMethodName() {
            String string = this.methodName;
            if (string == null) {
                throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/config/MethodParameterInjection$MethodInfo.getMethodName must not return null");
            }
            return string;
        }

        @NotNull
        public boolean[] getParamFlags() {
            if (this.paramFlags == null) {
                throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/config/MethodParameterInjection$MethodInfo.getParamFlags must not return null");
            }
            return this.paramFlags;
        }

        public boolean isReturnFlag() {
            return this.returnFlag;
        }

        public void setReturnFlag(boolean returnFlag) {
            this.returnFlag = returnFlag;
        }

        public boolean isEnabled() {
            if (this.returnFlag) {
                return true;
            }
            for (boolean b : this.paramFlags) {
                if (!b) continue;
                return true;
            }
            return false;
        }

        private static Pair<boolean[], Boolean> parseFlags(String string) {
            int returnIdx = string.indexOf(58);
            boolean returnFlag = returnIdx != -1 && Boolean.parseBoolean(string.substring(0, returnIdx));
            StringTokenizer st = new StringTokenizer(string.substring(returnIdx + 1), ",");
            boolean[] result = new boolean[st.countTokens()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = Boolean.parseBoolean(st.nextToken());
            }
            return Pair.create((Object)result, (Object)returnFlag);
        }

        @NonNls
        private static String calcMethodName(String methodSignature) {
            String s = (String)StringUtil.split((String)methodSignature, (String)"(").get(0);
            return s.length() == 0 ? "<none>" : s;
        }

        public String getFlagsString() {
            StringBuilder result = new StringBuilder();
            result.append(this.returnFlag).append(':');
            boolean first = true;
            for (boolean b : this.paramFlags) {
                if (first) {
                    first = false;
                } else {
                    result.append(',');
                }
                result.append(b);
            }
            return result.toString();
        }

        public MethodInfo copy() {
            return new MethodInfo(this.methodSignature, (boolean[])this.paramFlags.clone(), this.returnFlag);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodInfo that = (MethodInfo)o;
            if (this.returnFlag != that.returnFlag) {
                return false;
            }
            if (!this.methodName.equals(that.methodName)) {
                return false;
            }
            if (!this.methodSignature.equals(that.methodSignature)) {
                return false;
            }
            return Arrays.equals(this.paramFlags, that.paramFlags);
        }

        public int hashCode() {
            int result = this.methodSignature.hashCode();
            result = 31 * result + this.methodName.hashCode();
            result = 31 * result + Arrays.hashCode(this.paramFlags);
            result = 31 * result + (this.returnFlag ? 1 : 0);
            return result;
        }
    }
}

