/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SmartEnterProcessor {
    public abstract boolean process(@NotNull Project var1, @NotNull Editor var2, @NotNull PsiFile var3);

    protected void reformat(PsiElement atCaret) throws IncorrectOperationException {
        TextRange range = atCaret.getTextRange();
        PsiFile file = atCaret.getContainingFile();
        PsiFile baseFile = file.getViewProvider().getPsi(file.getViewProvider().getBaseLanguage());
        CodeStyleManager.getInstance(atCaret.getProject()).reformatText(baseFile, range.getStartOffset(), range.getEndOffset());
    }

    protected RangeMarker createRangeMarker(PsiElement elt) {
        PsiFile psiFile = elt.getContainingFile();
        PsiDocumentManager instance = PsiDocumentManager.getInstance(elt.getProject());
        Document document = instance.getDocument(psiFile);
        return document.createRangeMarker(elt.getTextRange());
    }

    @Nullable
    protected PsiElement getStatementAtCaret(Editor editor, PsiFile psiFile) {
        CharSequence chars;
        int offset;
        int caret = editor.getCaretModel().getOffset();
        Document doc = editor.getDocument();
        if (doc.getLineNumber(offset = CharArrayUtil.shiftBackward((CharSequence)(chars = doc.getCharsSequence()), (int)(caret - 1), (String)" \t")) < doc.getLineNumber(caret)) {
            offset = CharArrayUtil.shiftForward((CharSequence)chars, (int)caret, (String)" \t");
        }
        return psiFile.findElementAt(offset);
    }

    protected static boolean isUncommited(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/editorActions/smartEnter/SmartEnterProcessor.isUncommited must not be null");
        }
        return PsiDocumentManager.getInstance(project).hasUncommitedDocuments();
    }

    protected void commit(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/editorActions/smartEnter/SmartEnterProcessor.commit must not be null");
        }
        Project project = editor.getProject();
        PsiDocumentManager.getInstance(project).commitDocument(editor.getDocument());
        PsiDocumentManager.getInstance(project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
    }
}

