/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;

public abstract class XmlSuppressionProvider {
    public static ExtensionPointName<XmlSuppressionProvider> EP_NAME = new ExtensionPointName("com.intellij.xml.xmlSuppressionProvider");

    public static boolean isSuppressed(PsiElement element, String inspectionId) {
        for (XmlSuppressionProvider provider : (XmlSuppressionProvider[])Extensions.getExtensions(EP_NAME)) {
            if (!provider.isSuppressedFor(element, inspectionId)) continue;
            return true;
        }
        return false;
    }

    public static XmlSuppressionProvider getProvider(PsiFile file) {
        for (XmlSuppressionProvider provider : (XmlSuppressionProvider[])Extensions.getExtensions(EP_NAME)) {
            if (!provider.isProviderAvailable(file)) continue;
            return provider;
        }
        throw new RuntimeException("No providers found for " + file);
    }

    public abstract boolean isProviderAvailable(PsiFile var1);

    public abstract boolean isSuppressedFor(PsiElement var1, String var2);

    public abstract void suppressForFile(PsiElement var1, String var2);

    public abstract void suppressForTag(PsiElement var1, String var2);
}

