/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant;

import com.intellij.compiler.ant.CompositeGenerator;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.io.PrintWriter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class Tag
extends CompositeGenerator {
    public static final Tag[] EMPTY_ARRAY = new Tag[0];
    private final String myTagName;
    private final Pair[] myTagOptions;

    public Tag(@NonNls String tagName, Pair ... tagOptions) {
        this.myTagName = tagName;
        this.myTagOptions = tagOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(PrintWriter out) throws IOException {
        out.print("<");
        out.print(this.myTagName);
        if (this.myTagOptions != null && this.myTagOptions.length > 0) {
            out.print(" ");
            int generated = 0;
            for (Pair option : this.myTagOptions) {
                if (option == null) continue;
                if (generated > 0) {
                    out.print(" ");
                }
                out.print((String)option.getFirst());
                out.print("=\"");
                out.print(StringUtil.escapeXml((String)((String)option.getSecond())));
                out.print("\"");
                ++generated;
            }
        }
        if (this.getGeneratorCount() > 0) {
            out.print(">");
            Tag.shiftIndent();
            try {
                super.generate(out);
            }
            finally {
                Tag.unshiftIndent();
            }
            Tag.crlf(out);
            out.print("</");
            out.print(this.myTagName);
            out.print(">");
        } else {
            out.print("/>");
        }
    }

    @Nullable
    protected static Pair<String, String> pair(@NonNls String v1, @Nullable @NonNls String v2) {
        if (v2 == null) {
            return null;
        }
        return new Pair((Object)v1, (Object)v2);
    }
}

