/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.ui.libraries;

import com.intellij.facet.ui.libraries.LibraryDownloadInfo;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class LibraryInfo {
    public static final LibraryInfo[] EMPTY_ARRAY = new LibraryInfo[0];
    @Nullable
    private final LibraryDownloadInfo myDownloadInfo;
    @NonNls
    private final String myPresentableName;
    @NonNls
    private final String[] myRequiredClasses;

    public LibraryInfo(@NonNls String presentableName, @Nullable @NonNls String version, @Nullable @NonNls String downloadingUrl, @Nullable String presentableUrl, String ... requiredClasses) {
        this.myPresentableName = presentableName;
        this.myRequiredClasses = requiredClasses;
        if (downloadingUrl != null) {
            int dot = presentableName.lastIndexOf(46);
            String prefix = presentableName.substring(0, dot);
            String suffix = presentableName.substring(dot);
            this.myDownloadInfo = new LibraryDownloadInfo(downloadingUrl, presentableUrl, prefix, suffix);
        } else {
            this.myDownloadInfo = null;
        }
    }

    public LibraryInfo(@NonNls String presentableName, @Nullable LibraryDownloadInfo downloadInfo, String ... requiredClasses) {
        this.myPresentableName = presentableName;
        this.myRequiredClasses = requiredClasses;
        this.myDownloadInfo = downloadInfo;
    }

    @NonNls
    public String getPresentableName() {
        return this.myPresentableName;
    }

    @NonNls
    public String[] getRequiredClasses() {
        return this.myRequiredClasses;
    }

    @Nullable
    public LibraryDownloadInfo getDownloadingInfo() {
        return this.myDownloadInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LibraryInfo that = (LibraryInfo)o;
        if (this.myDownloadInfo != null ? !this.myDownloadInfo.equals(that.myDownloadInfo) : that.myDownloadInfo != null) {
            return false;
        }
        if (!this.myPresentableName.equals(that.myPresentableName)) {
            return false;
        }
        return Arrays.equals(this.myRequiredClasses, that.myRequiredClasses);
    }

    public int hashCode() {
        int result = this.myDownloadInfo != null ? this.myDownloadInfo.hashCode() : 0;
        result = 31 * result + this.myPresentableName.hashCode();
        result = 31 * result + Arrays.hashCode(this.myRequiredClasses);
        return result;
    }
}

