/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import gnu.trove.THashMap;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;

public final class Presentation
implements Cloneable {
    private THashMap myUserMap;
    @NonNls
    public static final String PROP_TEXT = "text";
    @NonNls
    public static final String PROP_MNEMONIC_KEY = "mnemonicKey";
    @NonNls
    public static final String PROP_MNEMONIC_INDEX = "mnemonicIndex";
    @NonNls
    public static final String PROP_DESCRIPTION = "description";
    @NonNls
    public static final String PROP_ICON = "icon";
    @NonNls
    public static final String PROP_DISABLED_ICON = "disabledIcon";
    @NonNls
    public static final String PROP_HOVERED_ICON = "hoveredIcon";
    @NonNls
    public static final String PROP_VISIBLE = "visible";
    @NonNls
    public static final String PROP_ENABLED = "enabled";
    public static final double DEFAULT_WEIGHT = 0.0;
    public static final double HIGHER_WEIGHT = 42.0;
    public static final double EVEN_HIGHER_WEIGHT = 239.0;
    private PropertyChangeSupport myChangeSupport = new PropertyChangeSupport(this);
    private String myText;
    private String myDescription;
    private Icon myIcon;
    private Icon myDisabledIcon;
    private Icon myHoveredIcon;
    private int myMnemonic;
    private int myDisplayedMnemonicIndex = -1;
    private boolean myVisible = true;
    private boolean myEnabled = true;
    private double myWeight = 0.0;

    public Presentation() {
    }

    public Presentation(String text) {
        this();
        this.myText = text;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.myChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.myChangeSupport.removePropertyChangeListener(l);
    }

    public String getText() {
        return this.myText;
    }

    public void setText(String text, boolean mayContainMnemonic) {
        int oldMnemonic = this.myMnemonic;
        int oldDisplayedMnemonicIndex = this.myDisplayedMnemonicIndex;
        String oldText = this.myText;
        this.myMnemonic = 0;
        this.myDisplayedMnemonicIndex = -1;
        if (text != null) {
            if (text.indexOf(27) >= 0) {
                text = text.replace('\u001b', '&');
            }
            if (mayContainMnemonic) {
                StringBuffer plainText = new StringBuffer();
                for (int i = 0; i < text.length(); ++i) {
                    char ch = text.charAt(i);
                    if (this.myMnemonic == 0 && (ch == '_' || ch == '&')) {
                        if (++i >= text.length()) break;
                        ch = text.charAt(i);
                        if (ch != '_' && ch != '&') {
                            this.myMnemonic = Character.toUpperCase(ch);
                            this.myDisplayedMnemonicIndex = i - 1;
                        }
                    }
                    plainText.append(ch);
                }
                this.myText = plainText.toString();
            } else {
                this.myText = text;
            }
        } else {
            this.myText = null;
        }
        this.myChangeSupport.firePropertyChange(PROP_TEXT, oldText, this.myText);
        if (this.myMnemonic != oldMnemonic) {
            this.myChangeSupport.firePropertyChange(PROP_MNEMONIC_KEY, new Integer(oldMnemonic), new Integer(this.myMnemonic));
        }
        if (this.myDisplayedMnemonicIndex != oldDisplayedMnemonicIndex) {
            this.myChangeSupport.firePropertyChange(PROP_MNEMONIC_INDEX, new Integer(oldDisplayedMnemonicIndex), new Integer(this.myDisplayedMnemonicIndex));
        }
    }

    public void setText(String text) {
        this.setText(text, true);
    }

    public String getTextWithMnemonic() {
        if (this.myText != null && this.myDisplayedMnemonicIndex > -1) {
            return this.myText.substring(0, this.myDisplayedMnemonicIndex) + "_" + this.myText.substring(this.myDisplayedMnemonicIndex);
        }
        return this.myText;
    }

    public void restoreTextWithMnemonic(Presentation presentation) {
        this.setText(presentation.getTextWithMnemonic());
    }

    public static String restoreTextWithMnemonic(String text, int mnemonic) {
        if (text != null) {
            for (int i = 0; i < text.length(); ++i) {
                if (Character.toUpperCase(text.charAt(i)) != mnemonic) continue;
                return text.replaceFirst(String.valueOf(text.charAt(i)), "_" + text.charAt(i));
            }
        }
        return text;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(String description) {
        String oldDescription = this.myDescription;
        this.myDescription = description;
        this.myChangeSupport.firePropertyChange(PROP_DESCRIPTION, oldDescription, this.myDescription);
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public void setIcon(Icon icon) {
        Icon oldIcon = this.myIcon;
        this.myIcon = icon;
        this.myChangeSupport.firePropertyChange(PROP_ICON, oldIcon, this.myIcon);
    }

    public Icon getDisabledIcon() {
        return this.myDisabledIcon;
    }

    public void setDisabledIcon(Icon icon) {
        Icon oldDisabledIcon = this.myDisabledIcon;
        this.myDisabledIcon = icon;
        this.myChangeSupport.firePropertyChange(PROP_DISABLED_ICON, oldDisabledIcon, this.myDisabledIcon);
    }

    public Icon getHoveredIcon() {
        return this.myHoveredIcon;
    }

    public void setHoveredIcon(Icon hoveredIcon) {
        Icon old = this.myHoveredIcon;
        this.myHoveredIcon = hoveredIcon;
        this.myChangeSupport.firePropertyChange(PROP_DISABLED_ICON, old, this.myHoveredIcon);
    }

    public int getMnemonic() {
        return this.myMnemonic;
    }

    public int getDisplayedMnemonicIndex() {
        return this.myDisplayedMnemonicIndex;
    }

    public boolean isVisible() {
        return this.myVisible;
    }

    public void setVisible(boolean visible) {
        boolean oldVisible = this.myVisible;
        this.myVisible = visible;
        this.firePropertyChange(PROP_VISIBLE, oldVisible ? Boolean.TRUE : Boolean.FALSE, this.myVisible ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public void setEnabled(boolean enabled) {
        boolean oldEnabled = this.myEnabled;
        this.myEnabled = enabled;
        this.firePropertyChange(PROP_ENABLED, oldEnabled ? Boolean.TRUE : Boolean.FALSE, this.myEnabled ? Boolean.TRUE : Boolean.FALSE);
    }

    void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.myChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Object clone() {
        try {
            Presentation presentation = (Presentation)super.clone();
            presentation.myChangeSupport = new PropertyChangeSupport(presentation);
            return presentation;
        }
        catch (CloneNotSupportedException exc) {
            throw new RuntimeException(exc.getMessage());
        }
    }

    public void copyFrom(Presentation presentation) {
        this.setText(presentation.getTextWithMnemonic());
        this.setDescription(presentation.getDescription());
        this.setIcon(presentation.getIcon());
        this.setDisabledIcon(presentation.getDisabledIcon());
        this.setVisible(presentation.isVisible());
        this.setEnabled(presentation.isEnabled());
    }

    public Object getClientProperty(@NonNls String key) {
        if (this.myUserMap == null) {
            return null;
        }
        return this.myUserMap.get((Object)key);
    }

    public void putClientProperty(@NonNls String key, Object value) {
        if (this.myUserMap == null) {
            this.myUserMap = new THashMap(1);
        }
        Object oldValue = this.myUserMap.put((Object)key, value);
        this.myChangeSupport.firePropertyChange(key, oldValue, value);
    }

    public double getWeight() {
        return this.myWeight;
    }

    public void setWeight(double weight) {
        this.myWeight = weight;
    }
}

