/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchHunk;
import com.intellij.openapi.diff.impl.patch.PatchLine;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.util.text.LineTokenizer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class PatchReader {
    @NonNls
    public static final String NO_NEWLINE_SIGNATURE = "\\ No newline at end of file";
    private final String[] myLines;
    private int myLineIndex = 0;
    private DiffFormat myDiffFormat = null;
    @NonNls
    private static final String CONTEXT_HUNK_PREFIX = "***************";
    @NonNls
    private static final String CONTEXT_FILE_PREFIX = "*** ";
    @NonNls
    private static final Pattern ourUnifiedHunkStartPattern = Pattern.compile("@@ -(\\d+)(,(\\d+))? \\+(\\d+)(,(\\d+))? @@.*");
    @NonNls
    private static final Pattern ourContextBeforeHunkStartPattern = Pattern.compile("\\*\\*\\* (\\d+),(\\d+) \\*\\*\\*\\*");
    @NonNls
    private static final Pattern ourContextAfterHunkStartPattern = Pattern.compile("--- (\\d+),(\\d+) ----");

    public PatchReader(CharSequence patchContent) {
        this.myLines = LineTokenizer.tokenize((CharSequence)patchContent, (boolean)false);
    }

    public List<TextFilePatch> readAllPatches() throws PatchSyntaxException {
        TextFilePatch patch;
        ArrayList<TextFilePatch> result = new ArrayList<TextFilePatch>();
        while ((patch = this.readNextPatch()) != null) {
            result.add(patch);
        }
        return result;
    }

    @Nullable
    public TextFilePatch readNextPatch() throws PatchSyntaxException {
        while (this.myLineIndex < this.myLines.length) {
            String curLine = this.myLines[this.myLineIndex];
            if (curLine.startsWith("--- ") && (this.myDiffFormat == null || this.myDiffFormat == DiffFormat.UNIFIED)) {
                this.myDiffFormat = DiffFormat.UNIFIED;
                return this.readPatch(curLine);
            }
            if (curLine.startsWith(CONTEXT_FILE_PREFIX) && (this.myDiffFormat == null || this.myDiffFormat == DiffFormat.CONTEXT)) {
                this.myDiffFormat = DiffFormat.CONTEXT;
                return this.readPatch(curLine);
            }
            ++this.myLineIndex;
        }
        return null;
    }

    private TextFilePatch readPatch(String curLine) throws PatchSyntaxException {
        PatchHunk hunk;
        String secondNamePrefix;
        TextFilePatch curPatch = new TextFilePatch();
        PatchReader.extractFileName(curLine, curPatch, true);
        ++this.myLineIndex;
        curLine = this.myLines[this.myLineIndex];
        String string = secondNamePrefix = this.myDiffFormat == DiffFormat.UNIFIED ? "+++ " : "--- ";
        if (!curLine.startsWith(secondNamePrefix)) {
            throw new PatchSyntaxException(this.myLineIndex, "Second file name expected");
        }
        PatchReader.extractFileName(curLine, curPatch, false);
        ++this.myLineIndex;
        while (this.myLineIndex < this.myLines.length && (hunk = this.myDiffFormat == DiffFormat.UNIFIED ? this.readNextHunkUnified() : this.readNextHunkContext()) != null) {
            curPatch.addHunk(hunk);
        }
        return curPatch;
    }

    @Nullable
    private PatchHunk readNextHunkUnified() throws PatchSyntaxException {
        while (this.myLineIndex < this.myLines.length) {
            String curLine = this.myLines[this.myLineIndex];
            if (curLine.startsWith("--- ") && this.myLineIndex < this.myLines.length - 1 && this.myLines[this.myLineIndex + 1].startsWith("+++ ")) {
                return null;
            }
            if (curLine.startsWith("@@ ")) break;
            ++this.myLineIndex;
        }
        if (this.myLineIndex == this.myLines.length) {
            return null;
        }
        Matcher m = ourUnifiedHunkStartPattern.matcher(this.myLines[this.myLineIndex]);
        if (!m.matches()) {
            throw new PatchSyntaxException(this.myLineIndex, "Unknown hunk start syntax");
        }
        int startLineBefore = Integer.parseInt(m.group(1));
        String linesBeforeText = m.group(3);
        int linesBefore = linesBeforeText == null ? 1 : Integer.parseInt(linesBeforeText);
        int startLineAfter = Integer.parseInt(m.group(4));
        String linesAfterText = m.group(6);
        int linesAfter = linesAfterText == null ? 1 : Integer.parseInt(linesAfterText);
        PatchHunk hunk = new PatchHunk(startLineBefore - 1, startLineBefore + linesBefore - 1, startLineAfter - 1, startLineAfter + linesAfter - 1);
        ++this.myLineIndex;
        PatchLine lastLine = null;
        while (this.myLineIndex < this.myLines.length) {
            String curLine = this.myLines[this.myLineIndex];
            if (lastLine != null && curLine.startsWith(NO_NEWLINE_SIGNATURE)) {
                lastLine.setSuppressNewLine(true);
                ++this.myLineIndex;
                continue;
            }
            if (curLine.startsWith("--- ") || (lastLine = PatchReader.parsePatchLine(curLine, 1)) == null) break;
            hunk.addLine(lastLine);
            ++this.myLineIndex;
        }
        return hunk;
    }

    @Nullable
    private static PatchLine parsePatchLine(String line, int prefixLength) {
        PatchLine.Type type;
        if (line.startsWith("+")) {
            type = PatchLine.Type.ADD;
        } else if (line.startsWith("-")) {
            type = PatchLine.Type.REMOVE;
        } else if (line.startsWith(" ")) {
            type = PatchLine.Type.CONTEXT;
        } else {
            return null;
        }
        String lineText = line.length() < prefixLength ? "" : line.substring(prefixLength);
        return new PatchLine(type, lineText);
    }

    @Nullable
    private PatchHunk readNextHunkContext() throws PatchSyntaxException {
        while (this.myLineIndex < this.myLines.length) {
            String curLine = this.myLines[this.myLineIndex];
            if (curLine.startsWith(CONTEXT_FILE_PREFIX)) {
                return null;
            }
            if (curLine.startsWith(CONTEXT_HUNK_PREFIX)) break;
            ++this.myLineIndex;
        }
        if (this.myLineIndex == this.myLines.length) {
            return null;
        }
        ++this.myLineIndex;
        Matcher beforeMatcher = ourContextBeforeHunkStartPattern.matcher(this.myLines[this.myLineIndex]);
        if (!beforeMatcher.matches()) {
            throw new PatchSyntaxException(this.myLineIndex, "Unknown before hunk start syntax");
        }
        ++this.myLineIndex;
        List<String> beforeLines = this.readContextDiffLines();
        if (this.myLineIndex == this.myLines.length) {
            throw new PatchSyntaxException(this.myLineIndex, "Missing after hunk");
        }
        Matcher afterMatcher = ourContextAfterHunkStartPattern.matcher(this.myLines[this.myLineIndex]);
        if (!afterMatcher.matches()) {
            throw new PatchSyntaxException(this.myLineIndex, "Unknown after hunk start syntax");
        }
        ++this.myLineIndex;
        List<String> afterLines = this.readContextDiffLines();
        int startLineBefore = Integer.parseInt(beforeMatcher.group(1));
        int endLineBefore = Integer.parseInt(beforeMatcher.group(2));
        int startLineAfter = Integer.parseInt(afterMatcher.group(1));
        int endLineAfter = Integer.parseInt(afterMatcher.group(2));
        PatchHunk hunk = new PatchHunk(startLineBefore - 1, endLineBefore - 1, startLineAfter - 1, endLineAfter - 1);
        int beforeLineIndex = 0;
        int afterLineIndex = 0;
        PatchLine lastBeforePatchLine = null;
        PatchLine lastAfterPatchLine = null;
        if (beforeLines.size() == 0) {
            for (String line : afterLines) {
                hunk.addLine(PatchReader.parsePatchLine(line, 2));
            }
        } else if (afterLines.size() == 0) {
            for (String line : beforeLines) {
                hunk.addLine(PatchReader.parsePatchLine(line, 2));
            }
        } else {
            while (beforeLineIndex < beforeLines.size() || afterLineIndex < afterLines.size()) {
                String afterLine;
                String beforeLine = beforeLineIndex >= beforeLines.size() ? null : beforeLines.get(beforeLineIndex);
                String string = afterLine = afterLineIndex >= afterLines.size() ? null : afterLines.get(afterLineIndex);
                if (PatchReader.startsWith(beforeLine, NO_NEWLINE_SIGNATURE) && lastBeforePatchLine != null) {
                    lastBeforePatchLine.setSuppressNewLine(true);
                    ++beforeLineIndex;
                    continue;
                }
                if (PatchReader.startsWith(afterLine, NO_NEWLINE_SIGNATURE) && lastAfterPatchLine != null) {
                    lastAfterPatchLine.setSuppressNewLine(true);
                    ++afterLineIndex;
                    continue;
                }
                if (PatchReader.startsWith(beforeLine, " ") && (PatchReader.startsWith(afterLine, " ") || afterLine == null)) {
                    PatchReader.addContextDiffLine(hunk, beforeLine, PatchLine.Type.CONTEXT);
                    ++beforeLineIndex;
                    ++afterLineIndex;
                    continue;
                }
                if (PatchReader.startsWith(beforeLine, "-")) {
                    lastBeforePatchLine = PatchReader.addContextDiffLine(hunk, beforeLine, PatchLine.Type.REMOVE);
                    ++beforeLineIndex;
                    continue;
                }
                if (PatchReader.startsWith(afterLine, "+")) {
                    lastAfterPatchLine = PatchReader.addContextDiffLine(hunk, afterLine, PatchLine.Type.ADD);
                    ++afterLineIndex;
                    continue;
                }
                if (PatchReader.startsWith(beforeLine, "!") && PatchReader.startsWith(afterLine, "!")) {
                    while (beforeLineIndex < beforeLines.size() && beforeLines.get(beforeLineIndex).startsWith("! ")) {
                        lastBeforePatchLine = PatchReader.addContextDiffLine(hunk, beforeLines.get(beforeLineIndex), PatchLine.Type.REMOVE);
                        ++beforeLineIndex;
                    }
                    while (afterLineIndex < afterLines.size() && afterLines.get(afterLineIndex).startsWith("! ")) {
                        lastAfterPatchLine = PatchReader.addContextDiffLine(hunk, afterLines.get(afterLineIndex), PatchLine.Type.ADD);
                        ++afterLineIndex;
                    }
                    continue;
                }
                throw new PatchSyntaxException(-1, "Unknown line prefix");
            }
        }
        return hunk;
    }

    private static boolean startsWith(@Nullable String line, String prefix) {
        return line != null && line.startsWith(prefix);
    }

    private static PatchLine addContextDiffLine(PatchHunk hunk, String line, PatchLine.Type type) {
        PatchLine patchLine = new PatchLine(type, line.length() < 2 ? "" : line.substring(2));
        hunk.addLine(patchLine);
        return patchLine;
    }

    private List<String> readContextDiffLines() {
        String line;
        ArrayList<String> result = new ArrayList<String>();
        while (this.myLineIndex < this.myLines.length && ((line = this.myLines[this.myLineIndex]).startsWith(" ") || line.startsWith("+ ") || line.startsWith("- ") || line.startsWith("! ") || line.startsWith(NO_NEWLINE_SIGNATURE))) {
            result.add(line);
            ++this.myLineIndex;
        }
        return result;
    }

    private static void extractFileName(String curLine, FilePatch patch, boolean before) {
        String fileName = curLine.substring(4);
        int pos = fileName.indexOf(9);
        if (pos < 0) {
            pos = fileName.indexOf(32);
        }
        if (pos >= 0) {
            String versionId = fileName.substring(pos).trim();
            fileName = fileName.substring(0, pos);
            if (versionId.length() > 0) {
                if (before) {
                    patch.setBeforeVersionId(versionId);
                } else {
                    patch.setAfterVersionId(versionId);
                }
            }
        }
        if (before) {
            patch.setBeforeName(fileName);
        } else {
            patch.setAfterName(fileName);
        }
    }

    private static enum DiffFormat {
        CONTEXT,
        UNIFIED;

    }
}

