/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.Nullable;

public class ProjectLocatorImpl
extends ProjectLocator {
    @Override
    @Nullable
    public Project guessProjectForFile(VirtualFile file) {
        ProjectManager projectManager = ProjectManager.getInstance();
        if (projectManager == null) {
            return null;
        }
        Project[] projects = projectManager.getOpenProjects();
        if (projects.length == 0) {
            return null;
        }
        if (projects.length == 1 && !projects[0].isDisposed()) {
            return projects[0];
        }
        for (Project project : projects) {
            if (!project.isInitialized() || project.isDisposed() || !ProjectRootManager.getInstance(project).getFileIndex().isInContent(file)) continue;
            return project;
        }
        return !projects[0].isDisposed() ? projects[0] : null;
    }
}

