/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public abstract class SdkType {
    public static ExtensionPointName<SdkType> EP_NAME = ExtensionPointName.create((String)"com.intellij.sdkType");
    private final String myName;
    @NonNls
    public static final String MAC_HOME_PATH = "/Home";

    @Nullable
    public abstract String suggestHomePath();

    public abstract boolean isValidSdkHome(String var1);

    @Nullable
    public String getVersionString(Sdk sdk) {
        return this.getVersionString(sdk.getHomePath());
    }

    @Nullable
    public String getVersionString(String sdkHome) {
        return null;
    }

    public abstract String suggestSdkName(String var1, String var2);

    public void setupSdkPaths(Sdk sdk) {
    }

    public boolean setupSdkPaths(Sdk sdk, SdkModel sdkModel) {
        this.setupSdkPaths(sdk);
        return true;
    }

    public abstract AdditionalDataConfigurable createAdditionalDataConfigurable(SdkModel var1, SdkModificator var2);

    public abstract void saveAdditionalData(SdkAdditionalData var1, Element var2);

    @Nullable
    public SdkAdditionalData loadAdditionalData(Element additional) {
        return null;
    }

    @Nullable
    public SdkAdditionalData loadAdditionalData(Sdk currentSdk, Element additional) {
        return this.loadAdditionalData(additional);
    }

    public SdkType(@NonNls String name) {
        this.myName = name;
    }

    public String getName() {
        return this.myName;
    }

    public abstract String getPresentableName();

    public Icon getIcon() {
        return null;
    }

    public Icon getIconForExpandedTreeNode() {
        return this.getIcon();
    }

    public Icon getIconForAddAction() {
        return IconLoader.getIcon((String)"/general/add.png");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SdkType)) {
            return false;
        }
        SdkType sdkType = (SdkType)o;
        return this.myName.equals(sdkType.myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    public String toString() {
        return this.getName();
    }

    public FileChooserDescriptor getHomeChooserDescriptor() {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false){

            @Override
            public void validateSelectedFiles(VirtualFile[] files) throws Exception {
                boolean valid;
                if (files.length != 0 && !(valid = SdkType.this.isValidSdkHome(files[0].getPath()))) {
                    if (SystemInfo.isMac) {
                        valid = SdkType.this.isValidSdkHome(files[0].getPath() + SdkType.MAC_HOME_PATH);
                    }
                    if (!valid) {
                        String message = files[0].isDirectory() ? ProjectBundle.message("sdk.configure.home.invalid.error", SdkType.this.getPresentableName()) : ProjectBundle.message("sdk.configure.home.file.invalid.error", SdkType.this.getPresentableName());
                        throw new Exception(message);
                    }
                }
            }
        };
        descriptor.setTitle(ProjectBundle.message("sdk.configure.home.title", this.getPresentableName()));
        return descriptor;
    }

    public String getHomeFieldLabel() {
        return ProjectBundle.message("sdk.configure.type.home.path", this.getPresentableName());
    }

    public static SdkType[] getAllTypes() {
        ArrayList allTypes = new ArrayList();
        Collections.addAll(allTypes, ApplicationManager.getApplication().getComponents(SdkType.class));
        Collections.addAll(allTypes, Extensions.getExtensions(EP_NAME));
        return allTypes.toArray(new SdkType[allTypes.size()]);
    }

    public static <T extends SdkType> T findInstance(Class<T> sdkTypeClass) {
        for (SdkType sdkType : (SdkType[])Extensions.getExtensions(EP_NAME)) {
            if (!sdkTypeClass.equals(sdkType.getClass())) continue;
            return (T)sdkType;
        }
        assert (false);
        return null;
    }

    public boolean isRootTypeApplicable(OrderRootType type) {
        return true;
    }
}

