/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ProjectRootsTraversing {
    public static final RootTraversePolicy LIBRARIES_AND_JDK = new RootTraversePolicy(null, RootTraversePolicy.ADD_CLASSES, RootTraversePolicy.ADD_CLASSES, null);
    public static final RootTraversePolicy PROJECT_SOURCES = new RootTraversePolicy(RootTraversePolicy.SOURCES, null, null, null);
    public static final RootTraversePolicy PROJECT_LIBRARIES = new RootTraversePolicy(null, null, RootTraversePolicy.ADD_CLASSES, RootTraversePolicy.RECURSIVE);

    private ProjectRootsTraversing() {
    }

    public static PathsList collectRoots(Project project, RootTraversePolicy policy) {
        PathsList listBuilder = new PathsList();
        ProjectRootsTraversing.collectRoots(project, policy, listBuilder);
        return listBuilder;
    }

    public static void collectRoots(Project project, RootTraversePolicy policy, PathsList listBuilder) {
        ProjectRootsTraversing.traverseOrder(project, (RootPolicy<TraverseState>)policy, new TraverseState(listBuilder));
    }

    public static PathsList collectRoots(Module module, RootTraversePolicy policy) {
        PathsList listBuilder = new PathsList();
        ProjectRootsTraversing.collectRoots(module, policy, listBuilder);
        return listBuilder;
    }

    public static void collectRoots(Module module, RootTraversePolicy policy, PathsList listBuilder) {
        ProjectRootsTraversing.traverseOrder(module, (RootPolicy<TraverseState>)policy, new TraverseState(listBuilder));
    }

    private static void traverseOrder(Project project, RootPolicy<TraverseState> policy, TraverseState state) {
        Module[] sortedModules;
        for (Module sortedModule : sortedModules = ModuleManager.getInstance(project).getSortedModules()) {
            ProjectRootsTraversing.traverseOrder(sortedModule, policy, state);
        }
    }

    private static void traverseOrder(Module module, RootPolicy<TraverseState> policy, TraverseState state) {
        if (!state.beforeVisitModule(module)) {
            return;
        }
        state.getCurrentModuleManager().processOrder(policy, state);
    }

    public static class RootTraversePolicy
    extends RootPolicy<TraverseState> {
        private static final Key<Boolean> JDK_PROCESSED = Key.create((String)"jdkProcessed");
        private final Visit<ModuleSourceOrderEntry> myVisitSource;
        private final Visit<OrderEntry> myVisitJdk;
        private final Visit<OrderEntry> myVisitLibrary;
        private final Visit<ModuleOrderEntry> myVisitModule;
        public static final AddModuleSource SOURCES = new AddModuleSource();
        public static final AddModuleSource PRODUCTION_SOURCES = new AddModuleSource(true);
        public static final Visit<OrderEntry> ADD_CLASSES = new Visit<OrderEntry>(){

            @Override
            public void visit(OrderEntry orderEntry, TraverseState state, RootPolicy<TraverseState> policy) {
                state.addAllUrls(orderEntry.getUrls(OrderRootType.CLASSES));
            }
        };
        public static final Visit<OrderEntry> ADD_CLASSES_WITHOUT_TESTS = new Visit<OrderEntry>(){

            @Override
            public void visit(OrderEntry orderEntry, TraverseState state, RootPolicy<TraverseState> policy) {
                if (orderEntry instanceof ExportableOrderEntry && ((ExportableOrderEntry)orderEntry).getScope() == DependencyScope.TEST) {
                    return;
                }
                state.addAllUrls(orderEntry.getUrls(OrderRootType.CLASSES));
            }
        };
        public static final Visit<ModuleOrderEntry> RECURSIVE = new RecursiveModules(true);
        public static final Visit<ModuleOrderEntry> RECURSIVE_WITHOUT_TESTS = new RecursiveModules(false);

        public RootTraversePolicy(Visit<ModuleSourceOrderEntry> visitSource, Visit<OrderEntry> visitJdk, Visit<OrderEntry> visitLibrary, Visit<ModuleOrderEntry> visitModule) {
            this.myVisitSource = visitSource;
            this.myVisitJdk = visitJdk;
            this.myVisitLibrary = visitLibrary;
            this.myVisitModule = visitModule;
        }

        @Override
        public TraverseState visitJdkOrderEntry(JdkOrderEntry jdkOrderEntry, TraverseState state) {
            Boolean jdkProcessed = state.getUserData(JDK_PROCESSED);
            if (jdkProcessed != null && jdkProcessed.booleanValue()) {
                return state;
            }
            state.putUserData(JDK_PROCESSED, Boolean.TRUE);
            if (this.myVisitJdk != null) {
                this.myVisitJdk.visit(jdkOrderEntry, state, this);
            }
            return state;
        }

        @Override
        public TraverseState visitLibraryOrderEntry(LibraryOrderEntry libraryOrderEntry, TraverseState traverseState) {
            if (this.myVisitLibrary != null) {
                this.myVisitLibrary.visit(libraryOrderEntry, traverseState, this);
            }
            return traverseState;
        }

        @Override
        public TraverseState visitModuleSourceOrderEntry(ModuleSourceOrderEntry sourceEntry, TraverseState traverseState) {
            if (this.myVisitSource != null) {
                this.myVisitSource.visit(sourceEntry, traverseState, this);
            }
            return traverseState;
        }

        @Override
        public TraverseState visitModuleOrderEntry(ModuleOrderEntry moduleOrderEntry, TraverseState traverseState) {
            if (this.myVisitModule != null) {
                this.myVisitModule.visit(moduleOrderEntry, traverseState, this);
            }
            return traverseState;
        }

        public Visit<ModuleSourceOrderEntry> getVisitSource() {
            return this.myVisitSource;
        }

        public Visit<OrderEntry> getVisitJdk() {
            return this.myVisitJdk;
        }

        public Visit<OrderEntry> getVisitLibrary() {
            return this.myVisitLibrary;
        }

        public Visit<ModuleOrderEntry> getVisitModule() {
            return this.myVisitModule;
        }

        public static class RecursiveModules
        implements Visit<ModuleOrderEntry> {
            private boolean myIncludeTests;

            public RecursiveModules(boolean includeTests) {
                this.myIncludeTests = includeTests;
            }

            @Override
            public void visit(ModuleOrderEntry moduleOrderEntry, TraverseState state, RootPolicy<TraverseState> policy) {
                if (!this.myIncludeTests && moduleOrderEntry.getScope() == DependencyScope.TEST) {
                    return;
                }
                Module module = moduleOrderEntry.getModule();
                if (module == null) {
                    return;
                }
                ModuleRootManager moduleRootManager = state.getCurrentModuleManager();
                ProjectRootsTraversing.traverseOrder(module, (RootPolicy<TraverseState>)policy, state);
                state.restoreCurrentModuleManager(moduleRootManager);
            }
        }

        public static class AddModuleSource
        implements Visit<ModuleSourceOrderEntry> {
            private boolean myExcludeTests;

            public AddModuleSource() {
                this(false);
            }

            public AddModuleSource(boolean excludeTests) {
                this.myExcludeTests = excludeTests;
            }

            @Override
            public void visit(ModuleSourceOrderEntry orderEntry, TraverseState state, RootPolicy<TraverseState> policy) {
                if (this.myExcludeTests) {
                    ContentEntry[] contentEntries;
                    for (ContentEntry contentEntry : contentEntries = ModuleRootManager.getInstance(orderEntry.getOwnerModule()).getContentEntries()) {
                        for (SourceFolder folder : contentEntry.getSourceFolders()) {
                            VirtualFile root = folder.getFile();
                            if (root == null || folder.isTestSource()) continue;
                            state.add(root);
                        }
                    }
                } else {
                    state.addAll(orderEntry.getFiles(OrderRootType.SOURCES));
                }
            }
        }

        public static interface Visit<T extends OrderEntry> {
            public void visit(T var1, TraverseState var2, RootPolicy<TraverseState> var3);
        }
    }

    public static class TraverseState
    implements UserDataHolder {
        private final UserDataHolderBase myUserData = new UserDataHolderBase();
        private final PathsList myCollectedPath;
        private final HashSet<Module> myKnownModules = new HashSet();
        private ModuleRootManager myCurrentModuleManager;

        private TraverseState(PathsList listBuilder) {
            this.myCollectedPath = listBuilder;
        }

        public PathsList getCollectedPath() {
            return this.myCollectedPath;
        }

        public boolean beforeVisitModule(Module module) {
            if (this.myKnownModules.contains(module)) {
                return false;
            }
            this.myKnownModules.add(module);
            this.myCurrentModuleManager = ModuleRootManager.getInstance(module);
            return true;
        }

        public void addAll(VirtualFile ... items) {
            for (VirtualFile item : items) {
                this.add(item);
            }
        }

        private void add(VirtualFile item) {
            if (item != null && item.isValid()) {
                this.myCollectedPath.add(item);
            }
        }

        private void addUrl(String url) {
            if (url != null) {
                this.myCollectedPath.add(PathUtil.toPresentableUrl(url));
            }
        }

        public ModuleRootManager getCurrentModuleManager() {
            return this.myCurrentModuleManager;
        }

        public void restoreCurrentModuleManager(ModuleRootManager restored) {
            this.myCurrentModuleManager = restored;
        }

        public <T> T getUserData(@NotNull Key<T> key) {
            if (key == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ProjectRootsTraversing$TraverseState.getUserData must not be null");
            }
            return (T)this.myUserData.getUserData(key);
        }

        public <T> void putUserData(@NotNull Key<T> key, T value) {
            if (key == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ProjectRootsTraversing$TraverseState.putUserData must not be null");
            }
            this.myUserData.putUserData(key, value);
        }

        public void addAllUrls(String[] urls) {
            for (String url : urls) {
                this.addUrl(url);
            }
        }

        public void addAllUrls(List<String> urls) {
            for (String url : urls) {
                this.addUrl(url);
            }
        }
    }
}

