/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTablePresentation;
import java.util.EventListener;
import java.util.Iterator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface LibraryTable {
    @NotNull
    public Library[] getLibraries();

    public Library createLibrary();

    public Library createLibrary(@NonNls String var1);

    public void removeLibrary(@NotNull Library var1);

    @NotNull
    public Iterator<Library> getLibraryIterator();

    @Nullable
    public Library getLibraryByName(@NotNull String var1);

    public String getTableLevel();

    public LibraryTablePresentation getPresentation();

    public boolean isEditable();

    public ModifiableModel getModifiableModel();

    public void addListener(Listener var1);

    public void addListener(Listener var1, Disposable var2);

    public void removeListener(Listener var1);

    public static interface Listener
    extends EventListener {
        public void afterLibraryAdded(Library var1);

        public void afterLibraryRenamed(Library var1);

        public void beforeLibraryRemoved(Library var1);

        public void afterLibraryRemoved(Library var1);
    }

    public static interface ModifiableModel {
        public Library createLibrary(String var1);

        public void removeLibrary(@NotNull Library var1);

        public void commit();

        @NotNull
        public Iterator<Library> getLibraryIterator();

        @Nullable
        public Library getLibraryByName(@NotNull String var1);

        @NotNull
        public Library[] getLibraries();

        public boolean isChanged();
    }
}

