/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LabeledComponent<Comp extends JComponent>
extends JPanel {
    private final JLabel myLabel = new JLabel();
    private Comp myComponent;
    private String myLabelConstraints = "North";
    private static final String[] LABEL_BORDER_CONSTRAINS = new String[]{"North", "East", "South", "West"};

    public LabeledComponent() {
        super(new BorderLayout());
        this.insertLabel();
        this.updateLabelBorder();
        this.updateUI();
    }

    @NotNull
    public static <Comp extends JComponent> LabeledComponent<Comp> create(@NotNull Comp component, @NotNull String text) {
        if (component == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/ui/LabeledComponent.create must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/ui/LabeledComponent.create must not be null");
        }
        LabeledComponent<Comp> labeledComponent = new LabeledComponent<Comp>();
        labeledComponent.setComponent(component);
        labeledComponent.setText(text);
        LabeledComponent<Comp> labeledComponent2 = labeledComponent;
        if (labeledComponent2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/ui/LabeledComponent.create must not return null");
        }
        return labeledComponent2;
    }

    private void updateLabelBorder() {
        int left = 0;
        int bottom = 0;
        if ("North".equals(this.myLabelConstraints)) {
            bottom = 2;
        }
        this.myLabel.setBorder(BorderFactory.createEmptyBorder(0, left, bottom, 0));
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.myLabel != null) {
            this.updateLabelBorder();
        }
    }

    private void insertLabel() {
        this.remove(this.myLabel);
        this.add((Component)this.myLabel, this.myLabelConstraints);
    }

    public void setText(String textWithMnemonic) {
        if (!StringUtil.endsWithChar((CharSequence)textWithMnemonic, (char)':')) {
            textWithMnemonic = textWithMnemonic + ":";
        }
        TextWithMnemonic withMnemonic = TextWithMnemonic.fromTextWithMnemonic(textWithMnemonic);
        withMnemonic.setToLabel(this.myLabel);
    }

    public String getText() {
        String text = TextWithMnemonic.fromLabel(this.myLabel).getTextWithMnemonic();
        if (StringUtil.endsWithChar((CharSequence)text, (char)':')) {
            return text.substring(0, text.length() - 1);
        }
        return text;
    }

    public void setComponentClass(@NonNls String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (className != null) {
            Class<?> aClass = this.getClass().getClassLoader().loadClass(className);
            JComponent component = (JComponent)aClass.newInstance();
            this.setComponent(component);
        } else {
            this.setComponent(null);
        }
    }

    public void setComponent(Comp component) {
        if (this.myComponent != null) {
            this.remove((Component)this.myComponent);
        }
        this.myComponent = component;
        if (this.myComponent != null) {
            this.add((Component)this.myComponent, "Center");
        }
        if (this.myComponent instanceof ComponentWithBrowseButton && !(this.myComponent instanceof TextFieldWithBrowseButton)) {
            this.myLabel.setLabelFor((Component)((ComponentWithBrowseButton)this.myComponent).getChildComponent());
        } else {
            this.myLabel.setLabelFor((Component)this.myComponent);
        }
    }

    public String getComponentClass() {
        if (this.myComponent == null) {
            return null;
        }
        return this.getComponent().getClass().getName();
    }

    public Comp getComponent() {
        return this.myComponent;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.myComponent != null) {
            ((JComponent)this.myComponent).setEnabled(enabled);
        }
        this.myLabel.setEnabled(enabled);
    }

    public void setLabelLocation(@NonNls String borderConstrains) {
        String constrains = LabeledComponent.findBorderConstrains(borderConstrains);
        if (constrains == null || constrains == this.myLabelConstraints) {
            return;
        }
        this.myLabelConstraints = borderConstrains;
        this.insertLabel();
    }

    public String getLabelLocation() {
        return this.myLabelConstraints;
    }

    public Insets getLabelInsets() {
        return this.myLabel.getInsets();
    }

    public void setLabelInsets(Insets insets) {
        if (Comparing.equal((Object)insets, (Object)this.getLabelInsets())) {
            return;
        }
        this.myLabel.setBorder(IdeBorderFactory.createEmptyBorder(insets));
    }

    private static String findBorderConstrains(String str) {
        for (String constrain : LABEL_BORDER_CONSTRAINS) {
            if (!constrain.equals(str)) continue;
            return constrain;
        }
        return null;
    }

    public String getRawText() {
        return this.myLabel.getText().replace("\u001b", "");
    }

    public JLabel getLabel() {
        return this.myLabel;
    }

    public static class TextWithMnemonic {
        private final String myText;
        private final int myMnemoniIndex;

        public TextWithMnemonic(String text, int mnemoniIndex) {
            this.myText = text;
            this.myMnemoniIndex = mnemoniIndex;
        }

        public void setToLabel(JLabel label) {
            label.setText(this.myText);
            if (this.myMnemoniIndex != -1) {
                label.setDisplayedMnemonic(this.myText.charAt(this.myMnemoniIndex));
            } else {
                label.setDisplayedMnemonic(0);
            }
            label.setDisplayedMnemonicIndex(this.myMnemoniIndex);
        }

        public String getTextWithMnemonic() {
            if (this.myMnemoniIndex == -1) {
                return this.myText;
            }
            return this.myText.substring(0, this.myMnemoniIndex) + "&" + this.myText.substring(this.myMnemoniIndex);
        }

        public static TextWithMnemonic fromTextWithMnemonic(String textWithMnemonic) {
            int mnemonicIndex = textWithMnemonic.indexOf(38);
            if (mnemonicIndex == -1) {
                return new TextWithMnemonic(textWithMnemonic, -1);
            }
            textWithMnemonic = textWithMnemonic.substring(0, mnemonicIndex) + textWithMnemonic.substring(mnemonicIndex + 1);
            return new TextWithMnemonic(textWithMnemonic, mnemonicIndex);
        }

        public static TextWithMnemonic fromLabel(JLabel label) {
            return new TextWithMnemonic(label.getText(), label.getDisplayedMnemonicIndex());
        }
    }
}

