/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.Stack;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class ClassInheritorsSearch
extends ExtensibleQueryFactory<PsiClass, SearchParameters> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.search.searches.ClassInheritorsSearch");
    public static final ClassInheritorsSearch INSTANCE = new ClassInheritorsSearch();

    private ClassInheritorsSearch() {
    }

    public static Query<PsiClass> search(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean checkDeep, boolean checkInheritance, boolean includeAnonymous) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/searches/ClassInheritorsSearch.search must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/search/searches/ClassInheritorsSearch.search must not be null");
        }
        return ClassInheritorsSearch.search(new SearchParameters(aClass, scope, checkDeep, checkInheritance, includeAnonymous));
    }

    public static Query<PsiClass> search(@NotNull SearchParameters parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/searches/ClassInheritorsSearch.search must not be null");
        }
        return INSTANCE.createUniqueResultsQuery(parameters);
    }

    public static Query<PsiClass> search(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean checkDeep, boolean checkInheritance) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/searches/ClassInheritorsSearch.search must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/search/searches/ClassInheritorsSearch.search must not be null");
        }
        return ClassInheritorsSearch.search(aClass, scope, checkDeep, checkInheritance, true);
    }

    public static Query<PsiClass> search(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean checkDeep) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/searches/ClassInheritorsSearch.search must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/search/searches/ClassInheritorsSearch.search must not be null");
        }
        return ClassInheritorsSearch.search(aClass, scope, checkDeep, true);
    }

    public static Query<PsiClass> search(@NotNull PsiClass aClass, boolean checkDeep) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/searches/ClassInheritorsSearch.search must not be null");
        }
        return ClassInheritorsSearch.search(aClass, aClass.getUseScope(), checkDeep);
    }

    public static Query<PsiClass> search(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/searches/ClassInheritorsSearch.search must not be null");
        }
        return ClassInheritorsSearch.search(aClass, true);
    }

    private static boolean processInheritors(final @NotNull Processor<PsiClass> consumer, final @NotNull PsiClass baseClass, final @NotNull SearchScope searchScope, final @NotNull SearchParameters parameters) {
        if (consumer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/searches/ClassInheritorsSearch.processInheritors must not be null");
        }
        if (baseClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/search/searches/ClassInheritorsSearch.processInheritors must not be null");
        }
        if (searchScope == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/search/searches/ClassInheritorsSearch.processInheritors must not be null");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/search/searches/ClassInheritorsSearch.processInheritors must not be null");
        }
        if (baseClass instanceof PsiAnonymousClass) {
            return true;
        }
        if (ClassInheritorsSearch.isFinal(baseClass)) {
            return true;
        }
        String qname = ApplicationManager.getApplication().runReadAction(new Computable<String>(){

            public String compute() {
                return baseClass.getQualifiedName();
            }
        });
        if ("java.lang.Object".equals(qname)) {
            return AllClassesSearch.search(searchScope, baseClass.getProject(), parameters.getNameCondition()).forEach((Processor)new Processor<PsiClass>(){

                public boolean process(PsiClass aClass) {
                    ProgressManager.checkCanceled();
                    return consumer.process((Object)aClass);
                }
            });
        }
        final Ref currentBase = Ref.create(null);
        final Stack stack = new Stack();
        HashSet<PsiClass> processed = new HashSet<PsiClass>();
        Processor<PsiClass> processor = new Processor<PsiClass>(){

            public boolean process(final PsiClass candidate) {
                ProgressManager.checkCanceled();
                final Ref result = new Ref();
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        if ((parameters.isCheckInheritance() || parameters.isCheckDeep() && !(candidate instanceof PsiAnonymousClass)) && !candidate.isInheritor((PsiClass)currentBase.get(), false)) {
                            result.set((Object)true);
                            return;
                        }
                        if (PsiSearchScopeUtil.isInScope(searchScope, (PsiElement)candidate)) {
                            if (candidate instanceof PsiAnonymousClass) {
                                result.set((Object)consumer.process((Object)candidate));
                            } else {
                                String name = candidate.getName();
                                if (name != null && parameters.getNameCondition().value((Object)name) && !consumer.process((Object)candidate)) {
                                    result.set((Object)false);
                                }
                            }
                        }
                    }
                });
                if (!result.isNull()) {
                    return (Boolean)result.get();
                }
                if (parameters.isCheckDeep() && !(candidate instanceof PsiAnonymousClass) && !ClassInheritorsSearch.isFinal(candidate)) {
                    stack.push((Object)candidate);
                }
                return true;
            }
        };
        stack.push((Object)baseClass);
        GlobalSearchScope scope = GlobalSearchScope.allScope(baseClass.getProject());
        while (!stack.isEmpty()) {
            ProgressManager.checkCanceled();
            PsiClass psiClass = (PsiClass)stack.pop();
            if (!processed.add(psiClass)) continue;
            currentBase.set((Object)psiClass);
            if (DirectClassInheritorsSearch.search(psiClass, scope, parameters.isIncludeAnonymous()).forEach((Processor)processor)) continue;
            return false;
        }
        return true;
    }

    private static boolean isFinal(final PsiClass baseClass) {
        return ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

            public Boolean compute() {
                return baseClass.hasModifierProperty("final");
            }
        });
    }

    static {
        INSTANCE.registerExecutor(new QueryExecutor<PsiClass, SearchParameters>(){

            public boolean execute(SearchParameters parameters, Processor<PsiClass> consumer) {
                PsiClass baseClass = parameters.getClassToProcess();
                SearchScope searchScope = parameters.getScope();
                LOG.assertTrue(searchScope != null);
                ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
                if (progress != null) {
                    progress.pushState();
                    String className = baseClass.getName();
                    progress.setText(className != null ? PsiBundle.message("psi.search.inheritors.of.class.progress", className) : PsiBundle.message("psi.search.inheritors.progress", new Object[0]));
                }
                boolean result = ClassInheritorsSearch.processInheritors((Processor<PsiClass>)consumer, baseClass, searchScope, parameters);
                if (progress != null) {
                    progress.popState();
                }
                return result;
            }
        });
    }

    public static class SearchParameters {
        private final PsiClass myClass;
        private final SearchScope myScope;
        private final boolean myCheckDeep;
        private final boolean myCheckInheritance;
        private final boolean myIncludeAnonymous;
        private final Condition<String> myNameCondition;

        public SearchParameters(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean checkDeep, boolean checkInheritance, boolean includeAnonymous) {
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/searches/ClassInheritorsSearch$SearchParameters.<init> must not be null");
            }
            if (scope == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/search/searches/ClassInheritorsSearch$SearchParameters.<init> must not be null");
            }
            this(aClass, scope, checkDeep, checkInheritance, includeAnonymous, (Condition<String>)Condition.TRUE);
        }

        public SearchParameters(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean checkDeep, boolean checkInheritance, boolean includeAnonymous, Condition<String> nameCondition) {
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/searches/ClassInheritorsSearch$SearchParameters.<init> must not be null");
            }
            if (scope == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/search/searches/ClassInheritorsSearch$SearchParameters.<init> must not be null");
            }
            this.myClass = aClass;
            this.myScope = scope;
            this.myCheckDeep = checkDeep;
            this.myCheckInheritance = checkInheritance;
            this.myIncludeAnonymous = includeAnonymous;
            this.myNameCondition = nameCondition;
        }

        @NotNull
        public PsiClass getClassToProcess() {
            PsiClass psiClass = this.myClass;
            if (psiClass == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/search/searches/ClassInheritorsSearch$SearchParameters.getClassToProcess must not return null");
            }
            return psiClass;
        }

        public Condition<String> getNameCondition() {
            return this.myNameCondition;
        }

        public boolean isCheckDeep() {
            return this.myCheckDeep;
        }

        public SearchScope getScope() {
            return this.myScope;
        }

        public boolean isCheckInheritance() {
            return this.myCheckInheritance;
        }

        public boolean isIncludeAnonymous() {
            return this.myIncludeAnonymous;
        }
    }
}

