/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.util.FilteredQuery;
import com.intellij.util.Query;

public class DirectClassInheritorsSearch
extends ExtensibleQueryFactory<PsiClass, SearchParameters> {
    public static DirectClassInheritorsSearch INSTANCE = new DirectClassInheritorsSearch();

    private DirectClassInheritorsSearch() {
    }

    public static Query<PsiClass> search(PsiClass aClass) {
        return DirectClassInheritorsSearch.search(aClass, GlobalSearchScope.allScope(aClass.getProject()));
    }

    public static Query<PsiClass> search(PsiClass aClass, SearchScope scope) {
        return INSTANCE.createUniqueResultsQuery(new SearchParameters(aClass, scope));
    }

    public static Query<PsiClass> search(PsiClass aClass, SearchScope scope, boolean includeAnonymous) {
        Query raw = INSTANCE.createUniqueResultsQuery(new SearchParameters(aClass, scope, includeAnonymous));
        if (!includeAnonymous) {
            return new FilteredQuery(raw, (Condition)new Condition<PsiClass>(){

                public boolean value(PsiClass psiClass) {
                    return !(psiClass instanceof PsiAnonymousClass);
                }
            });
        }
        return raw;
    }

    public static class SearchParameters {
        private final PsiClass myClass;
        private final SearchScope myScope;
        private final boolean myIncludeAnonymous;

        public SearchParameters(PsiClass aClass, SearchScope scope, boolean includeAnonymous) {
            this.myIncludeAnonymous = includeAnonymous;
            this.myClass = aClass;
            this.myScope = scope;
        }

        public SearchParameters(PsiClass aClass, SearchScope scope) {
            this.myClass = aClass;
            this.myScope = scope;
            this.myIncludeAnonymous = true;
        }

        public PsiClass getClassToProcess() {
            return this.myClass;
        }

        public SearchScope getScope() {
            return this.myScope;
        }

        public boolean includeAnonymous() {
            return this.myIncludeAnonymous;
        }
    }
}

