/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.util.Function;
import com.intellij.util.Query;
import gnu.trove.TObjectHashingStrategy;
import org.jetbrains.annotations.NotNull;

public class ReferencesSearch
extends ExtensibleQueryFactory<PsiReference, SearchParameters> {
    private static final ReferencesSearch INSTANCE = new ReferencesSearch();
    private static final Function<PsiReference, ReferenceDescriptor> MAPPER = new Function<PsiReference, ReferenceDescriptor>(){

        public ReferenceDescriptor fun(PsiReference psiReference) {
            PsiElement element = psiReference.getElement();
            PsiFile file = element.getContainingFile();
            return new ReferenceDescriptor(file, element.getTextRange().getStartOffset() + psiReference.getRangeInElement().getStartOffset());
        }
    };

    private ReferencesSearch() {
    }

    public static Query<PsiReference> search(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/searches/ReferencesSearch.search must not be null");
        }
        return ReferencesSearch.search(element, GlobalSearchScope.projectScope(element.getProject()), false);
    }

    public static Query<PsiReference> search(@NotNull PsiElement element, @NotNull SearchScope searchScope) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/searches/ReferencesSearch.search must not be null");
        }
        if (searchScope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/search/searches/ReferencesSearch.search must not be null");
        }
        return ReferencesSearch.search(element, searchScope, false);
    }

    public static Query<PsiReference> search(@NotNull PsiElement element, @NotNull SearchScope searchScope, boolean ignoreAccessScope) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/searches/ReferencesSearch.search must not be null");
        }
        if (searchScope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/search/searches/ReferencesSearch.search must not be null");
        }
        return ReferencesSearch.search(new SearchParameters(element, searchScope, ignoreAccessScope));
    }

    public static Query<PsiReference> search(@NotNull SearchParameters parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/searches/ReferencesSearch.search must not be null");
        }
        return INSTANCE.createUniqueResultsQuery(parameters, TObjectHashingStrategy.CANONICAL, MAPPER);
    }

    public static class SearchParameters {
        private final PsiElement myElementToSearch;
        private final SearchScope myScope;
        private final boolean myIgnoreAccessScope;

        public SearchParameters(PsiElement elementToSearch, SearchScope scope, boolean ignoreAccessScope) {
            this.myElementToSearch = elementToSearch;
            this.myScope = scope;
            this.myIgnoreAccessScope = ignoreAccessScope;
        }

        public PsiElement getElementToSearch() {
            return this.myElementToSearch;
        }

        public SearchScope getScope() {
            return this.myScope;
        }

        public boolean isIgnoreAccessScope() {
            return this.myIgnoreAccessScope;
        }

        public SearchScope getEffectiveSearchScope() {
            if (!this.myIgnoreAccessScope) {
                SearchScope accessScope = this.myElementToSearch.getUseScope();
                return this.myScope.intersectWith(accessScope);
            }
            return this.myScope;
        }
    }

    private static class ReferenceDescriptor {
        private final PsiFile file;
        private final int offset;

        private ReferenceDescriptor(PsiFile file, int offset) {
            this.file = file;
            this.offset = offset;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ReferenceDescriptor)) {
                return false;
            }
            ReferenceDescriptor that = (ReferenceDescriptor)o;
            if (this.offset != that.offset) {
                return false;
            }
            return this.file.equals(that.file);
        }

        public int hashCode() {
            return 31 * this.file.hashCode() + this.offset;
        }
    }
}

