/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.codeInsight.CodeInsightTestCase;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.newStructureView.StructureViewComponent;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;

public abstract class StructureViewTestCase
extends CodeInsightTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doTest(Test test) {
        assert (this.myFile != null) : "configure first";
        VirtualFile vFile = this.myFile.getVirtualFile();
        assert (vFile != null) : "no virtual file for " + this.myFile;
        FileEditor fileEditor = FileEditorManager.getInstance(this.getProject()).getSelectedEditor(vFile);
        assert (fileEditor != null) : "editor not opened for " + vFile;
        StructureViewBuilder builder = LanguageStructureViewBuilder.INSTANCE.getStructureViewBuilder(this.myFile);
        assert (builder != null) : "no builder for " + this.myFile;
        StructureViewComponent component = null;
        try {
            component = (StructureViewComponent)builder.createStructureView(fileEditor, this.myProject);
            test.test(component);
            if (component == null) return;
        }
        catch (Throwable throwable) {
            if (component == null) throw throwable;
            Disposer.dispose(component);
            throw throwable;
        }
        Disposer.dispose((Disposable)component);
    }

    protected static interface Test {
        public void test(StructureViewComponent var1);
    }
}

