/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl;

import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.UiDecorator;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.text.html.HTMLEditorKit;

public class JBTabsTest {
    public static void main(String[] args) {
        System.out.println("JBTabs.main");
        IconLoader.activate();
        JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new BorderLayout(0, 0));
        int[] count = new int[1];
        final JBTabsImpl tabs = new JBTabsImpl(null, null, null, Disposer.newDisposable());
        tabs.setTestMode(true);
        frame.getContentPane().add((Component)tabs.getComponent(), "Center");
        JPanel south = new JPanel(new FlowLayout());
        south.setOpaque(true);
        south.setBackground(Color.white);
        final JComboBox<Object> pos = new JComboBox<Object>(new Object[]{JBTabsPosition.top, JBTabsPosition.left, JBTabsPosition.right, JBTabsPosition.bottom});
        pos.setSelectedIndex(0);
        south.add(pos);
        pos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JBTabsPosition p = (JBTabsPosition)((Object)pos.getSelectedItem());
                if (p != null) {
                    tabs.getPresentation().setTabsPosition(p);
                }
            }
        });
        final JCheckBox bb = new JCheckBox("Buffered", true);
        bb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                tabs.setUseBufferedPaint(bb.isSelected());
            }
        });
        south.add(bb);
        final JCheckBox f = new JCheckBox("Focused");
        f.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                tabs.setFocused(f.isSelected());
            }
        });
        south.add(f);
        final JCheckBox v = new JCheckBox("Vertical");
        v.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                tabs.setSideComponentVertical(v.isSelected());
            }
        });
        south.add(v);
        final JCheckBox row = new JCheckBox("Single row", true);
        row.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                tabs.setSingleRow(row.isSelected());
            }
        });
        south.add(row);
        final JCheckBox ghosts = new JCheckBox("Ghosts always visible", false);
        ghosts.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                tabs.setGhostsAlwaysVisible(ghosts.isSelected());
            }
        });
        south.add(ghosts);
        final JCheckBox stealth = new JCheckBox("Stealth tab", tabs.isStealthTabMode());
        stealth.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                tabs.setStealthTabMode(stealth.isSelected());
            }
        });
        south.add(stealth);
        final JCheckBox hide = new JCheckBox("Hide tabs", tabs.isHideTabs());
        hide.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                tabs.setHideTabs(hide.isSelected());
            }
        });
        south.add(hide);
        frame.getContentPane().add((Component)south, "South");
        tabs.addListener(new TabsListener.Adapter(){

            @Override
            public void selectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                System.out.println("TabsWithActions.selectionChanged old=" + oldSelection + " new=" + newSelection);
            }
        });
        JTree someTree = new JTree(){

            @Override
            public void addNotify() {
                super.addNotify();
                System.out.println("JBTabs.addNotify");
            }

            @Override
            public void removeNotify() {
                System.out.println("JBTabs.removeNotify");
                super.removeNotify();
            }
        };
        tabs.addTab(new TabInfo(someTree)).setText("Tree1").setActions(new DefaultActionGroup(), null).setIcon(IconLoader.getIcon((String)"/debugger/frame.png"));
        JTree component = new JTree();
        final TabInfo toAnimate1 = new TabInfo(component);
        final JCheckBox attract1 = new JCheckBox("Attract 1");
        attract1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (attract1.isSelected()) {
                    toAnimate1.fireAlert();
                } else {
                    toAnimate1.stopAlerting();
                }
            }
        });
        south.add(attract1);
        JCheckBox hide1 = new JCheckBox("Hide 1", toAnimate1.isHidden());
        hide1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                toAnimate1.setHidden(!toAnimate1.isHidden());
            }
        });
        south.add(hide1);
        final JCheckBox block = new JCheckBox("Block", false);
        block.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                tabs.setPaintBlocked(!block.isSelected(), true);
            }
        });
        south.add(block);
        final JCheckBox fill = new JCheckBox("Tab fill in", true);
        fill.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                tabs.getPresentation().setActiveTabFillIn(fill.isSelected() ? Color.white : null);
            }
        });
        south.add(fill);
        JButton refire = new JButton("Re-fire attraction");
        refire.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                toAnimate1.fireAlert();
            }
        });
        south.add(refire);
        JEditorPane text = new JEditorPane();
        text.setEditorKit(new HTMLEditorKit());
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < 50; ++i) {
            buffer.append("1234567890abcdefghijklmnopqrstv1234567890abcdefghijklmnopqrstv1234567890abcdefghijklmnopqrstv<br>");
        }
        text.setText(buffer.toString());
        JLabel tb = new JLabel("Side comp");
        tb.setBorder(new LineBorder(Color.red));
        tabs.addTab(new TabInfo(new JScrollPane(text)).setSideComponent(tb)).setText("Text text text");
        tabs.addTab(toAnimate1).append("Tree2", new SimpleTextAttributes(8, Color.black, Color.red));
        tabs.addTab(new TabInfo(new JTable())).setText("Table 1").setActions(new DefaultActionGroup(), null);
        tabs.addTab(new TabInfo(new JTable())).setText("Table 2").setActions(new DefaultActionGroup(), null);
        tabs.addTab(new TabInfo(new JTable())).setText("Table 3").setActions(new DefaultActionGroup(), null);
        tabs.addTab(new TabInfo(new JTable())).setText("Table 4").setActions(new DefaultActionGroup(), null);
        tabs.addTab(new TabInfo(new JTable())).setText("Table 5").setActions(new DefaultActionGroup(), null);
        tabs.addTab(new TabInfo(new JTable())).setText("Table 6").setActions(new DefaultActionGroup(), null);
        tabs.addTab(new TabInfo(new JTable())).setText("Table 7").setActions(new DefaultActionGroup(), null);
        tabs.addTab(new TabInfo(new JTable())).setText("Table 8").setActions(new DefaultActionGroup(), null);
        tabs.addTab(new TabInfo(new JTable())).setText("Table 9").setActions(new DefaultActionGroup(), null);
        tabs.setTabSidePaintBorder(5);
        tabs.setPaintBorder(1, 1, 1, 1);
        tabs.getPresentation().setActiveTabFillIn(Color.white);
        tabs.setGhostsAlwaysVisible(true);
        tabs.setBorder(new EmptyBorder(30, 30, 30, 30));
        tabs.setUiDecorator(new UiDecorator(){

            @Override
            public UiDecorator.UiDecoration getDecoration() {
                return new UiDecorator.UiDecoration(null, new Insets(0, -1, 0, -1));
            }
        });
        tabs.setStealthTabMode(true);
        frame.setBounds(1400, 200, 1000, 800);
        frame.show();
    }
}

