/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageTargetProvider;
import java.util.ArrayList;
import java.util.Collections;

public class UsageTargetUtil {
    private static final ExtensionPointName<UsageTargetProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.usageTargetProvider");

    public void foo() {
    }

    public static UsageTarget[] findUsageTargets(DataProvider dataProvider) {
        UsageTarget[] targets;
        PsiElement psiElement;
        UsageTarget[] targets2;
        Editor editor = PlatformDataKeys.EDITOR.getData(dataProvider);
        PsiFile file = LangDataKeys.PSI_FILE.getData(dataProvider);
        ArrayList result = new ArrayList();
        if (file != null && editor != null && (targets2 = UsageTargetUtil.findUsageTargets(editor, file)) != null) {
            Collections.addAll(result, targets2);
        }
        if ((psiElement = LangDataKeys.PSI_ELEMENT.getData(dataProvider)) != null && (targets = UsageTargetUtil.findUsageTargets(psiElement)) != null) {
            Collections.addAll(result, targets);
        }
        return result.isEmpty() ? null : result.toArray(new UsageTarget[result.size()]);
    }

    public static UsageTarget[] findUsageTargets(Editor editor, PsiFile file) {
        ArrayList result = new ArrayList();
        for (UsageTargetProvider provider : (UsageTargetProvider[])Extensions.getExtensions(EP_NAME)) {
            UsageTarget[] targets = provider.getTargets(editor, file);
            if (targets == null) continue;
            Collections.addAll(result, targets);
        }
        return result.isEmpty() ? null : result.toArray(new UsageTarget[result.size()]);
    }

    public static UsageTarget[] findUsageTargets(PsiElement psiElement) {
        ArrayList result = new ArrayList();
        for (UsageTargetProvider provider : (UsageTargetProvider[])Extensions.getExtensions(EP_NAME)) {
            UsageTarget[] targets = provider.getTargets(psiElement);
            if (targets == null) continue;
            Collections.addAll(result, targets);
        }
        return result.isEmpty() ? null : result.toArray(new UsageTarget[result.size()]);
    }
}

