/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.Disposable;
import com.intellij.util.ui.Animator;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComponent;

public abstract class AnimatedIcon
extends JComponent
implements Disposable {
    private Icon[] myIcons;
    private Dimension myPrefSize = new Dimension();
    private int myCurrentIconIndex;
    private Icon myPassiveIcon;
    private Icon myEmptyPassiveIcon;
    private boolean myPaintPassive = true;
    private boolean myRunning = true;
    protected Animator myAnimator;
    private final String myName;
    private boolean myLastPaintWasRunning;

    protected AnimatedIcon(String name) {
        this.myName = name;
    }

    protected final void init(Icon[] icons, Icon passiveIcon, int cycleLength, int interCycleGap, int maxRepeatCount) {
        this.myIcons = icons;
        this.myPassiveIcon = passiveIcon;
        this.myPrefSize = new Dimension();
        for (Icon each : icons) {
            this.myPrefSize.width = Math.max(each.getIconWidth(), this.myPrefSize.width);
            this.myPrefSize.height = Math.max(each.getIconHeight(), this.myPrefSize.height);
        }
        this.myPrefSize.width = Math.max(passiveIcon.getIconWidth(), this.myPrefSize.width);
        this.myPrefSize.height = Math.max(passiveIcon.getIconHeight(), this.myPrefSize.height);
        UIUtil.removeQuaquaVisualMarginsIn((Component)this);
        this.myAnimator = new Animator(this.myName, icons.length, cycleLength, true, interCycleGap, maxRepeatCount){

            @Override
            public void paintNow(float frame, float totalFrames, float cycle) {
                AnimatedIcon.this.myCurrentIconIndex = (int)frame;
                AnimatedIcon.this.paintImmediately(0, 0, AnimatedIcon.this.getWidth(), AnimatedIcon.this.getHeight());
            }

            @Override
            protected void onAnimationMaxCycleReached() throws InterruptedException {
                AnimatedIcon.this.onAnimationMaxCycleReached();
            }

            @Override
            public boolean isAnimated() {
                return AnimatedIcon.this.isAnimated();
            }
        };
        this.myEmptyPassiveIcon = icons.length > 0 ? new EmptyIcon(icons[0]) : new EmptyIcon(0);
        this.setOpaque(true);
    }

    public void setPaintPassiveIcon(boolean paintPassive) {
        this.myPaintPassive = paintPassive;
    }

    protected void onAnimationMaxCycleReached() throws InterruptedException {
    }

    private boolean ensureAnimation(boolean running) {
        boolean changes;
        boolean bl = changes = this.myAnimator.isRunning() != running;
        if (running) {
            this.setOpaque(true);
            this.myAnimator.resume();
        } else {
            this.setOpaque(this.myPaintPassive);
            this.myAnimator.suspend();
        }
        return changes;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.myRunning) {
            this.ensureAnimation(true);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.ensureAnimation(false);
    }

    public void resume() {
        this.myRunning = true;
        this.ensureAnimation(true);
    }

    public void suspend() {
        this.myRunning = false;
        if (this.ensureAnimation(false)) {
            this.repaint();
        }
    }

    public void dispose() {
        this.myAnimator.dispose();
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        return new Dimension(this.myPrefSize.width + insets.left + insets.right, this.myPrefSize.height + insets.top + insets.bottom);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.isOpaque() && (this.myAnimator.isRunning() || this.myPaintPassive || this.myLastPaintWasRunning && !this.myAnimator.isRunning())) {
            g.setColor(UIUtil.getBgFillColor((JComponent)this));
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        Icon icon = this.myAnimator.isRunning() ? this.myIcons[this.myCurrentIconIndex] : this.getPassiveIcon();
        Dimension size = this.getSize();
        int x = (size.width - icon.getIconWidth()) / 2;
        int y = (size.height - icon.getIconHeight()) / 2;
        icon.paintIcon(this, g, x, y);
        this.myLastPaintWasRunning = this.myAnimator.isRunning();
    }

    protected Icon getPassiveIcon() {
        return this.myPaintPassive ? this.myPassiveIcon : this.myEmptyPassiveIcon;
    }

    public boolean isAnimated() {
        return true;
    }
}

