/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.util.ui.OptionsDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class OptionsMessageDialog
extends OptionsDialog {
    private final String myMessage;
    private final Icon myIcon;

    protected OptionsMessageDialog(Project project, String message, String title, Icon icon) {
        super(project);
        this.myMessage = message;
        this.myIcon = icon;
        this.setTitle(title);
        this.setButtonsAlignment(0);
    }

    protected abstract String getOkActionName();

    protected abstract String getCancelActionName();

    @Override
    protected Action[] createActions() {
        Action okAction = this.getOKAction();
        Action cancelAction = this.getCancelAction();
        OptionsMessageDialog.assignMnemonic(this.getOkActionName(), okAction);
        OptionsMessageDialog.assignMnemonic(this.getCancelActionName(), cancelAction);
        return new Action[]{okAction, cancelAction};
    }

    protected static void assignMnemonic(String option, Action action) {
        String mnemoChar;
        action.putValue("Name", option);
        int mnemoPos = option.indexOf("&");
        if (mnemoPos >= 0 && mnemoPos < option.length() - 2 && (mnemoChar = option.substring(mnemoPos + 1, mnemoPos + 2).trim()).length() == 1) {
            action.putValue("MnemonicKey", new Integer(mnemoChar.charAt(0)));
        }
    }

    @Override
    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel(new BorderLayout(15, 0));
        if (this.myIcon != null) {
            JLabel iconLabel = new JLabel(this.myIcon);
            Container container = new Container();
            container.setLayout(new BorderLayout());
            container.add((Component)iconLabel, "North");
            panel.add((Component)container, "West");
        }
        if (this.myMessage != null) {
            JLabel textLabel = new JLabel(this.myMessage);
            textLabel.setUI(new MultiLineLabelUI());
            panel.add((Component)textLabel, "Center");
        }
        return panel;
    }

    @Override
    protected JComponent createCenterPanel() {
        return null;
    }
}

