/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionCache;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.MergedObject;
import com.intellij.util.xml.NameValue;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import com.intellij.util.xml.reflect.DomGenericInfo;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomUtil {
    public static final TypeVariable<Class<GenericValue>> GENERIC_VALUE_TYPE_VARIABLE = ReflectionCache.getTypeParameters(GenericValue.class)[0];
    private static final Class<Void> DUMMY = Void.TYPE;
    private static final Key<DomFileElement> FILE_ELEMENT_KEY = Key.create((String)"dom file element");
    private static final ConcurrentFactoryMap<Type, Class> ourTypeParameters = new ConcurrentFactoryMap<Type, Class>(){

        @NotNull
        protected Class create(Type key) {
            Class result = ReflectionUtil.substituteGenericType(GENERIC_VALUE_TYPE_VARIABLE, (Type)key);
            Class clazz = result == null ? DUMMY : result;
            if (clazz == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/xml/DomUtil$1.create must not return null");
            }
            return clazz;
        }
    };

    private DomUtil() {
    }

    public static Class extractParameterClassFromGenericType(Type type) {
        return DomUtil.getGenericValueParameter(type);
    }

    public static boolean isGenericValueType(Type type) {
        return DomUtil.getGenericValueParameter(type) != null;
    }

    @Nullable
    public static <T extends DomElement> T findByName(@NotNull Collection<T> list, @NonNls @NotNull String name) {
        if (list == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/DomUtil.findByName must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/xml/DomUtil.findByName must not be null");
        }
        for (DomElement element : list) {
            String elementName = element.getGenericInfo().getElementName(element);
            if (elementName == null || !elementName.equals(name)) continue;
            return (T)element;
        }
        return null;
    }

    @NotNull
    public static String[] getElementNames(@NotNull Collection<? extends DomElement> list) {
        if (list == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/DomUtil.getElementNames must not be null");
        }
        ArrayList<String> result = new ArrayList<String>(list.size());
        if (list.size() > 0) {
            for (DomElement domElement : list) {
                String name = domElement.getGenericInfo().getElementName(domElement);
                if (name == null) continue;
                result.add(name);
            }
        }
        String[] stringArray = ArrayUtil.toStringArray(result);
        if (stringArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/DomUtil.getElementNames must not return null");
        }
        return stringArray;
    }

    @NotNull
    public static List<XmlTag> getElementTags(@NotNull Collection<? extends DomElement> list) {
        if (list == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/DomUtil.getElementTags must not be null");
        }
        ArrayList<XmlTag> result = new ArrayList<XmlTag>(list.size());
        for (DomElement domElement : list) {
            XmlTag tag = domElement.getXmlTag();
            if (tag == null) continue;
            result.add(tag);
        }
        ArrayList<XmlTag> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/DomUtil.getElementTags must not return null");
        }
        return arrayList;
    }

    @NotNull
    public static XmlTag[] getElementTags(@NotNull DomElement[] list) {
        if (list == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/DomUtil.getElementTags must not be null");
        }
        XmlTag[] result = new XmlTag[list.length];
        int i = 0;
        for (DomElement element : list) {
            XmlTag tag = element.getXmlTag();
            if (tag == null) continue;
            result[i++] = tag;
        }
        if (result == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/DomUtil.getElementTags must not return null");
        }
        return result;
    }

    @Nullable
    public static List<JavaMethod> getFixedPath(DomElement element) {
        DomElement parent;
        assert (element.isValid());
        LinkedList<JavaMethod> methods = new LinkedList<JavaMethod>();
        while (!((parent = element.getParent()) instanceof DomFileElement)) {
            JavaMethod method = DomUtil.getGetterMethod(element, parent);
            if (method == null) {
                return null;
            }
            methods.addFirst(method);
            element = element.getParent();
        }
        return methods;
    }

    @Nullable
    private static JavaMethod getGetterMethod(DomElement element, DomElement parent) {
        String xmlElementName = element.getXmlElementName();
        String namespace = element.getXmlElementNamespaceKey();
        DomGenericInfo genericInfo = parent.getGenericInfo();
        if (element instanceof GenericAttributeValue) {
            DomAttributeChildDescription description = genericInfo.getAttributeChildDescription(xmlElementName, namespace);
            assert (description != null);
            return description.getGetterMethod();
        }
        DomFixedChildDescription description = genericInfo.getFixedChildDescription(xmlElementName, namespace);
        return description != null ? description.getGetterMethod(description.getValues(parent).indexOf(element)) : null;
    }

    @Nullable
    public static Class getGenericValueParameter(Type type) {
        Class aClass = (Class)ourTypeParameters.get((Object)type);
        return aClass == DUMMY ? null : aClass;
    }

    @Nullable
    public static XmlElement getValueElement(GenericDomValue domValue) {
        if (domValue instanceof GenericAttributeValue) {
            GenericAttributeValue value = (GenericAttributeValue)domValue;
            XmlAttributeValue attributeValue = value.getXmlAttributeValue();
            return attributeValue == null ? value.getXmlAttribute() : attributeValue;
        }
        return domValue.getXmlTag();
    }

    public static List<? extends DomElement> getIdentitySiblings(DomElement element) {
        String tagName;
        DomElement parent;
        DomGenericInfo domGenericInfo;
        DomCollectionChildDescription childDescription;
        String stringValue;
        NameValue nameValue;
        Method nameValueMethod = ElementPresentationManager.findNameValueMethod(element.getClass());
        if (nameValueMethod != null && ((nameValue = DomReflectionUtil.findAnnotationDFS(nameValueMethod, NameValue.class)) == null || nameValue.unique()) && (stringValue = ElementPresentationManager.getElementName(element)) != null && (childDescription = (domGenericInfo = (parent = element.getManager().getIdentityScope(element)).getGenericInfo()).getCollectionChildDescription(tagName = element.getXmlElementName(), element.getXmlElementNamespaceKey())) != null) {
            ArrayList<? extends DomElement> list = new ArrayList<DomElement>(childDescription.getValues(parent));
            list.remove(element);
            return list;
        }
        return Collections.emptyList();
    }

    public static <T> List<T> getChildrenOfType(@NotNull DomElement parent, final Class<T> type) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/DomUtil.getChildrenOfType must not be null");
        }
        SmartList result = new SmartList();
        parent.acceptChildren(new DomElementVisitor((List)result){
            final /* synthetic */ List val$result;
            {
                this.val$result = list;
            }

            @Override
            public void visitDomElement(DomElement element) {
                if (type.isInstance(element)) {
                    this.val$result.add(element);
                }
            }
        });
        return result;
    }

    public static List<DomElement> getDefinedChildren(@NotNull DomElement parent, boolean tags, boolean attributes) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/DomUtil.getDefinedChildren must not be null");
        }
        if (parent instanceof MergedObject) {
            final SmartList result = new SmartList();
            parent.acceptChildren(new DomElementVisitor(){

                @Override
                public void visitDomElement(DomElement element) {
                    if (DomUtil.hasXml(element)) {
                        result.add((Object)element);
                    }
                }
            });
            return result;
        }
        ProgressManager.checkCanceled();
        if (parent instanceof GenericAttributeValue) {
            return Collections.emptyList();
        }
        if (parent instanceof DomFileElement) {
            DomFileElement element = (DomFileElement)parent;
            return tags ? Arrays.asList(element.getRootElement()) : Collections.emptyList();
        }
        XmlElement xmlElement = parent.getXmlElement();
        if (xmlElement instanceof XmlTag) {
            XmlTag tag = (XmlTag)xmlElement;
            DomManager domManager = parent.getManager();
            SmartList result = new SmartList();
            if (attributes) {
                for (XmlElement xmlElement2 : tag.getAttributes()) {
                    ContainerUtil.addIfNotNull((Object)domManager.getDomElement((XmlAttribute)xmlElement2), (Collection)result);
                }
            }
            if (tags) {
                for (XmlElement xmlElement3 : tag.getSubTags()) {
                    ContainerUtil.addIfNotNull((Object)domManager.getDomElement((XmlTag)xmlElement3), (Collection)result);
                }
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static <T> List<T> getDefinedChildrenOfType(@NotNull DomElement parent, Class<T> type, boolean tags, boolean attributes) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/DomUtil.getDefinedChildrenOfType must not be null");
        }
        return ContainerUtil.findAll(DomUtil.getDefinedChildren(parent, tags, attributes), type);
    }

    public static <T> List<T> getDefinedChildrenOfType(@NotNull DomElement parent, Class<T> type) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/DomUtil.getDefinedChildrenOfType must not be null");
        }
        return DomUtil.getDefinedChildrenOfType(parent, type, true, true);
    }

    @Nullable
    public static DomElement findDuplicateNamedValue(DomElement element, String newName) {
        return ElementPresentationManager.findByName(DomUtil.getIdentitySiblings(element), newName);
    }

    public static boolean isAncestor(@NotNull DomElement ancestor, @NotNull DomElement descendant, boolean strict) {
        if (ancestor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/DomUtil.isAncestor must not be null");
        }
        if (descendant == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/xml/DomUtil.isAncestor must not be null");
        }
        if (!strict && ancestor.equals(descendant)) {
            return true;
        }
        DomElement parent = descendant.getParent();
        return parent != null && DomUtil.isAncestor(ancestor, parent, false);
    }

    public static void acceptAvailableChildren(DomElement element, DomElementVisitor visitor) {
        XmlTag tag = element.getXmlTag();
        if (tag != null) {
            for (XmlTag xmlTag : tag.getSubTags()) {
                DomElement childElement = element.getManager().getDomElement(xmlTag);
                if (childElement == null) continue;
                childElement.accept(visitor);
            }
        }
    }

    public static Collection<Class> getAllInterfaces(Class aClass, Collection<Class> result) {
        Class[] interfaces = ReflectionCache.getInterfaces((Class)aClass);
        result.addAll(Arrays.asList(interfaces));
        if (aClass.getSuperclass() != null) {
            DomUtil.getAllInterfaces(aClass.getSuperclass(), result);
        }
        for (Class anInterface : interfaces) {
            DomUtil.getAllInterfaces(anInterface, result);
        }
        return result;
    }

    @Nullable
    public static <T> T getParentOfType(DomElement element, Class<T> requiredClass, boolean strict) {
        DomElement curElement;
        DomElement domElement = curElement = strict && element != null ? element.getParent() : element;
        while (curElement != null) {
            if (requiredClass.isInstance(curElement)) {
                return (T)curElement;
            }
            curElement = curElement.getParent();
        }
        return null;
    }

    @Nullable
    public static <T> T getContextElement(@Nullable Editor editor, Class<T> clazz) {
        DomElement element = DomUtil.getContextElement(editor);
        return DomUtil.getParentOfType(element, clazz, false);
    }

    @Nullable
    public static DomElement getContextElement(@Nullable Editor editor) {
        if (editor == null) {
            return null;
        }
        Project project = editor.getProject();
        if (project == null) {
            return null;
        }
        PsiFile file = PsiDocumentManager.getInstance(project).getPsiFile(editor.getDocument());
        if (!(file instanceof XmlFile)) {
            return null;
        }
        return DomUtil.getDomElement(file.findElementAt(editor.getCaretModel().getOffset()));
    }

    @Nullable
    public static DomElement getDomElement(Editor editor, PsiFile file) {
        return DomUtil.getDomElement(file.findElementAt(editor.getCaretModel().getOffset()));
    }

    @Nullable
    public static DomElement getDomElement(@Nullable PsiElement element) {
        GenericAttributeValue value;
        if (element == null) {
            return null;
        }
        Project project = element.getProject();
        DomManager domManager = DomManager.getDomManager(project);
        XmlAttribute attr = PsiTreeUtil.getParentOfType(element, XmlAttribute.class, false);
        if (attr != null && (value = domManager.getDomElement(attr)) != null) {
            return value;
        }
        for (XmlTag tag = PsiTreeUtil.getParentOfType(element, XmlTag.class, false); tag != null; tag = tag.getParentTag()) {
            DomElement domElement = domManager.getDomElement(tag);
            if (domElement == null) continue;
            return domElement;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T extends DomElement> T getOriginalElement(@NotNull T domElement) {
        Object object;
        if (domElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/DomUtil.getOriginalElement must not be null");
        }
        XmlElement psiElement = domElement.getXmlElement();
        if (psiElement == null) {
            object = domElement;
            if (object == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/DomUtil.getOriginalElement must not return null");
            return object;
        }
        PsiFile psiFile = psiElement.getContainingFile().getOriginalFile();
        TextRange range = psiElement.getTextRange();
        PsiElement element = psiFile.findElementAt(range.getStartOffset());
        int maxLength = range.getLength();
        boolean isAttribute = psiElement instanceof XmlAttribute;
        Class clazz = isAttribute ? XmlAttribute.class : XmlTag.class;
        DomManager domManager = domElement.getManager();
        DomElement current = null;
        XmlElement next = PsiTreeUtil.getParentOfType(element, clazz, false);
        while (next != null && next.getTextLength() <= maxLength) {
            DomElement domElement2 = current = isAttribute ? domManager.getDomElement((XmlAttribute)next) : domManager.getDomElement((XmlTag)next);
            if (current != null && domElement.getClass() != current.getClass()) {
                current = null;
            }
            next = PsiTreeUtil.getParentOfType((PsiElement)next, clazz, true);
        }
        object = current;
        if (object != null) return object;
        throw new IllegalStateException("@NotNull method com/intellij/util/xml/DomUtil.getOriginalElement must not return null");
    }

    public static <T extends DomElement> T addElementAfter(@NotNull T anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/DomUtil.addElementAfter must not be null");
        }
        DomElement parent = anchor.getParent();
        DomCollectionChildDescription childDescription = (DomCollectionChildDescription)anchor.getChildDescription();
        assert (parent != null);
        List<? extends DomElement> list = childDescription.getValues(parent);
        int i = list.indexOf(anchor);
        assert (i >= 0);
        return (T)childDescription.addValue(parent, i + 1);
    }

    @Nullable
    public static <T extends DomElement> T findDomElement(@Nullable PsiElement element, Class<T> beanClass) {
        return DomUtil.findDomElement(element, beanClass, true);
    }

    @Nullable
    public static <T extends DomElement> T findDomElement(@Nullable PsiElement element, Class<T> beanClass, boolean strict) {
        if (element == null) {
            return null;
        }
        for (XmlTag tag = PsiTreeUtil.getParentOfType(element, XmlTag.class, strict); tag != null; tag = tag.getParentTag()) {
            DomElement domElement = DomManager.getDomManager(tag.getProject()).getDomElement(tag);
            if (domElement == null) continue;
            return domElement.getParentOfType(beanClass, false);
        }
        return null;
    }

    public static <T extends DomElement> DomFileElement<T> getFileElement(@NotNull DomElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/DomUtil.getFileElement must not be null");
        }
        if (element instanceof DomFileElement) {
            return (DomFileElement)element;
        }
        DomFileElement<T> fileElement = (DomFileElement<T>)element.getUserData(FILE_ELEMENT_KEY);
        if (fileElement == null) {
            DomElement parent = element.getParent();
            if (parent != null) {
                fileElement = DomUtil.getFileElement(parent);
            }
            element.putUserData(FILE_ELEMENT_KEY, fileElement);
        }
        return fileElement;
    }

    @NotNull
    public static XmlFile getFile(@NotNull DomElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/DomUtil.getFile must not be null");
        }
        XmlFile xmlFile = DomService.getInstance().getContainingFile(element);
        if (xmlFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/DomUtil.getFile must not return null");
        }
        return xmlFile;
    }

    @NotNull
    public static DomElement getRoot(@NotNull DomElement domElement) {
        if (domElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/DomUtil.getRoot must not be null");
        }
        while (true) {
            DomElement parent;
            if ((parent = domElement.getParent()) == null) {
                DomElement domElement2 = domElement;
                if (domElement2 == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/util/xml/DomUtil.getRoot must not return null");
                }
                return domElement2;
            }
            domElement = parent;
        }
    }

    public static boolean hasXml(@NotNull DomElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/DomUtil.hasXml must not be null");
        }
        return element.getXmlElement() != null;
    }
}

