/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.util.Condition;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionCache;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentHashMap;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class JavaMethodSignature {
    private static final Map<Method, JavaMethodSignature> ourSignatures = new ConcurrentHashMap();
    private final String myMethodName;
    private final Class[] myMethodParameters;
    private final Set<Class> myKnownClasses = new THashSet();
    private final List<Method> myAllMethods = new SmartList();
    private final Map<Class, Method> myMethods = new THashMap();

    private JavaMethodSignature(String methodName, Class[] methodParameters) {
        this.myMethodName = methodName;
        this.myMethodParameters = methodParameters;
    }

    public String getMethodName() {
        return this.myMethodName;
    }

    public Class[] getParameterTypes() {
        return this.myMethodParameters;
    }

    public final Object invoke(Object instance, Object ... args) throws IllegalAccessException, InvocationTargetException {
        Class<?> aClass = instance.getClass();
        Method method = this.findMethod(aClass);
        assert (method != null) : "No method " + this + " in " + aClass;
        return method.invoke(instance, args);
    }

    @Nullable
    public final synchronized Method findMethod(Class aClass) {
        if (this.myMethods.containsKey(aClass)) {
            return this.myMethods.get(aClass);
        }
        Method method = this.getDeclaredMethod(aClass);
        if (method == null && ReflectionCache.isInterface((Class)aClass)) {
            method = this.getDeclaredMethod(Object.class);
        }
        this.myMethods.put(aClass, method);
        return method;
    }

    private void addMethodsIfNeeded(Class aClass) {
        if (!this.myKnownClasses.contains(aClass)) {
            this.addMethodWithSupers(aClass, this.findMethod(aClass));
        }
    }

    @Nullable
    private Method getDeclaredMethod(Class aClass) {
        Method method = ReflectionUtil.getMethod((Class)aClass, (String)this.myMethodName, (Class[])this.myMethodParameters);
        return method == null ? ReflectionUtil.getDeclaredMethod((Class)aClass, (String)this.myMethodName, (Class[])this.myMethodParameters) : method;
    }

    private void addMethodWithSupers(Class aClass, Method method) {
        Class superClass;
        this.myKnownClasses.add(aClass);
        if (method != null) {
            this.myAllMethods.add(method);
        }
        if ((superClass = aClass.getSuperclass()) != null) {
            this.addMethodsIfNeeded(superClass);
        } else if (aClass.isInterface()) {
            this.addMethodsIfNeeded(Object.class);
        }
        for (Class<?> anInterface : aClass.getInterfaces()) {
            this.addMethodsIfNeeded(anInterface);
        }
    }

    @Nullable
    public final synchronized <T extends Annotation> T findAnnotation(Class<T> annotationClass, Class startFrom) {
        this.addMethodsIfNeeded(startFrom);
        T result = null;
        Class<?> bestClass = null;
        int size = this.myAllMethods.size();
        for (int i = 0; i < size; ++i) {
            Class<?> declaringClass;
            Method method = this.myAllMethods.get(i);
            T annotation = method.getAnnotation(annotationClass);
            if (annotation == null || !ReflectionCache.isAssignable(declaringClass = method.getDeclaringClass(), (Class)startFrom) || result != null && !ReflectionCache.isAssignable(bestClass, declaringClass)) continue;
            result = annotation;
            bestClass = declaringClass;
        }
        return result;
    }

    public final synchronized List<Method> getAllMethods(final Class startFrom) {
        this.addMethodsIfNeeded(startFrom);
        List list = ContainerUtil.findAll(this.myAllMethods, (Condition)new Condition<Method>(){

            public boolean value(Method method) {
                return method.getDeclaringClass().isAssignableFrom(startFrom);
            }
        });
        return list;
    }

    @Nullable
    public final synchronized <T extends Annotation> Method findAnnotatedMethod(Class<T> annotationClass, Class startFrom) {
        this.addMethodsIfNeeded(startFrom);
        for (int i = 0; i < this.myAllMethods.size(); ++i) {
            Method method = this.myAllMethods.get(i);
            T annotation = method.getAnnotation(annotationClass);
            if (annotation == null || !ReflectionCache.isAssignable(method.getDeclaringClass(), (Class)startFrom)) continue;
            return method;
        }
        return null;
    }

    public String toString() {
        return this.myMethodName + Arrays.asList(this.myMethodParameters);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaMethodSignature that = (JavaMethodSignature)o;
        if (!this.myMethodName.equals(that.myMethodName)) {
            return false;
        }
        return Arrays.equals(this.myMethodParameters, that.myMethodParameters);
    }

    public int hashCode() {
        int result = this.myMethodName.hashCode();
        result = 31 * result + Arrays.hashCode(this.myMethodParameters);
        return result;
    }

    public static JavaMethodSignature getSignature(Method method) {
        JavaMethodSignature signature = ourSignatures.get(method);
        if (signature != null) {
            return signature;
        }
        Class<?>[] parameters = method.getParameterTypes();
        signature = new JavaMethodSignature(method.getName(), parameters.length == 0 ? ArrayUtil.EMPTY_CLASS_ARRAY : parameters);
        ourSignatures.put(method, signature);
        return signature;
    }

    public static JavaMethodSignature getSignature(String name, Class<?> ... parameterTypes) {
        return new JavaMethodSignature(name, parameterTypes);
    }
}

