/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ui.Committable;
import com.intellij.util.xml.ui.CommittablePanel;
import com.intellij.util.xml.ui.CommittableUtil;
import com.intellij.util.xml.ui.DomUIFactory;
import com.intellij.util.xml.ui.Highlightable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CaptionComponent
extends JPanel
implements Committable,
Highlightable {
    private JPanel myRootPanel;
    private JLabel myCaptionLabel;
    private JLabel myDescriptionLabel;
    private JLabel myIconLabel;
    private JPanel myErrorPanel;
    private CommittablePanel myCommittableErrorPanel;
    private boolean myBordered = true;

    public CaptionComponent() {
        this((String)null);
    }

    public CaptionComponent(String text) {
        this(text, null);
    }

    public CaptionComponent(String text, Icon icon) {
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.updateBorder();
        this.add((Component)this.myRootPanel, "Center");
        this.setText(text);
        this.setIcon(icon);
    }

    private void updateBorder() {
        if (this.myBordered) {
            this.myRootPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY));
        } else {
            this.myRootPanel.setBorder(BorderFactory.createEmptyBorder());
        }
    }

    @Override
    public void updateHighlighting() {
        CommittableUtil.updateHighlighting(this.myCommittableErrorPanel);
    }

    public void setText(String text) {
        if (text == null) {
            return;
        }
        this.myCaptionLabel.setText(text);
    }

    public String getText() {
        return this.myCaptionLabel.getText();
    }

    public void setIcon(Icon icon) {
        this.myIconLabel.setVisible(icon != null);
        this.myIconLabel.setIcon(icon);
    }

    public Icon getIcon() {
        return this.myIconLabel.getIcon();
    }

    public boolean isBordered() {
        return this.myBordered;
    }

    public String getDescriptionText() {
        return this.myDescriptionLabel.getText();
    }

    public void setDescriptionText(String text) {
        this.myDescriptionLabel.setVisible(text != null && text.trim().length() > 0);
        this.myDescriptionLabel.setText(text);
    }

    public final void setBordered(boolean bordered) {
        this.myBordered = bordered;
        this.updateBorder();
    }

    @Override
    public final void commit() {
    }

    @Override
    public void reset() {
        if (this.myCommittableErrorPanel != null) {
            this.myCommittableErrorPanel.reset();
        }
    }

    public final void dispose() {
    }

    public void initErrorPanel(DomElement ... elements) {
        DomUIFactory.getDomUIFactory().addErrorPanel(this, elements);
    }

    public void initErrorPanel(CommittablePanel errorPanel) {
        this.myCommittableErrorPanel = errorPanel;
        Disposer.register((Disposable)this, (Disposable)errorPanel);
        JComponent component = errorPanel.getComponent();
        component.setBackground(this.getBackground());
        this.myErrorPanel.setLayout(new BorderLayout());
        this.myErrorPanel.add((Component)component, "Center");
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JLabel jLabel;
        JLabel jLabel2;
        JLabel jLabel3;
        JPanel jPanel2;
        this.myRootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 4, new Insets(5, 5, 5, 5), -1, -1, false, false));
        ((Component)jPanel2).setBackground(new Color(-789275));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        this.myCaptionLabel = jLabel3 = new JLabel();
        ((Component)jLabel3).setFont(new Font("Tahoma", 1, 11));
        jLabel3.setText("Unknown");
        jPanel2.add((Component)jLabel3, new GridConstraints(0, 1, 1, 2, 8, 3, 7, 3, null, null, null));
        this.myDescriptionLabel = jLabel2 = new JLabel();
        jLabel2.setText("");
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 1, 1, 2, 8, 0, 7, 3, null, null, null));
        this.myIconLabel = jLabel = new JLabel();
        jLabel.setText("");
        ((Component)jLabel).setVisible(false);
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 2, 1, 8, 0, 0, 0, null, null, null));
        this.myErrorPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel).setBackground(new Color(-789275));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 3, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(1, 3, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

