/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.inspections;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.uiDesigner.ErrorInfo;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.inspections.EditorQuickFixProvider;
import com.intellij.uiDesigner.inspections.FormErrorCollector;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.IProperty;
import com.intellij.uiDesigner.quickFixes.QuickFix;
import com.intellij.uiDesigner.radComponents.RadComponent;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormEditorErrorCollector
extends FormErrorCollector {
    private final GuiEditor myEditor;
    private final RadComponent myComponent;
    private List<ErrorInfo> myResults = null;
    private final InspectionProfile myProfile;
    private PsiFile myFormPsiFile;

    public FormEditorErrorCollector(GuiEditor editor, RadComponent component) {
        this.myEditor = editor;
        this.myComponent = component;
        this.myFormPsiFile = PsiManager.getInstance((Project)editor.getProject()).findFile(editor.getFile());
        InspectionProjectProfileManager profileManager = InspectionProjectProfileManager.getInstance((Project)editor.getProject());
        this.myProfile = profileManager.getInspectionProfile();
    }

    public ErrorInfo[] result() {
        return this.myResults == null ? null : this.myResults.toArray(new ErrorInfo[this.myResults.size()]);
    }

    @Override
    public void addError(@NotNull String inspectionId, IComponent component, @Nullable IProperty prop, @NotNull String errorMessage, @Nullable EditorQuickFixProvider editorQuickFixProvider) {
        if (inspectionId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/inspections/FormEditorErrorCollector.addError must not be null");
        }
        if (errorMessage == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/uiDesigner/inspections/FormEditorErrorCollector.addError must not be null");
        }
        if (this.myResults == null) {
            this.myResults = new ArrayList<ErrorInfo>();
        }
        QuickFix[] quickFixes = QuickFix.EMPTY_ARRAY;
        if (editorQuickFixProvider != null) {
            quickFixes = new QuickFix[]{editorQuickFixProvider.createQuickFix(this.myEditor, this.myComponent)};
        }
        ErrorInfo errorInfo = new ErrorInfo(this.myComponent, prop == null ? null : prop.getName(), errorMessage, this.myProfile.getErrorLevel(HighlightDisplayKey.find((String)inspectionId), (PsiElement)this.myFormPsiFile), quickFixes);
        errorInfo.setInspectionId(inspectionId);
        this.myResults.add(errorInfo);
    }
}

