/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant;

import com.intellij.lang.CompositeLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFilter;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.ant.AntFileType;
import com.intellij.lang.ant.AntLanguage;
import com.intellij.lang.ant.AntLanguageExtension;
import com.intellij.lang.ant.ForcedAntFileAttribute;
import com.intellij.lang.ant.psi.AntFile;
import com.intellij.lang.ant.psi.changes.AntChangeVisitor;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntSupport
implements ApplicationComponent {
    private static LanguageFileType ourFileType = null;
    private static AntLanguage ourLanguage = null;
    private static AntChangeVisitor ourChangeVisitor = null;
    private static final Map<AntFile, WeakHashMap<AntFile, Boolean>> ourFileDependencies = new WeakHashMap<AntFile, WeakHashMap<AntFile, Boolean>>();

    public AntSupport(FileTypeManager fileTypeManager) {
        fileTypeManager.getRegisteredFileTypes();
        ((CompositeLanguage)StdLanguages.XML).registerLanguageExtension((LanguageFilter)new AntLanguageExtension());
    }

    public static synchronized AntLanguage getLanguage() {
        if (ourLanguage == null) {
            if (ourFileType == null) {
                ourFileType = new AntFileType();
            }
            ourLanguage = (AntLanguage)ourFileType.getLanguage();
        }
        return ourLanguage;
    }

    public static synchronized AntChangeVisitor getChangeVisitor() {
        if (ourChangeVisitor == null) {
            ourChangeVisitor = new AntChangeVisitor();
        }
        return ourChangeVisitor;
    }

    @NotNull
    @NonNls
    public String getComponentName() {
        if ("AntSupport" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/ant/AntSupport.getComponentName must not return null");
        }
        return "AntSupport";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public static void markFileAsAntFile(VirtualFile file, FileViewProvider viewProvider, boolean value) {
        if (file.isValid() && ForcedAntFileAttribute.isAntFile(file) != value) {
            ForcedAntFileAttribute.forceAntFile(file, value);
            viewProvider.contentsSynchronized();
        }
    }

    public static synchronized List<AntFile> getImportingFiles(AntFile imported) {
        int size;
        WeakHashMap<AntFile, Boolean> files = ourFileDependencies.get(imported);
        if (files != null && (size = files.size()) > 0) {
            ArrayList<AntFile> result = new ArrayList<AntFile>(size);
            for (AntFile file : files.keySet()) {
                if (file == null) continue;
                result.add(file);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static synchronized void registerDependency(AntFile importing, AntFile imported) {
        Map<AntFile, WeakHashMap<AntFile, Boolean>> dependencies = ourFileDependencies;
        WeakHashMap<AntFile, Boolean> files = dependencies.get(imported);
        if (files == null) {
            files = new WeakHashMap();
            dependencies.put(imported, files);
        }
        files.put(importing, true);
    }

    public static AntFile getAntFile(PsiFile psiFile) {
        if (psiFile instanceof AntFile) {
            return (AntFile)psiFile;
        }
        return (AntFile)psiFile.getViewProvider().getPsi((Language)AntSupport.getLanguage());
    }

    @Nullable
    public static AntFile toAntFile(VirtualFile vFile, Project project) {
        if (vFile == null) {
            return null;
        }
        FileType fileType = vFile.getFileType();
        if (fileType instanceof AntFileType || XMLLanguage.INSTANCE.getAssociatedFileType() == fileType) {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(vFile);
            return psiFile != null ? AntSupport.getAntFile(psiFile) : null;
        }
        return null;
    }
}

