/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl.artifacts;

import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.AntBuildListener;
import com.intellij.lang.ant.config.AntBuildModel;
import com.intellij.lang.ant.config.AntBuildTarget;
import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.lang.ant.config.impl.AntConfigurationImpl;
import com.intellij.lang.ant.config.impl.artifacts.AntArtifactPropertiesEditor;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.ArtifactPropertiesEditor;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntArtifactProperties
extends ArtifactProperties<AntArtifactProperties> {
    private String myFileUrl;
    private String myTargetName;
    private boolean myEnabled;
    private boolean myPostProcessing;

    public AntArtifactProperties() {
    }

    public AntArtifactProperties(boolean postProcessing) {
        this.myPostProcessing = postProcessing;
    }

    public ArtifactPropertiesEditor createEditor(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/config/impl/artifacts/AntArtifactProperties.createEditor must not be null");
        }
        return new AntArtifactPropertiesEditor(this, context.getProject(), this.myPostProcessing);
    }

    public AntArtifactProperties getState() {
        return this;
    }

    public void onBuildStarted(@NotNull Artifact artifact, @NotNull CompileContext compileContext) {
        if (artifact == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/config/impl/artifacts/AntArtifactProperties.onBuildStarted must not be null");
        }
        if (compileContext == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/ant/config/impl/artifacts/AntArtifactProperties.onBuildStarted must not be null");
        }
        if (!this.myPostProcessing) {
            this.runAntTarget(compileContext, artifact);
        }
    }

    public void onBuildFinished(@NotNull Artifact artifact, @NotNull CompileContext compileContext) {
        if (artifact == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/config/impl/artifacts/AntArtifactProperties.onBuildFinished must not be null");
        }
        if (compileContext == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/ant/config/impl/artifacts/AntArtifactProperties.onBuildFinished must not be null");
        }
        if (this.myPostProcessing) {
            this.runAntTarget(compileContext, artifact);
        }
    }

    private void runAntTarget(CompileContext compileContext, Artifact artifact) {
        Project project;
        AntBuildTarget target;
        if (this.myEnabled && (target = this.findTarget(AntConfiguration.getInstance(project = compileContext.getProject()))) != null) {
            final DataContext dataContext = SimpleDataContext.getProjectContext((Project)project);
            if (!this.myPostProcessing) {
                boolean success = AntConfigurationImpl.executeTargetSynchronously(dataContext, target);
                if (!success) {
                    compileContext.addMessage(CompilerMessageCategory.ERROR, "Cannot build artifact '" + artifact.getName() + "': ant target '" + target.getDisplayName() + "' failed with error", null, -1, -1);
                }
                return;
            }
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    target.run(dataContext, AntBuildListener.NULL);
                }
            });
        }
    }

    public void loadState(AntArtifactProperties state) {
        XmlSerializerUtil.copyBean((Object)((Object)state), (Object)((Object)this));
    }

    @Tag(value="file")
    public String getFileUrl() {
        return this.myFileUrl;
    }

    @Tag(value="target")
    public String getTargetName() {
        return this.myTargetName;
    }

    @Attribute(value="enabled")
    public boolean isEnabled() {
        return this.myEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    public void setFileUrl(String fileUrl) {
        this.myFileUrl = fileUrl;
    }

    public void setTargetName(String targetName) {
        this.myTargetName = targetName;
    }

    @Nullable
    public AntBuildTarget findTarget(AntConfiguration antConfiguration) {
        AntBuildFile[] buildFiles;
        if (this.myFileUrl == null || this.myTargetName == null) {
            return null;
        }
        for (AntBuildFile buildFile : buildFiles = antConfiguration.getBuildFiles()) {
            VirtualFile file = buildFile.getVirtualFile();
            if (file == null || !file.getUrl().equals(this.myFileUrl)) continue;
            AntBuildModel buildModel = buildFile.getModel();
            return buildModel != null ? buildModel.findTarget(this.myTargetName) : null;
        }
        return null;
    }
}

