/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.impl;

import com.intellij.lang.ant.psi.AntAnt;
import com.intellij.lang.ant.psi.AntElement;
import com.intellij.lang.ant.psi.impl.AntTaskImpl;
import com.intellij.lang.ant.psi.impl.reference.AntTargetReference;
import com.intellij.lang.ant.psi.introspection.AntTypeDefinition;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.StringBuilderSpinAllocator;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntAntImpl
extends AntTaskImpl
implements AntAnt {
    @NonNls
    private static final String DEFAULT_ANTFILE = "build.xml";

    public AntAntImpl(AntElement parent, XmlTag sourceElement, AntTypeDefinition definition) {
        super(parent, sourceElement, definition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        try {
            builder.append("Ant[");
            builder.append(this.getFileName());
            builder.append("]");
            String string = builder.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    @Override
    @NotNull
    public List<String> getFileReferenceAttributes() {
        ArrayList<String> attribs = new ArrayList<String>(super.getFileReferenceAttributes());
        attribs.add("antfile");
        attribs.add("output");
        ArrayList<String> arrayList = attribs;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntAntImpl.getFileReferenceAttributes must not return null");
        }
        return arrayList;
    }

    @Override
    @Nullable
    public PsiFile getCalledAntFile() {
        return this.findFileByName(this.getFileName(), this.getDir());
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] result;
        for (PsiReference reference : result = super.getReferences()) {
            if (!(reference instanceof AntTargetReference)) continue;
            ((AntTargetReference)reference).setShouldBeSkippedByAnnotator(this.getCalledAntFile() == null);
        }
        if (result == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntAntImpl.getReferences must not return null");
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private String getFileName() {
        String result = this.getSourceElement().getAttributeValue("antfile");
        if (result == null) {
            return DEFAULT_ANTFILE;
        }
        String string = result;
        String string2 = string;
        if (string == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntAntImpl.getFileName must not return null");
        return string2;
    }

    @Nullable
    private String getDir() {
        return this.getSourceElement().getAttributeValue("dir");
    }
}

