/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.validation;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.psi.AntFile;
import com.intellij.lang.ant.psi.AntProject;
import com.intellij.lang.ant.psi.AntProperty;
import com.intellij.lang.ant.psi.AntStructuredElement;
import com.intellij.lang.ant.validation.AntInspection;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntMissingPropertiesFileInspection
extends AntInspection {
    @NonNls
    private static final String SHORT_NAME = "AntMissingPropertiesFileInspection";

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = AntBundle.message("ant.missing.properties.file.inspection", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/ant/validation/AntMissingPropertiesFileInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/ant/validation/AntMissingPropertiesFileInspection.getShortName must not return null");
        }
        return SHORT_NAME;
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        AntProject project;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/validation/AntMissingPropertiesFileInspection.checkFile must not be null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/ant/validation/AntMissingPropertiesFileInspection.checkFile must not be null");
        }
        if (file instanceof AntFile && (project = ((AntFile)file).getAntProject()) != null) {
            ArrayList<ProblemDescriptor> problems = new ArrayList<ProblemDescriptor>();
            AntMissingPropertiesFileInspection.checkElement(project, manager, problems, isOnTheFly);
            int problemCount = problems.size();
            if (problemCount > 0) {
                return problems.toArray(new ProblemDescriptor[problemCount]);
            }
        }
        return null;
    }

    private static void checkElement(AntStructuredElement tag, @NotNull InspectionManager manager, List<ProblemDescriptor> problems, boolean isOnTheFly) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/ant/validation/AntMissingPropertiesFileInspection.checkElement must not be null");
        }
        for (PsiElement element : tag.getChildren()) {
            if (element instanceof AntProperty) {
                String filename;
                AntProperty prop = (AntProperty)element;
                if (!"property".equals(prop.getSourceElement().getName()) || (filename = prop.getFileName()) == null || prop.getPropertiesFile() != null) continue;
                problems.add(manager.createProblemDescriptor((PsiElement)prop, AntBundle.message("file.doesnt.exist", filename), isOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                continue;
            }
            if (!(element instanceof AntStructuredElement)) continue;
            AntMissingPropertiesFileInspection.checkElement((AntStructuredElement)element, manager, problems, isOnTheFly);
        }
    }
}

