/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.references;

import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.references.MavenPropertyPsiReference;
import org.jetbrains.idea.maven.project.MavenProject;

public class MavenFilteredPropertyPsiReference
extends MavenPropertyPsiReference {
    public MavenFilteredPropertyPsiReference(MavenProject mavenProject, PsiElement element, String text, TextRange range, boolean isSoft) {
        super(mavenProject, element, text, range, isSoft);
    }

    @Override
    protected PsiElement doResolve() {
        PsiElement result = super.doResolve();
        if (result != null) {
            return result;
        }
        for (String each : this.myMavenProject.getFilters()) {
            Property property;
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(each);
            if (file == null || (property = MavenDomUtil.findProperty(this.myProject, file, this.myText)) == null) continue;
            return property;
        }
        return null;
    }

    @Override
    protected void collectVariants(List<Object> result) {
        super.collectVariants(result);
        for (String each : this.myMavenProject.getFilters()) {
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(each);
            if (file == null) continue;
            this.collectPropertiesFileVariants(MavenDomUtil.getPropertiesFile(this.myProject, file), "", result);
        }
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        String newText = this.myRange.replace(this.myElement.getText(), newElementName);
        PsiFile psiFile = this.myElement.getContainingFile();
        String newFileText = this.myElement.getTextRange().replace(psiFile.getText(), newText);
        PsiFile f = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText("__" + psiFile.getName(), psiFile.getLanguage(), (CharSequence)newFileText);
        PsiElement el = f.findElementAt(this.myElement.getTextOffset());
        return this.myElement.replace(el);
    }
}

