/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.references;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public abstract class MavenPsiReference
implements PsiReference {
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final MavenProjectsManager myProjectsManager;
    @NotNull
    protected final PsiFile myPsiFile;
    @NotNull
    protected final VirtualFile myVirtualFile;
    @NotNull
    protected final PsiElement myElement;
    @NotNull
    protected final String myText;
    @NotNull
    protected final TextRange myRange;

    public MavenPsiReference(@NotNull PsiElement element, @NotNull String text, @NotNull TextRange range) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/references/MavenPsiReference.<init> must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/dom/references/MavenPsiReference.<init> must not be null");
        }
        if (range == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/idea/maven/dom/references/MavenPsiReference.<init> must not be null");
        }
        this.myProject = element.getProject();
        this.myProjectsManager = MavenProjectsManager.getInstance(this.myProject);
        this.myPsiFile = element.getContainingFile().getOriginalFile();
        this.myVirtualFile = this.myPsiFile.getVirtualFile();
        this.myElement = element;
        this.myText = text;
        this.myRange = range;
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    public String getCanonicalText() {
        return this.myText;
    }

    public TextRange getRangeInElement() {
        return this.myRange;
    }

    public boolean isReferenceTo(PsiElement element) {
        return this.getElement().getManager().areElementsEquivalent(element, this.resolve());
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return null;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/references/MavenPsiReference.bindToElement must not be null");
        }
        return null;
    }

    public boolean isSoft() {
        return true;
    }
}

