/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentEnumerator;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.PersistentStringEnumerator;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.wagon.events.TransferEvent;
import org.jetbrains.idea.maven.embedder.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.indices.IndicesBundle;
import org.jetbrains.idea.maven.indices.MavenIndexException;
import org.jetbrains.idea.maven.indices.MavenIndexFetcher;
import org.jetbrains.idea.maven.indices.MavenIndices;
import org.jetbrains.idea.maven.project.TransferListenerAdapter;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.sonatype.nexus.index.ArtifactContext;
import org.sonatype.nexus.index.ArtifactContextProducer;
import org.sonatype.nexus.index.ArtifactInfo;
import org.sonatype.nexus.index.ArtifactScanningListener;
import org.sonatype.nexus.index.NexusIndexer;
import org.sonatype.nexus.index.ScanningResult;
import org.sonatype.nexus.index.context.IndexUtils;
import org.sonatype.nexus.index.context.IndexingContext;
import org.sonatype.nexus.index.context.UnsupportedExistingLuceneIndexException;
import org.sonatype.nexus.index.updater.IndexUpdateRequest;
import org.sonatype.nexus.index.updater.IndexUpdater;
import org.sonatype.nexus.index.updater.ResourceFetcher;

public class MavenIndex {
    private static final String CURRENT_VERSION = "4";
    protected static final String INDEX_INFO_FILE = "index.properties";
    private static final String INDEX_VERSION_KEY = "version";
    private static final String KIND_KEY = "kind";
    private static final String ID_KEY = "id";
    private static final String PATH_OR_URL_KEY = "pathOrUrl";
    private static final String TIMESTAMP_KEY = "lastUpdate";
    private static final String DATA_DIR_NAME_KEY = "dataDirName";
    private static final String FAILURE_MESSAGE_KEY = "failureMessage";
    private static final String UPDATE_DIR = "update";
    private static final String DATA_DIR_PREFIX = "data";
    private static final String GROUP_IDS_FILE = "groupIds.dat";
    private static final String ARTIFACT_IDS_FILE = "artifactIds.dat";
    private static final String VERSIONS_FILE = "versions.dat";
    private static final String ARTIFACT_IDS_MAP_FILE = "artifactIds-map.dat";
    private static final String VERSIONS_MAP_FILE = "versions-map.dat";
    private final NexusIndexer myIndexer;
    private final ArtifactContextProducer myArtifactContextProducer;
    private final File myDir;
    private final String myRepositoryId;
    private final String myRepositoryPathOrUrl;
    private final Kind myKind;
    private volatile Long myUpdateTimestamp;
    private volatile String myDataDirName;
    private volatile IndexData myData;
    private volatile String myFailureMessage;
    private volatile boolean isBroken;
    private final IndexListener myListener;

    public MavenIndex(NexusIndexer indexer, ArtifactContextProducer artifactContextProducer, File dir, String repositoryId, String repositoryPathOrUrl, Kind kind, IndexListener listener) throws MavenIndexException {
        this.myIndexer = indexer;
        this.myArtifactContextProducer = artifactContextProducer;
        this.myDir = dir;
        this.myRepositoryId = repositoryId;
        this.myRepositoryPathOrUrl = this.normalizePathOrUrl(repositoryPathOrUrl);
        this.myKind = kind;
        this.myListener = listener;
        this.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenIndex(NexusIndexer indexer, ArtifactContextProducer artifactContextProducer, File dir, IndexListener listener) throws MavenIndexException {
        this.myIndexer = indexer;
        this.myArtifactContextProducer = artifactContextProducer;
        this.myDir = dir;
        this.myListener = listener;
        Properties props = new Properties();
        try {
            FileInputStream s = new FileInputStream(new File(dir, INDEX_INFO_FILE));
            try {
                props.load(s);
            }
            finally {
                s.close();
            }
        }
        catch (IOException e) {
            throw new MavenIndexException("Cannot read index.properties file", e);
        }
        if (!CURRENT_VERSION.equals(props.getProperty(INDEX_VERSION_KEY))) {
            throw new MavenIndexException("Incompatible index version, needs to be updated: " + dir);
        }
        this.myKind = Kind.valueOf(props.getProperty(KIND_KEY));
        this.myRepositoryId = props.getProperty(ID_KEY);
        this.myRepositoryPathOrUrl = this.normalizePathOrUrl(props.getProperty(PATH_OR_URL_KEY));
        try {
            String timestamp = props.getProperty(TIMESTAMP_KEY);
            if (timestamp != null) {
                this.myUpdateTimestamp = Long.parseLong(timestamp);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.myDataDirName = props.getProperty(DATA_DIR_NAME_KEY);
        this.myFailureMessage = props.getProperty(FAILURE_MESSAGE_KEY);
        if (!this.getUpdateDir().exists()) {
            this.myUpdateTimestamp = null;
        }
        this.open();
    }

    private String normalizePathOrUrl(String pathOrUrl) {
        pathOrUrl = pathOrUrl.trim();
        pathOrUrl = FileUtil.toSystemIndependentName((String)pathOrUrl);
        while (pathOrUrl.endsWith("/")) {
            pathOrUrl = pathOrUrl.substring(0, pathOrUrl.length() - 1);
        }
        return pathOrUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open() throws MavenIndexException {
        try {
            try {
                this.doOpen();
            }
            catch (Exception e1) {
                MavenLog.LOG.info((Throwable)e1);
                try {
                    this.doOpen();
                }
                catch (Exception e2) {
                    throw new MavenIndexException("Cannot open index " + this.myDir.getPath(), e2);
                }
                this.isBroken = true;
            }
        }
        finally {
            this.save();
        }
    }

    private void doOpen() throws Exception {
        try {
            if (this.myDataDirName == null) {
                this.myDataDirName = this.findAvailableDataDirName();
            }
            this.myData = this.openData(this.myDataDirName);
        }
        catch (Exception e) {
            this.cleanupBrokenData();
            throw e;
        }
    }

    private void cleanupBrokenData() {
        this.close();
        FileUtil.delete((File)this.getCurrentDataDir());
        this.myDataDirName = null;
    }

    public synchronized void close() {
        try {
            if (this.myData != null) {
                this.myData.close();
            }
        }
        catch (IOException e) {
            MavenLog.LOG.warn((Throwable)e);
        }
        this.myData = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void save() {
        this.myDir.mkdirs();
        Properties props = new Properties();
        props.setProperty(KIND_KEY, this.myKind.toString());
        props.setProperty(ID_KEY, this.myRepositoryId);
        props.setProperty(PATH_OR_URL_KEY, this.myRepositoryPathOrUrl);
        props.setProperty(INDEX_VERSION_KEY, CURRENT_VERSION);
        if (this.myUpdateTimestamp != null) {
            props.setProperty(TIMESTAMP_KEY, String.valueOf(this.myUpdateTimestamp));
        }
        if (this.myDataDirName != null) {
            props.setProperty(DATA_DIR_NAME_KEY, this.myDataDirName);
        }
        if (this.myFailureMessage != null) {
            props.setProperty(FAILURE_MESSAGE_KEY, this.myFailureMessage);
        }
        try {
            FileOutputStream s = new FileOutputStream(new File(this.myDir, INDEX_INFO_FILE));
            try {
                props.store(s, null);
            }
            finally {
                s.close();
            }
        }
        catch (IOException e) {
            MavenLog.LOG.info((Throwable)e);
        }
    }

    public String getRepositoryId() {
        return this.myRepositoryId;
    }

    public File getRepositoryFile() {
        return this.myKind == Kind.LOCAL ? new File(this.myRepositoryPathOrUrl) : null;
    }

    public String getRepositoryUrl() {
        return this.myKind == Kind.REMOTE ? this.myRepositoryPathOrUrl : null;
    }

    public String getRepositoryPathOrUrl() {
        return this.myRepositoryPathOrUrl;
    }

    public Kind getKind() {
        return this.myKind;
    }

    public boolean isFor(Kind kind, String repositoryId, String pathOrUrl) {
        if (this.myKind != kind || !this.myRepositoryId.equals(repositoryId)) {
            return false;
        }
        if (kind == Kind.LOCAL) {
            return FileUtil.pathsEqual((String)this.myRepositoryPathOrUrl, (String)this.normalizePathOrUrl(pathOrUrl));
        }
        return this.myRepositoryPathOrUrl.equalsIgnoreCase(this.normalizePathOrUrl(pathOrUrl));
    }

    public synchronized long getUpdateTimestamp() {
        return this.myUpdateTimestamp == null ? -1L : this.myUpdateTimestamp;
    }

    public synchronized String getFailureMessage() {
        return this.myFailureMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOrRepair(MavenEmbedderWrapper embedderToUse, IndexUpdater updater, boolean fullUpdate, ProgressIndicator progress) {
        try {
            if (fullUpdate) {
                if (this.myKind == Kind.LOCAL) {
                    FileUtil.delete((File)this.getUpdateDir());
                }
                IndexingContext context = this.createContext(this.getUpdateDir(), UPDATE_DIR);
                try {
                    this.updateContext(embedderToUse, context, updater, progress);
                }
                finally {
                    this.myIndexer.removeIndexingContext(context, false);
                }
            }
            this.updateData(progress);
            this.isBroken = false;
            this.myFailureMessage = null;
        }
        catch (IOException e) {
            this.handleUpdateException(e);
        }
        catch (UnsupportedExistingLuceneIndexException e) {
            this.handleUpdateException((Exception)((Object)e));
        }
        this.save();
    }

    private void handleUpdateException(Exception e) {
        this.myFailureMessage = e.getMessage();
        MavenLog.LOG.info("Failed to update Maven indices for: [" + this.myRepositoryId + "] " + this.myRepositoryPathOrUrl, (Throwable)e);
    }

    private IndexingContext createContext(File contextDir, String suffix) throws IOException, UnsupportedExistingLuceneIndexException {
        String indexId = this.myDir.getName() + "-" + suffix;
        String repoId = contextDir.exists() ? null : this.myDir.getName();
        return this.myIndexer.addIndexingContext(indexId, repoId, this.getRepositoryFile(), contextDir, this.getRepositoryUrl(), null, NexusIndexer.FULL_INDEX);
    }

    private File getUpdateDir() {
        return new File(this.myDir, UPDATE_DIR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateContext(MavenEmbedderWrapper embedder, IndexingContext context, IndexUpdater updater, ProgressIndicator progress) throws IOException, UnsupportedExistingLuceneIndexException {
        if (Kind.LOCAL == this.myKind) {
            progress.setIndeterminate(true);
            try {
                this.myIndexer.scan(context, (ArtifactScanningListener)new MyScanningListener(), false);
            }
            finally {
                progress.setIndeterminate(false);
            }
        } else {
            IndexUpdateRequest request = new IndexUpdateRequest(context);
            request.setResourceFetcher((ResourceFetcher)new MavenIndexFetcher(this.myRepositoryId, this.getRepositoryUrl(), embedder.getComponent(WagonManager.class), new TransferListenerAdapter(new MavenProgressIndicator(progress)){

                @Override
                protected void doUpdateProgress(long downloaded, long total) {
                    super.doUpdateProgress(downloaded, total);
                    this.myIndicator.setFraction((double)downloaded / (double)total);
                }

                @Override
                public void transferCompleted(TransferEvent event) {
                    super.transferCompleted(event);
                    this.myIndicator.setText2(IndicesBundle.message("maven.indices.updating.processing", new Object[0]));
                }
            }));
            updater.fetchAndUpdateIndex(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateData(ProgressIndicator progress) throws IOException, UnsupportedExistingLuceneIndexException {
        String newDataDirName = this.findAvailableDataDirName();
        FileUtil.copyDir((File)this.getUpdateDir(), (File)this.getDataContextDir(this.getDataDir(newDataDirName)));
        IndexData newData = this.openData(newDataDirName);
        try {
            this.doUpdateIndexData(newData, progress);
            newData.flush();
        }
        catch (Throwable e) {
            newData.close();
            FileUtil.delete((File)this.getDataDir(newDataDirName));
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new RuntimeException(e);
        }
        MavenIndex mavenIndex = this;
        synchronized (mavenIndex) {
            IndexData oldData = this.myData;
            this.myData = newData;
            this.myDataDirName = newDataDirName;
            this.myUpdateTimestamp = System.currentTimeMillis();
            oldData.close();
            for (File each : this.getAllDataDirs()) {
                if (each.getName().equals(newDataDirName)) continue;
                FileUtil.delete((File)each);
            }
        }
    }

    private void doUpdateIndexData(IndexData data, ProgressIndicator progress) throws IOException {
        THashSet groups = new THashSet();
        THashSet groupsWithArtifacts = new THashSet();
        THashSet groupsWithArtifactsWithVersions = new THashSet();
        THashMap groupToArtifactMap = new THashMap();
        THashMap groupWithArtifactToVersionMap = new THashMap();
        IndexReader r = data.context.getIndexReader();
        int total = r.numDocs();
        for (int i = 0; i < total; ++i) {
            Document doc;
            String uinfo;
            progress.setFraction((double)(i / total));
            if (r.isDeleted(i) || (uinfo = (doc = r.document(i)).get("u")) == null) continue;
            List parts = StringUtil.split((String)uinfo, (String)"|");
            String groupId = (String)parts.get(0);
            String artifactId = (String)parts.get(1);
            String version = (String)parts.get(2);
            if (groupId == null || artifactId == null || version == null) continue;
            groups.add(groupId);
            groupsWithArtifacts.add(groupId + ":" + artifactId);
            groupsWithArtifactsWithVersions.add(groupId + ":" + artifactId + ":" + version);
            this.getOrCreate((Map)groupToArtifactMap, groupId).add(artifactId);
            this.getOrCreate((Map)groupWithArtifactToVersionMap, groupId + ":" + artifactId).add(version);
        }
        this.persist((Set<String>)groups, data.groups);
        this.persist((Set<String>)groupsWithArtifacts, data.groupsWithArtifacts);
        this.persist((Set<String>)groupsWithArtifactsWithVersions, data.groupsWithArtifactsWithVersions);
        this.persist((Map)groupToArtifactMap, (PersistentHashMap)data.groupToArtifactMap);
        this.persist((Map)groupWithArtifactToVersionMap, (PersistentHashMap)data.groupWithArtifactToVersionMap);
    }

    private <T> Set<T> getOrCreate(Map<String, Set<T>> map, String key) {
        THashSet result = map.get(key);
        if (result == null) {
            result = new THashSet();
            map.put(key, (Set<T>)result);
        }
        return result;
    }

    private <T> void persist(Map<String, T> map, PersistentHashMap<String, T> persistentMap) throws IOException {
        for (Map.Entry<String, T> each : map.entrySet()) {
            persistentMap.put((Object)each.getKey(), each.getValue());
        }
    }

    private void persist(Set<String> groups, PersistentStringEnumerator persistent) throws IOException {
        for (String each : groups) {
            persistent.enumerate((Object)each);
        }
    }

    private IndexData openData(String dataDir) throws IOException, UnsupportedExistingLuceneIndexException {
        File dir = this.getDataDir(dataDir);
        dir.mkdirs();
        return new IndexData(dir);
    }

    protected File getDir() {
        return this.myDir;
    }

    protected synchronized File getCurrentDataDir() {
        return this.getDataDir(this.myDataDirName);
    }

    private File getDataDir(String dataDirName) {
        return new File(this.myDir, dataDirName);
    }

    private File getDataContextDir(File dataDir) {
        return new File(dataDir, "context");
    }

    private String findAvailableDataDirName() {
        return MavenIndices.findAvailableDir(this.myDir, DATA_DIR_PREFIX, 100).getName();
    }

    private Iterable<File> getAllDataDirs() {
        Object[] children = this.myDir.listFiles();
        if (children == null) {
            return ContainerUtil.emptyIterable();
        }
        return ContainerUtil.iterate((Object[])children, (Condition)new Condition<File>(){

            public boolean value(File file) {
                return file.getName().startsWith(MavenIndex.DATA_DIR_PREFIX);
            }
        });
    }

    public synchronized void addArtifact(final File artifactFile) {
        this.doIndexTask(new IndexTask<Object>(){

            @Override
            public Object doTask() throws Exception {
                ArtifactContext artifactContext = MavenIndex.this.myArtifactContextProducer.getArtifactContext(((MavenIndex)MavenIndex.this).myData.context, artifactFile);
                if (artifactContext == null) {
                    return null;
                }
                MavenIndex.this.myIndexer.addArtifactToIndex(artifactContext, ((MavenIndex)MavenIndex.this).myData.context);
                ArtifactInfo artifactInfo = artifactContext.getArtifactInfo();
                String groupId = artifactInfo.groupId;
                String artifactId = artifactInfo.artifactId;
                String version = artifactInfo.version;
                if (groupId == null || artifactId == null || version == null) {
                    return null;
                }
                ((MavenIndex)MavenIndex.this).myData.groups.enumerate((Object)groupId);
                ((MavenIndex)MavenIndex.this).myData.hasGroupCache.put(groupId, true);
                String groupWithArtifact = groupId + ":" + artifactId;
                ((MavenIndex)MavenIndex.this).myData.groupsWithArtifacts.enumerate((Object)groupWithArtifact);
                ((MavenIndex)MavenIndex.this).myData.hasArtifactCache.put(groupWithArtifact, true);
                MavenIndex.this.addToCache((PersistentHashMap<String, Set<String>>)((MavenIndex)MavenIndex.this).myData.groupToArtifactMap, groupId, artifactId);
                String groupWithArtifactWithVersion = groupWithArtifact + ":" + version;
                ((MavenIndex)MavenIndex.this).myData.groupsWithArtifactsWithVersions.enumerate((Object)groupWithArtifactWithVersion);
                ((MavenIndex)MavenIndex.this).myData.hasVersionCache.put(groupWithArtifactWithVersion, true);
                MavenIndex.this.addToCache((PersistentHashMap<String, Set<String>>)((MavenIndex)MavenIndex.this).myData.groupWithArtifactToVersionMap, groupWithArtifact, version);
                MavenIndex.this.myData.flush();
                return null;
            }
        }, null);
    }

    private void addToCache(PersistentHashMap<String, Set<String>> cache, String key, String value) throws IOException {
        Set values = (Set)cache.get((Object)key);
        if (values == null) {
            values = new THashSet();
        }
        values.add(value);
        cache.put((Object)key, (Object)values);
    }

    public synchronized Set<String> getGroupIds() {
        return this.doIndexTask(new IndexTask<Set<String>>(){

            @Override
            public Set<String> doTask() throws Exception {
                THashSet result = new THashSet();
                ((MavenIndex)MavenIndex.this).myData.groups.traverseAllRecords(new PersistentEnumerator.RecordsProcessor((Set)result){
                    final /* synthetic */ Set val$result;
                    {
                        this.val$result = set;
                    }

                    public boolean process(int record) throws IOException {
                        this.val$result.add(((MavenIndex)MavenIndex.this).myData.groups.valueOf(record));
                        return true;
                    }
                });
                return result;
            }
        }, Collections.emptySet());
    }

    public synchronized Set<String> getArtifactIds(final String groupId) {
        return this.doIndexTask(new IndexTask<Set<String>>(){

            @Override
            public Set<String> doTask() throws Exception {
                Set result = (Set)((MavenIndex)MavenIndex.this).myData.groupToArtifactMap.get((Object)groupId);
                return result == null ? Collections.emptySet() : result;
            }
        }, Collections.emptySet());
    }

    public synchronized Set<String> getVersions(final String groupId, final String artifactId) {
        return this.doIndexTask(new IndexTask<Set<String>>(){

            @Override
            public Set<String> doTask() throws Exception {
                Set result = (Set)((MavenIndex)MavenIndex.this).myData.groupWithArtifactToVersionMap.get((Object)(groupId + ":" + artifactId));
                return result == null ? Collections.emptySet() : result;
            }
        }, Collections.emptySet());
    }

    public synchronized boolean hasGroupId(String groupId) {
        return this.hasValue(this.myData.groups, this.myData.hasGroupCache, groupId);
    }

    public synchronized boolean hasArtifactId(String groupId, String artifactId) {
        return this.hasValue(this.myData.groupsWithArtifacts, this.myData.hasArtifactCache, groupId + ":" + artifactId);
    }

    public synchronized boolean hasVersion(String groupId, String artifactId, String version) {
        return this.hasValue(this.myData.groupsWithArtifactsWithVersions, this.myData.hasVersionCache, groupId + ":" + artifactId + ":" + version);
    }

    private boolean hasValue(final PersistentStringEnumerator set, Map<String, Boolean> cache, final String value) {
        Boolean cached = cache.get(value);
        if (cached != null) {
            return cached;
        }
        boolean result = this.doIndexTask(new IndexTask<Boolean>(){

            @Override
            public Boolean doTask() throws Exception {
                return !set.traverseAllRecords(new PersistentEnumerator.RecordsProcessor(){

                    public boolean process(int record) throws IOException {
                        return !value.equals(set.valueOf(record));
                    }
                });
            }
        }, false);
        cache.put(value, result);
        return result;
    }

    public synchronized Set<ArtifactInfo> search(final Query query, final int maxResult) {
        return this.doIndexTask(new IndexTask<Set<ArtifactInfo>>(){

            @Override
            public Set<ArtifactInfo> doTask() throws Exception {
                TopDocs docs = null;
                try {
                    BooleanQuery.setMaxClauseCount((int)Integer.MAX_VALUE);
                    docs = ((MavenIndex)MavenIndex.this).myData.context.getIndexSearcher().search(query, (Filter)null, maxResult);
                }
                catch (BooleanQuery.TooManyClauses ignore) {
                    // empty catch block
                }
                if (docs.scoreDocs.length == 0) {
                    return Collections.emptySet();
                }
                THashSet result = new THashSet();
                for (int i = 0; i < docs.scoreDocs.length; ++i) {
                    int docIndex = docs.scoreDocs[i].doc;
                    Document doc = ((MavenIndex)MavenIndex.this).myData.context.getIndexReader().document(docIndex);
                    ArtifactInfo artifactInfo = IndexUtils.constructArtifactInfo((Document)doc, (IndexingContext)((MavenIndex)MavenIndex.this).myData.context);
                    if (artifactInfo == null) continue;
                    artifactInfo.repository = MavenIndex.this.myRepositoryPathOrUrl;
                    result.add(artifactInfo);
                }
                return result;
            }
        }, Collections.emptySet());
    }

    private <T> T doIndexTask(IndexTask<T> task, T defaultValue) {
        assert (Thread.holdsLock(this));
        if (!this.isBroken) {
            try {
                return task.doTask();
            }
            catch (Exception e1) {
                MavenLog.LOG.warn((Throwable)e1);
                this.cleanupBrokenData();
                try {
                    this.open();
                }
                catch (MavenIndexException e2) {
                    MavenLog.LOG.warn((Throwable)e2);
                }
            }
        }
        this.isBroken = true;
        this.myListener.indexIsBroken(this);
        return defaultValue;
    }

    public static interface IndexListener {
        public void indexIsBroken(MavenIndex var1);
    }

    private static class MyScanningListener
    implements ArtifactScanningListener {
        private final ProgressIndicator p;

        public MyScanningListener() {
            ProgressIndicator p = ProgressManager.getInstance().getProgressIndicator();
            if (p == null) {
                p = new EmptyProgressIndicator();
            }
            this.p = p;
        }

        public void scanningStarted(IndexingContext ctx) {
            this.p.checkCanceled();
        }

        public void scanningFinished(IndexingContext ctx, ScanningResult result) {
            this.p.checkCanceled();
        }

        public void artifactError(ArtifactContext ac, Exception e) {
        }

        public void artifactDiscovered(ArtifactContext ac) {
            this.p.checkCanceled();
            ArtifactInfo info = ac.getArtifactInfo();
            String artifact = info.groupId + ":" + info.artifactId + ":" + info.version;
            this.p.setText2(artifact);
        }
    }

    private static class SetDescriptor
    implements DataExternalizer<Set<String>> {
        private SetDescriptor() {
        }

        public void save(DataOutput s, Set<String> set) throws IOException {
            s.writeInt(set.size());
            for (String each : set) {
                s.writeUTF(each);
            }
        }

        public Set<String> read(DataInput s) throws IOException {
            int count = s.readInt();
            THashSet result = new THashSet(count);
            while (count-- > 0) {
                result.add(s.readUTF());
            }
            return result;
        }
    }

    private class IndexData {
        final PersistentStringEnumerator groups;
        final PersistentStringEnumerator groupsWithArtifacts;
        final PersistentStringEnumerator groupsWithArtifactsWithVersions;
        final PersistentHashMap<String, Set<String>> groupToArtifactMap;
        final PersistentHashMap<String, Set<String>> groupWithArtifactToVersionMap;
        final Map<String, Boolean> hasGroupCache = new THashMap();
        final Map<String, Boolean> hasArtifactCache = new THashMap();
        final Map<String, Boolean> hasVersionCache = new THashMap();
        final IndexingContext context;

        public IndexData(File dir) throws IOException, UnsupportedExistingLuceneIndexException {
            try {
                this.groups = new PersistentStringEnumerator(new File(dir, MavenIndex.GROUP_IDS_FILE));
                this.groupsWithArtifacts = new PersistentStringEnumerator(new File(dir, MavenIndex.ARTIFACT_IDS_FILE));
                this.groupsWithArtifactsWithVersions = new PersistentStringEnumerator(new File(dir, MavenIndex.VERSIONS_FILE));
                this.groupToArtifactMap = this.createPersistentMap(new File(dir, MavenIndex.ARTIFACT_IDS_MAP_FILE));
                this.groupWithArtifactToVersionMap = this.createPersistentMap(new File(dir, MavenIndex.VERSIONS_MAP_FILE));
                this.context = MavenIndex.this.createContext(MavenIndex.this.getDataContextDir(dir), dir.getName());
            }
            catch (IOException e) {
                this.close();
                throw e;
            }
            catch (UnsupportedExistingLuceneIndexException e) {
                this.close();
                throw e;
            }
        }

        private PersistentHashMap<String, Set<String>> createPersistentMap(File f) throws IOException {
            return new PersistentHashMap(f, (KeyDescriptor)new EnumeratorStringDescriptor(), (DataExternalizer)new SetDescriptor());
        }

        public void close() throws IOException {
            IOException[] exceptions;
            block4: {
                exceptions = new IOException[1];
                try {
                    if (this.context != null) {
                        MavenIndex.this.myIndexer.removeIndexingContext(this.context, false);
                    }
                }
                catch (IOException e) {
                    MavenLog.LOG.info((Throwable)e);
                    if (exceptions[0] != null) break block4;
                    exceptions[0] = e;
                }
            }
            this.safeClose((PersistentEnumerator)this.groups, exceptions);
            this.safeClose((PersistentEnumerator)this.groupsWithArtifacts, exceptions);
            this.safeClose((PersistentEnumerator)this.groupsWithArtifactsWithVersions, exceptions);
            this.safeClose((PersistentEnumerator)this.groupToArtifactMap, exceptions);
            this.safeClose((PersistentEnumerator)this.groupWithArtifactToVersionMap, exceptions);
            if (exceptions[0] != null) {
                throw exceptions[0];
            }
        }

        private void safeClose(PersistentEnumerator enumerator, IOException[] exceptions) throws IOException {
            block3: {
                try {
                    if (enumerator != null) {
                        enumerator.close();
                    }
                }
                catch (IOException e) {
                    MavenLog.LOG.info((Throwable)e);
                    if (exceptions[0] != null) break block3;
                    exceptions[0] = e;
                }
            }
        }

        public void flush() throws IOException {
            this.groups.force();
            this.groupsWithArtifacts.force();
            this.groupsWithArtifactsWithVersions.force();
            this.groupToArtifactMap.force();
            this.groupWithArtifactToVersionMap.force();
        }
    }

    private static interface IndexTask<T> {
        public T doTask() throws Exception;
    }

    public static enum Kind {
        LOCAL,
        REMOTE;

    }
}

