/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.wizards;

import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.xml.XmlElement;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomModule;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.indices.ArchetypeInfo;
import org.jetbrains.idea.maven.project.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenModuleBuilderHelper {
    private MavenId myProjectId;
    private MavenProject myAggregatorProject;
    private MavenProject myParentProject;
    private boolean myInheritGroupId;
    private boolean myInheritVersion;
    private ArchetypeInfo myArchetype;
    private String myCommandName;

    public MavenModuleBuilderHelper(MavenId projectId, MavenProject aggregatorProject, MavenProject parentProject, boolean inheritGroupId, boolean inheritVersion, ArchetypeInfo archetype, String commaneName) {
        this.myProjectId = projectId;
        this.myAggregatorProject = aggregatorProject;
        this.myParentProject = parentProject;
        this.myInheritGroupId = inheritGroupId;
        this.myInheritVersion = inheritVersion;
        this.myArchetype = archetype;
        this.myCommandName = commaneName;
    }

    public void configure(final Project project, final VirtualFile root, final boolean isInteractive) {
        PsiFile[] psiFileArray;
        if (this.myAggregatorProject != null) {
            PsiFile[] psiFileArray2 = new PsiFile[1];
            psiFileArray = psiFileArray2;
            psiFileArray2[0] = this.getPsiFile(project, this.myAggregatorProject.getFile());
        } else {
            psiFileArray = PsiFile.EMPTY_ARRAY;
        }
        PsiFile[] psiFiles = psiFileArray;
        final VirtualFile pom = (VirtualFile)new WriteCommandAction<VirtualFile>(project, this.myCommandName, psiFiles){

            protected void run(Result<VirtualFile> result) throws Throwable {
                VirtualFile file;
                try {
                    file = root.createChildData((Object)this, "pom.xml");
                    MavenUtil.runOrApplyMavenProjectFileTemplate(project, file, MavenModuleBuilderHelper.this.myProjectId, null, isInteractive);
                    result.setResult((Object)file);
                }
                catch (IOException e) {
                    MavenModuleBuilderHelper.this.showError(project, e);
                    return;
                }
                MavenModuleBuilderHelper.this.updateProjectPom(project, file);
                if (MavenModuleBuilderHelper.this.myAggregatorProject != null) {
                    MavenDomProjectModel model = MavenDomUtil.getMavenDomProjectModel(project, MavenModuleBuilderHelper.this.myAggregatorProject.getFile());
                    model.getPackaging().setStringValue("pom");
                    MavenDomModule module = model.getModules().addModule();
                    module.setValue(MavenModuleBuilderHelper.this.getPsiFile(project, file));
                }
            }
        }.execute().getResultObject();
        if (pom == null) {
            return;
        }
        if (this.myAggregatorProject == null) {
            MavenProjectsManager manager = MavenProjectsManager.getInstance(project);
            manager.addManagedFiles(Collections.singletonList(pom));
        }
        if (this.myArchetype == null) {
            try {
                VfsUtil.createDirectories((String)(root.getPath() + "/src/main/java"));
                VfsUtil.createDirectories((String)(root.getPath() + "/src/test/java"));
            }
            catch (IOException e) {
                MavenLog.LOG.info((Throwable)e);
            }
        }
        MavenUtil.invokeLater(project, ModalityState.NON_MODAL, new Runnable(){

            @Override
            public void run() {
                EditorHelper.openInEditor((PsiElement)MavenModuleBuilderHelper.this.getPsiFile(project, pom));
                if (MavenModuleBuilderHelper.this.myArchetype != null) {
                    MavenModuleBuilderHelper.this.generateFromArchetype(project, pom);
                }
            }
        });
    }

    private void updateProjectPom(final Project project, final VirtualFile pom) {
        if (this.myParentProject == null) {
            return;
        }
        new WriteCommandAction.Simple(project, this.myCommandName, new PsiFile[0]){

            protected void run() throws Throwable {
                XmlElement el;
                MavenDomProjectModel model = MavenDomUtil.getMavenDomProjectModel(project, pom);
                if (model == null) {
                    return;
                }
                MavenDomUtil.updateMavenParent(model, MavenModuleBuilderHelper.this.myParentProject);
                if (MavenModuleBuilderHelper.this.myInheritGroupId && (el = model.getGroupId().getXmlElement()) != null) {
                    el.delete();
                }
                if (MavenModuleBuilderHelper.this.myInheritVersion && (el = model.getVersion().getXmlElement()) != null) {
                    el.delete();
                }
                CodeStyleManager.getInstance((Project)project).reformat((PsiElement)MavenModuleBuilderHelper.this.getPsiFile(project, pom));
            }
        }.execute();
    }

    private PsiFile getPsiFile(Project project, VirtualFile pom) {
        return PsiManager.getInstance((Project)project).findFile(pom);
    }

    private void generateFromArchetype(final Project project, final VirtualFile pom) {
        File workingDir;
        try {
            workingDir = FileUtil.createTempDirectory((String)"archetype", (String)"tmp");
            workingDir.deleteOnExit();
        }
        catch (IOException e) {
            this.showError(project, e);
            return;
        }
        MavenRunnerParameters params = new MavenRunnerParameters(false, workingDir.getPath(), Collections.singletonList("org.apache.maven.plugins:maven-archetype-plugin:RELEASE:generate"), null);
        MavenRunner runner = MavenRunner.getInstance(project);
        MavenRunnerSettings settings = runner.getState().clone();
        Map<String, String> props = settings.getMavenProperties();
        props.put("interactiveMode", "false");
        props.put("archetypeGroupId", this.myArchetype.groupId);
        props.put("archetypeArtifactId", this.myArchetype.artifactId);
        props.put("archetypeVersion", this.myArchetype.version);
        if (this.myArchetype.repository != null) {
            props.put("archetypeRepository", this.myArchetype.repository);
        }
        props.put("groupId", this.myProjectId.getGroupId());
        props.put("artifactId", this.myProjectId.getArtifactId());
        props.put("version", this.myProjectId.getVersion());
        runner.run(params, settings, new Runnable(){

            @Override
            public void run() {
                MavenModuleBuilderHelper.this.copyGeneratedFiles(workingDir, pom, project);
            }
        });
    }

    private void copyGeneratedFiles(File workingDir, VirtualFile pom, Project project) {
        try {
            FileUtil.copyDir((File)new File(workingDir, this.myProjectId.getArtifactId()), (File)new File(pom.getParent().getPath()));
        }
        catch (IOException e) {
            this.showError(project, e);
            return;
        }
        FileUtil.delete((File)workingDir);
        pom.refresh(false, false);
        this.updateProjectPom(project, pom);
        LocalFileSystem.getInstance().refreshWithoutFileWatcher(true);
    }

    private void showError(Project project, Throwable e) {
        MavenUtil.showError(project, "Failed to create a Maven project", e);
    }
}

