/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiTypeElement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.abstraction.ConcreteClassUtil;
import org.jetbrains.annotations.NotNull;

public class LocalVariableOfConcreteClassInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("local.variable.of.concrete.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/abstraction/LocalVariableOfConcreteClassInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... arg) {
        PsiNamedElement variable = (PsiNamedElement)arg[0];
        String name = variable.getName();
        String string = InspectionGadgetsBundle.message("local.variable.of.concrete.class.problem.descriptor", name);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/abstraction/LocalVariableOfConcreteClassInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LocalVariableOfConcreteClassVisitor();
    }

    private static class LocalVariableOfConcreteClassVisitor
    extends BaseInspectionVisitor {
        private LocalVariableOfConcreteClassVisitor() {
        }

        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            if (variable == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/abstraction/LocalVariableOfConcreteClassInspection$LocalVariableOfConcreteClassVisitor.visitLocalVariable must not be null");
            }
            super.visitLocalVariable(variable);
            PsiTypeElement typeElement = variable.getTypeElement();
            if (!ConcreteClassUtil.typeIsConcreteClass(typeElement)) {
                return;
            }
            this.registerError((PsiElement)typeElement, variable);
        }
    }
}

