/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTypeElement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.abstraction.ConcreteClassUtil;
import org.jetbrains.annotations.NotNull;

public class ParameterOfConcreteClassInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("MethodParameterOfConcreteClass" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/abstraction/ParameterOfConcreteClassInspection.getID must not return null");
        }
        return "MethodParameterOfConcreteClass";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("concrete.class.method.parameter.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/abstraction/ParameterOfConcreteClassInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("concrete.class.method.parameter.problem.descriptor", infos);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/abstraction/ParameterOfConcreteClassInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ParameterOfConcreteClassVisitor();
    }

    private static class ParameterOfConcreteClassVisitor
    extends BaseInspectionVisitor {
        private ParameterOfConcreteClassVisitor() {
        }

        public void visitParameter(@NotNull PsiParameter parameter) {
            if (parameter == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/abstraction/ParameterOfConcreteClassInspection$ParameterOfConcreteClassVisitor.visitParameter must not be null");
            }
            super.visitParameter(parameter);
            if (parameter.getDeclarationScope() instanceof PsiCatchSection) {
                return;
            }
            PsiTypeElement typeElement = parameter.getTypeElement();
            if (!ConcreteClassUtil.typeIsConcreteClass(typeElement)) {
                return;
            }
            String variableName = parameter.getName();
            this.registerError((PsiElement)typeElement, variableName);
        }
    }
}

