/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class CovariantCompareToInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("covariant.compareto.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/CovariantCompareToInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("covariant.compareto.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/CovariantCompareToInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CovariantCompareToVisitor();
    }

    private static class CovariantCompareToVisitor
    extends BaseInspectionVisitor {
        private CovariantCompareToVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiType substituted;
            PsiSubstitutor superSubstitutor;
            PsiMethod[] methods;
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/CovariantCompareToInspection$CovariantCompareToVisitor.visitMethod must not be null");
            }
            String name = method.getName();
            if (!"compareTo".equals(name)) {
                return;
            }
            if (!method.hasModifierProperty("public")) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() != 1) {
                return;
            }
            PsiParameter[] parameters = parameterList.getParameters();
            PsiType paramType = parameters[0].getType();
            if (TypeUtils.isJavaLangObject(paramType)) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            for (PsiMethod compareToMethod : methods = aClass.findMethodsByName("compareTo", false)) {
                if (!CovariantCompareToVisitor.isNonVariantCompareTo(compareToMethod)) continue;
                return;
            }
            PsiManager manager = method.getManager();
            PsiClass comparableClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.lang.Comparable", method.getResolveScope());
            if (comparableClass != null && comparableClass.getTypeParameters().length == 1 && (superSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)comparableClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY)) != null && paramType.equals(substituted = superSubstitutor.substitute(comparableClass.getTypeParameters()[0]))) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private static boolean isNonVariantCompareTo(PsiMethod method) {
            PsiManager manager = method.getManager();
            Project project = method.getProject();
            PsiClassType objectType = PsiType.getJavaLangObject((PsiManager)manager, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
            return MethodUtils.methodMatches(method, null, PsiType.INT, "compareTo", new PsiType[]{objectType});
        }
    }
}

