/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.cloneable;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class CloneCallsConstructorsInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("clone.instantiates.objects.with.constructor.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/cloneable/CloneCallsConstructorsInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("clone.instantiates.objects.with.constructor.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/cloneable/CloneCallsConstructorsInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CloneCallsConstructorVisitor();
    }

    private static class CloneCallsConstructorVisitor
    extends BaseInspectionVisitor {
        private CloneCallsConstructorVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            boolean isClone;
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/cloneable/CloneCallsConstructorsInspection$CloneCallsConstructorVisitor.visitMethod must not be null");
            }
            String methodName = method.getName();
            PsiParameterList parameterList = method.getParameterList();
            boolean bl = isClone = "clone".equals(methodName) && parameterList.getParametersCount() == 0;
            if (isClone) {
                method.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                    public void visitNewExpression(@NotNull PsiNewExpression newExpression) {
                        if (newExpression == null) {
                            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/cloneable/CloneCallsConstructorsInspection$CloneCallsConstructorVisitor$1.visitNewExpression must not be null");
                        }
                        super.visitNewExpression(newExpression);
                        PsiExpression[] arrayDimensions = newExpression.getArrayDimensions();
                        if (arrayDimensions.length != 0) {
                            return;
                        }
                        if (newExpression.getArrayInitializer() != null) {
                            return;
                        }
                        if (newExpression.getAnonymousClass() != null) {
                            return;
                        }
                        if (PsiTreeUtil.getParentOfType((PsiElement)newExpression, PsiThrowStatement.class) != null) {
                            return;
                        }
                        CloneCallsConstructorVisitor.this.registerError((PsiElement)newExpression, new Object[0]);
                    }
                });
            }
        }
    }
}

