/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dataflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstantValueVariableUseInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("constant.value.variable.use.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/dataflow/ConstantValueVariableUseInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("constant.value.variable.use.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/dataflow/ConstantValueVariableUseInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiExpression expression = (PsiExpression)infos[0];
        return new ReplaceReferenceWithExpressionFix(expression);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantValueVariableUseVisitor();
    }

    private static class VariableUsedVisitor
    extends JavaRecursiveElementVisitor {
        private final PsiVariable variable;
        private boolean used = false;
        private PsiReferenceExpression reference = null;

        VariableUsedVisitor(PsiVariable variable) {
            this.variable = variable;
        }

        public void visitElement(PsiElement element) {
            if (this.used) {
                return;
            }
            super.visitElement(element);
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/dataflow/ConstantValueVariableUseInspection$VariableUsedVisitor.visitReferenceExpression must not be null");
            }
            if (this.used) {
                return;
            }
            super.visitReferenceExpression(expression);
            PsiElement referent = expression.resolve();
            if (referent == null) {
                return;
            }
            if (referent.equals(this.variable)) {
                this.reference = expression;
                this.used = true;
            }
        }

        public boolean isUsed() {
            return this.used;
        }

        public PsiReferenceExpression getReference() {
            return this.reference;
        }
    }

    private static class VariableReadVisitor
    extends JavaRecursiveElementVisitor {
        @NotNull
        private final PsiVariable variable;
        private boolean read;
        private boolean written;
        private PsiReferenceExpression reference;

        VariableReadVisitor(@NotNull PsiVariable variable) {
            if (variable == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/dataflow/ConstantValueVariableUseInspection$VariableReadVisitor.<init> must not be null");
            }
            this.read = false;
            this.written = false;
            this.reference = null;
            this.variable = variable;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/dataflow/ConstantValueVariableUseInspection$VariableReadVisitor.visitElement must not be null");
            }
            if (this.read || this.written) {
                return;
            }
            super.visitElement(element);
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression assignment) {
            PsiReferenceExpression referenceExpression;
            PsiElement target;
            if (assignment == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/dataflow/ConstantValueVariableUseInspection$VariableReadVisitor.visitAssignmentExpression must not be null");
            }
            if (this.read || this.written) {
                return;
            }
            super.visitAssignmentExpression(assignment);
            PsiExpression lhs = assignment.getLExpression();
            if (lhs instanceof PsiReferenceExpression && this.variable.equals(target = (referenceExpression = (PsiReferenceExpression)lhs).resolve())) {
                this.written = true;
                return;
            }
            PsiExpression rhs = assignment.getRExpression();
            if (rhs == null) {
                return;
            }
            VariableUsedVisitor visitor = new VariableUsedVisitor(this.variable);
            rhs.accept((PsiElementVisitor)visitor);
            this.read = visitor.isUsed();
            this.reference = visitor.getReference();
        }

        public void visitPrefixExpression(@NotNull PsiPrefixExpression prefixExpression) {
            if (prefixExpression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/dataflow/ConstantValueVariableUseInspection$VariableReadVisitor.visitPrefixExpression must not be null");
            }
            if (this.read || this.written) {
                return;
            }
            super.visitPrefixExpression(prefixExpression);
            PsiJavaToken operationSign = prefixExpression.getOperationSign();
            IElementType tokenType = operationSign.getTokenType();
            if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
                return;
            }
            PsiExpression operand = prefixExpression.getOperand();
            if (!(operand instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)operand;
            PsiElement target = referenceExpression.resolve();
            if (!this.variable.equals(target)) {
                return;
            }
            this.written = true;
        }

        public void visitPostfixExpression(@NotNull PsiPostfixExpression postfixExpression) {
            if (postfixExpression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/dataflow/ConstantValueVariableUseInspection$VariableReadVisitor.visitPostfixExpression must not be null");
            }
            if (this.read || this.written) {
                return;
            }
            super.visitPostfixExpression(postfixExpression);
            PsiJavaToken operationSign = postfixExpression.getOperationSign();
            IElementType tokenType = operationSign.getTokenType();
            if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
                return;
            }
            PsiExpression operand = postfixExpression.getOperand();
            if (!(operand instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)operand;
            PsiElement target = referenceExpression.resolve();
            if (!this.variable.equals(target)) {
                return;
            }
            this.written = true;
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            if (variable == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/dataflow/ConstantValueVariableUseInspection$VariableReadVisitor.visitVariable must not be null");
            }
            if (this.read || this.written) {
                return;
            }
            super.visitVariable(variable);
            PsiExpression initalizer = variable.getInitializer();
            if (initalizer == null) {
                return;
            }
            VariableUsedVisitor visitor = new VariableUsedVisitor(variable);
            initalizer.accept((PsiElementVisitor)visitor);
            this.read = visitor.isUsed();
            this.reference = visitor.getReference();
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            PsiExpression[] arguments;
            if (call == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/dataflow/ConstantValueVariableUseInspection$VariableReadVisitor.visitMethodCallExpression must not be null");
            }
            if (this.read || this.written) {
                return;
            }
            super.visitMethodCallExpression(call);
            PsiExpressionList argumentList = call.getArgumentList();
            for (PsiExpression argument : arguments = argumentList.getExpressions()) {
                VariableUsedVisitor visitor = new VariableUsedVisitor(this.variable);
                argument.accept((PsiElementVisitor)visitor);
                if (!visitor.isUsed()) continue;
                this.read = true;
                this.reference = visitor.getReference();
                return;
            }
        }

        public void visitNewExpression(@NotNull PsiNewExpression newExpression) {
            PsiExpression[] arguments;
            if (newExpression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/dataflow/ConstantValueVariableUseInspection$VariableReadVisitor.visitNewExpression must not be null");
            }
            if (this.read || this.written) {
                return;
            }
            super.visitNewExpression(newExpression);
            PsiExpressionList argumentList = newExpression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            for (PsiExpression argument : arguments = argumentList.getExpressions()) {
                VariableUsedVisitor visitor = new VariableUsedVisitor(this.variable);
                argument.accept((PsiElementVisitor)visitor);
                if (!visitor.isUsed()) continue;
                this.read = true;
                this.reference = visitor.getReference();
                return;
            }
        }

        public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression) {
            PsiExpression[] arguments;
            if (this.read || this.written) {
                return;
            }
            super.visitArrayInitializerExpression(expression);
            for (PsiExpression argument : arguments = expression.getInitializers()) {
                VariableUsedVisitor visitor = new VariableUsedVisitor(this.variable);
                argument.accept((PsiElementVisitor)visitor);
                if (!visitor.isUsed()) continue;
                this.read = true;
                this.reference = visitor.getReference();
                return;
            }
        }

        public void visitReturnStatement(@NotNull PsiReturnStatement returnStatement) {
            if (returnStatement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/dataflow/ConstantValueVariableUseInspection$VariableReadVisitor.visitReturnStatement must not be null");
            }
            if (this.read || this.written) {
                return;
            }
            super.visitReturnStatement(returnStatement);
            PsiExpression returnValue = returnStatement.getReturnValue();
            if (returnValue == null) {
                return;
            }
            VariableUsedVisitor visitor = new VariableUsedVisitor(this.variable);
            returnValue.accept((PsiElementVisitor)visitor);
            this.read = visitor.isUsed();
            this.reference = visitor.getReference();
        }

        public void visitClass(PsiClass aClass) {
            if (this.read || this.written) {
                return;
            }
            super.visitClass(aClass);
            VariableUsedVisitor visitor = new VariableUsedVisitor(this.variable);
            aClass.accept((PsiElementVisitor)visitor);
            this.read = visitor.isUsed();
            this.reference = visitor.getReference();
        }

        public boolean isRead() {
            return this.read;
        }

        public PsiReferenceExpression getReference() {
            return this.reference;
        }
    }

    private static class ConstantValueVariableUseVisitor
    extends BaseInspectionVisitor {
        private ConstantValueVariableUseVisitor() {
        }

        public void visitIfStatement(PsiIfStatement statement) {
            super.visitIfStatement(statement);
            PsiExpression condition = statement.getCondition();
            PsiStatement body = statement.getThenBranch();
            this.checkCondition(condition, body);
        }

        public void visitWhileStatement(PsiWhileStatement statement) {
            super.visitWhileStatement(statement);
            PsiExpression condition = statement.getCondition();
            PsiStatement body = statement.getBody();
            this.checkCondition(condition, body);
        }

        public void visitForStatement(PsiForStatement statement) {
            super.visitForStatement(statement);
            PsiExpression condition = statement.getCondition();
            PsiStatement body = statement.getBody();
            this.checkCondition(condition, body);
        }

        private boolean checkCondition(@Nullable PsiExpression condition, @Nullable PsiStatement body) {
            if (body == null) {
                return false;
            }
            if (!(condition instanceof PsiBinaryExpression)) {
                return false;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition;
            IElementType tokenType = binaryExpression.getOperationTokenType();
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            if (JavaTokenType.ANDAND == tokenType) {
                return this.checkCondition(lhs, body) || this.checkCondition(rhs, body);
            }
            if (JavaTokenType.EQEQ != tokenType) {
                return false;
            }
            if (rhs == null) {
                return false;
            }
            if (PsiUtil.isConstantExpression((PsiExpression)lhs)) {
                return this.checkConstantValueVariableUse(rhs, lhs, (PsiElement)body);
            }
            if (PsiUtil.isConstantExpression((PsiExpression)rhs)) {
                return this.checkConstantValueVariableUse(lhs, rhs, (PsiElement)body);
            }
            return false;
        }

        private boolean checkConstantValueVariableUse(@Nullable PsiExpression expression, @NotNull PsiExpression constantExpression, @NotNull PsiElement body) {
            if (constantExpression == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/dataflow/ConstantValueVariableUseInspection$ConstantValueVariableUseVisitor.checkConstantValueVariableUse must not be null");
            }
            if (body == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/siyeh/ig/dataflow/ConstantValueVariableUseInspection$ConstantValueVariableUseVisitor.checkConstantValueVariableUse must not be null");
            }
            PsiType constantType = constantExpression.getType();
            if (PsiType.DOUBLE.equals(constantType)) {
                Object result = ExpressionUtils.computeConstantExpression(constantExpression, false);
                if (Double.valueOf(0.0).equals(result) || Double.valueOf(-0.0).equals(result)) {
                    return false;
                }
            }
            if (!(expression instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiVariable)) {
                return false;
            }
            if (target instanceof PsiField) {
                return false;
            }
            PsiVariable variable = (PsiVariable)target;
            VariableReadVisitor visitor = new VariableReadVisitor(variable);
            body.accept((PsiElementVisitor)visitor);
            if (!visitor.isRead()) {
                return false;
            }
            this.registerError((PsiElement)visitor.getReference(), constantExpression);
            return true;
        }
    }

    private static class ReplaceReferenceWithExpressionFix
    extends InspectionGadgetsFix {
        private final PsiExpression expression;

        ReplaceReferenceWithExpressionFix(PsiExpression expression) {
            this.expression = expression;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("replace.reference.with.expression.quickfix", this.expression.getText());
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/dataflow/ConstantValueVariableUseInspection$ReplaceReferenceWithExpressionFix.getName must not return null");
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            element.replace((PsiElement)this.expression);
        }
    }
}

